package demos.gears;

import static javax.media.opengl.GLDrawableFactory.getFactory;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.*;
import javax.media.opengl.*;
import javax.media.opengl.awt.GLCanvas;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;

public class TextureTest{

	// 出力画像サイズ
	private static int width = 300;
	private static int height = 300;
	
    private static final int WIDTH = 300;
    private static final int HEIGHT = 300;

	private static Texture texture = null;

	private static Animator animator = null;

	public static void main(String args[])
	throws IOException
	{
		Frame frame = new Frame("Texture Polygon");

		// 3D��`�悷��R���|�[�l���g
		GLCanvas canvas = new GLCanvas();

		canvas.addGLEventListener(
				new GLEventListener(){
					// 初期化
					public void init(GLAutoDrawable dr)
					{
						try
						{
							texture = TextureIO.newTexture(
									new File("jpg/grand_sample_tex.jpg"), true);
						}
						catch(IOException ioex){}
					}

					public void display(GLAutoDrawable dr)
					{
						GL2 gl = dr.getGL().getGL2();
						GLUT glut = new GLUT();

						gl.glViewport(0, 0, width, height);
						// 平行投影
						gl.glMatrixMode(GL2.GL_PROJECTION);
						gl.glLoadIdentity();
						gl.glOrtho(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);

						// 背景テクスチャを描画
						gl.glClear(GL2.GL_COLOR_BUFFER_BIT |GL2.GL_DEPTH_BUFFER_BIT );
						gl.glDisable(GL2.GL_DEPTH_TEST);
						texture.enable();
						gl.glBindTexture(GL2.GL_TEXTURE_2D, 
								texture.getTextureObject());
						gl.glBegin(GL2.GL_QUADS);
						gl.glTexCoord2f(0.0f, 1.0f);
						gl.glVertex2f(-1.0f, -1.0f);
						gl.glTexCoord2f(0.0f, 0.0f);
						gl.glVertex2f(-1.0f, 1.0f);
						gl.glTexCoord2f(1.0f, 0.0f);
						gl.glVertex2f(1.0f, 1.0f);
						gl.glTexCoord2f(1.0f, 1.0f);
						gl.glVertex2f(1.0f, -1.0f);
						gl.glEnd();
						texture.disable();

						// 透視投影
						gl.glMatrixMode(GL2.GL_PROJECTION);
						gl.glLoadIdentity();
						float ratio = (float)height/(float)width;
						gl.glFrustum(-1.0f, 1.0f, -ratio, ratio,
								5.0f, 40.0f);

						gl.glMatrixMode(GL2.GL_MODELVIEW);
						gl.glLoadIdentity();
						gl.glTranslatef(0.0f, 0.0f, -7.0f);

						gl.glEnable(GL2.GL_LIGHTING);
						gl.glEnable(GL2.GL_LIGHT0);
						gl.glEnable(gl.GL_COLOR_MATERIAL);
						gl.glEnable(GL2.GL_NORMALIZE);
						gl.glEnable(GL2.GL_DEPTH_TEST);
						gl.glEnable(GL2.GL_CULL_FACE);

						gl.glPushMatrix();
						// 面の色を設定
						gl.glColor3f(
								(float)0x77/(float)0xff, 
								(float)0x99/(float)0xff, 
								(float)0xff/(float)0xff
						);
						// X軸回転
						gl.glRotatef(10.0f, 1.0f, 0.0f, 0.0f);
						// Y軸回転
						gl.glRotatef(20.0f, 0.0f, 1.0f, 0.0f);
						// 8面体を描画
						glut.glutSolidOctahedron();
						gl.glPopMatrix();

					}

					public void reshape(
							GLAutoDrawable dr,
							int x, int y,
							int width, int height){}

					public void displayChanged(
							GLAutoDrawable dr,
							boolean modeChanged,
							boolean deviceChanged){}

					@Override
					public void dispose(GLAutoDrawable arg0) {
						// TODO Auto-generated method stub
						
					}
				}
		);

        frame.add(canvas);
        frame.setSize(WIDTH, HEIGHT);
		
        animator = new Animator(canvas);

        frame.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    animator.stop();
                    System.exit(0);
                }
            });
        frame.setVisible(true);
        animator.start();
	}
}