package demos.gears;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;

public class TexturePolygon implements GLEventListener {
    private static final int WIDTH = 200;
    private static final int HEIGHT = 200;
    private static final float CAMERA = -10.0f;

    // ���C�g
    private static final float[] LPOSITION = { -10.0f, 10.0f, 10.0f, 0.0f };
    private static final float[] LSPECULAR = { 0.5f, 0.5f, 0.5f, 1.0f };
    private static final float[] LDIFFUSE = { 0.5f, 0.5f, 0.5f, 1.0f };
    private static final float[] LAMBIENT = { 0.8f, 0.8f, 0.8f, 1.0f };

    // ���̂̔��˗�
    private static final float[] MSPECULAR = { 0.0f, 0.0f, 0.0f, 1.0f };
    private static final float[] MDIFFUSE = { 0.0f, 0.0f, 0.0f, 1.0f };
    private static final float[] MAMBIENT = { 1.0f, 1.0f, 1.0f, 1.0f };
    private static final float MSHININESS = 10.0f;

    private GL2 gl2;
    private Animator animator;
    
    private int prevMouseX;
    private int prevMouseY;
    private float angleX = 0.0f;
    private float angleY = 0.0f;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;

    public TexturePolygon() {
        Frame frame = new Frame("Texture Polygon");
        
        // 3D��`�悷��R���|�[�l���g
        GLCanvas canvas = new GLCanvas();
        canvas.addGLEventListener(this);

        frame.add(canvas);
        frame.setSize(WIDTH, HEIGHT);

        canvas.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent e) {
                    prevMouseX = e.getX();
                    prevMouseY = e.getY();
                }
            });

        canvas.addMouseMotionListener(new MouseMotionAdapter() {
                public void mouseDragged(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();

                    if (e.isShiftDown()) {
                        // �ړ��ʂ̎Z�o
                        float diffX = (float)(x - prevMouseX)/10.0f;
                        float diffY = (float)(prevMouseY - y)/10.0f;
		    
                        // �ړ��ʂ̍X�V
                        distanceX += diffX;
                        distanceY += diffY;
                    } else {	    
                        Dimension size = e.getComponent().getSize();

                        // ��]�ʂ̎Z�o
                        // �E�B���h�E�̒[����[�܂łŁA360�x��]����悤�ɂ���
                        float thetaY = 360.0f * ((float)(x-prevMouseX)/size.width);
                        float thetaX = 360.0f * ((float)(prevMouseY-y)/size.height);
		    
                        // �p�x�̍X�V
                        angleX -= thetaX;
                        angleY += thetaY;
                    }

                    // ���݂̃}�E�X�̈ʒu��ۑ�
                    prevMouseX = x;
                    prevMouseY = y;
                }
            });

        animator = new Animator(canvas);

        frame.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    animator.stop();
                    System.exit(0);
                }
            });
        frame.setVisible(true);
        animator.start();
    }

    public void init(GLAutoDrawable drawable) {
        gl2 = drawable.getGL().getGL2();

        gl2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

        gl2.glEnable(GL2.GL_DEPTH_TEST);
        gl2.glEnable(GL2.GL_CULL_FACE);

        gl2.glEnable(GL2.GL_LIGHTING);
        gl2.glEnable(GL2.GL_LIGHT0);

        gl2.glEnable(GL2.GL_NORMALIZE);

        gl2.glLightfv(GL2.GL_LIGHT0, GL2.GL_POSITION, LPOSITION, 0);
        gl2.glLightfv(GL2.GL_LIGHT0, GL2.GL_SPECULAR, LSPECULAR, 0);
        gl2.glLightfv(GL2.GL_LIGHT0, GL2.GL_DIFFUSE, LDIFFUSE, 0);
        gl2.glLightfv(GL2.GL_LIGHT0, GL2.GL_AMBIENT, LAMBIENT, 0);

        gl2.glMaterialfv(GL2.GL_FRONT, GL2.GL_SPECULAR, MSPECULAR, 0);
        gl2.glMaterialfv(GL2.GL_FRONT, GL2.GL_DIFFUSE, MDIFFUSE, 0);
        gl2.glMaterialfv(GL2.GL_FRONT, GL2.GL_AMBIENT, MAMBIENT, 0);
        gl2.glMaterialf(GL2.GL_FRONT, GL2.GL_SHININESS, MSHININESS);

        try {
            File imageFile = new File("jpg/grand_sample_tex.jpg");
            Texture texture = TextureIO.newTexture(imageFile, true);
            texture.enable();
            texture.bind();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void reshape(GLAutoDrawable drawable,
                        int x, int y,
                        int width, int height) {
        float ratio = (float)height / (float)width * 1.0f;
        
        gl2.glViewport(0, 0, width, height);

        gl2.glMatrixMode(GL2.GL_PROJECTION);
        gl2.glLoadIdentity();
        gl2.glFrustum(-1.0f, 1.0f, -ratio, ratio,
                     5.0f, 40.0f);

        gl2.glMatrixMode(GL2.GL_MODELVIEW);
        gl2.glLoadIdentity();
        gl2.glTranslatef(0.0f, 0.0f, CAMERA);
    }

    public void display(GLAutoDrawable drawable) {
        gl2.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);

        gl2.glPushMatrix();

        // �}�E�X�̈ړ��ʂɉ����Ĉړ�
        gl2.glTranslatef(distanceX, distanceY, 0.0f);

        // �}�E�X�̈ړ��ʂɉ����ĉ�]
        gl2.glRotatef(angleX, 1.0f, 0.0f, 0.0f);
        gl2.glRotatef(angleY, 0.0f, 1.0f, 0.0f);

        // �|���S���̕`��
        drawPolygon();
 
        gl2.glPopMatrix();
    }

    public void displayChanged(GLAutoDrawable drawable,
                               boolean modeChanged,
                               boolean deviceChanged) {}
 
    // �|���S���̕`��
    private void drawPolygon() {

        // �|���S����`�悷�邱�Ƃ��w��
        gl2.glBegin(GL2.GL_POLYGON);

        // �|���S���̊e���_���w�肷��O��
        // �e�N�X�`���̍��W���w�肷��
        gl2.glTexCoord2f(0.0f, 0.0f);
        gl2.glVertex3f(-1.0f, -1.0f,  0.0f);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex3f(1.0f, -1.0f,  0.0f);
        gl2.glTexCoord2f(1.0f, 1.0f);
        gl2.glVertex3f(1.0f,  1.0f,  0.0f);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex3f(-1.0f,  1.0f,  0.0f);

        gl2.glEnd();
    }

    public static void main(String[] args) {
        new TexturePolygon();
    }

	@Override
	public void dispose(GLAutoDrawable arg0) {
		// TODO Auto-generated method stub
		
	}
}
