package demos.gears;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.gl2.GLUT;


public class ObjectTester implements GLEventListener, MouseListener, MouseMotionListener {
    private int WIDTH = 200;
    private int HEIGHT = 200;
    private float CAMERA = -25.0f;

    // ライト
    private float[] LPOSITION = { -10.0f, 10.0f, 10.0f, 0.0f };
    private float[] LSPECULAR = { 0.2f, 0.2f, 0.2f, 1.0f };
    private float[] LDIFFUSE = { 0.5f, 0.5f, 0.5f, 1.0f };
    private float[] LAMBIENT = { 0.8f, 0.8f, 0.8f, 1.0f };

    // 物体の反射率
    private float[] MSPECULAR = { 0.5f, 0.5f, 0.5f, 1.0f };
    private float[] MDIFFUSE = { 0.5f, 0.5f, 0.5f, 1.0f };
    private float[] MAMBIENT = { 0.5f, 0.5f, 0.5f, 1.0f };
    private float MSHININESS = 10.0f;

    // 単位
    private float UNIT = 1.0f;
    private float SCALE = 0.5f;

    // 胴体のサイズ
    private float BODY_WIDTH = SCALE;
    private float BODY_HEIGHT = SCALE;
    private float BODY_DEPTH = SCALE * 0.5f;

    // 腕のサイズと位置
    private float ARM_WIDTH = SCALE * 0.2f;
    private float ARM_HEIGHT = SCALE * 1.2f;
    private float ARM_DEPTH = SCALE * 0.2f;
    private float ARM_X = SCALE * 0.65f;
    private float ARM_Y = SCALE * 0.5f;

    // 足のサイズと位置
    private float LEG_WIDTH = SCALE * 0.2f;
    private float LEG_HEIGHT = SCALE * 1.0f;
    private float LEG_DEPTH = SCALE * 0.2f;
    private float LEG_X = SCALE * 0.3f;
    private float LEG_Y = -SCALE * 0.55f;

    // 頭のサイズと位置
    private float HEAD_RADIUS = SCALE * 0.4f;
    private int HEAD_SLICES = 20;
    private int HEAD_STACKS = 20;
    private float HEAD_Y = SCALE * 0.95f;

    private GL2 gl;
    private GLUT glut;
    private Animator animator;
    
    private int prevMouseX;
    private int prevMouseY;
    private float angleX = 0.0f;
    private float angleY = 0.0f;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;

    private static final float MAX_ANGLE = 30.0f;
    private float limbAngle;
    private boolean limbMode;

    private float robotAngle;

    public ObjectTester() {
        JFrame jFrame = new JFrame("Object Tester");

        // 3Dを描画するコンポーネント
        // GLJPanelは遅いのでキャンバスを利用
        GLCanvas canvas = new GLCanvas();
        
        canvas.addGLEventListener(this);
        
        jFrame.add(canvas);
        
        jFrame.setSize(WIDTH, HEIGHT);
        
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);

        animator = new Animator(canvas);
        
        jFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                animator.stop();
                System.exit(0);
            }
        });
        
        jFrame.setVisible(true);
        animator.start();
    }

    public void init(GLAutoDrawable drawable) {
        gl = drawable.getGL().getGL2();
        glut = new GLUT();

        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

        gl.glEnable(GL2.GL_DEPTH_TEST);
        gl.glEnable(GL2.GL_CULL_FACE);

//        gl.glEnable(GL2.GL_LIGHTING);
//        gl.glEnable(GL2.GL_LIGHT0);
//
//        gl.glEnable(GL2.GL_NORMALIZE);
//
//        gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_POSITION, LPOSITION, 0);
//        gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_SPECULAR, LSPECULAR, 0);
//        gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_DIFFUSE, LDIFFUSE, 0);
//        gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_AMBIENT, LAMBIENT, 0);
//
//        gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_SPECULAR, MSPECULAR, 0);
//        gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_DIFFUSE, MDIFFUSE, 0);
//        gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_AMBIENT, MAMBIENT, 0);
//        gl.glMaterialf(GL2.GL_FRONT, GL2.GL_SHININESS, MSHININESS);
    }

    public void reshape(GLAutoDrawable drawable,
                        int x, int y,
                        int width, int height) {
        float ratio = (float)height / (float)width;
        
        gl.glViewport(0, 0, width, height);

        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();
        gl.glFrustum(-1.0f, 1.0f, -ratio, ratio,
                     5.0f, 40.0f);

        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
        gl.glTranslatef(0.0f, 0.0f, CAMERA);
    }

    public void display(GLAutoDrawable drawable) {
        gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
    	
        gl.glPushMatrix();

        // マウスの移動量に応じて移動
        gl.glTranslatef(distanceX, distanceY, 0.0f);
 
        // マウスの移動量に応じて回転
        gl.glRotatef(angleX, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(angleY, 0.0f, 0.0f, 1.0f);

        // オブジェクト
        test();
 
        gl.glPopMatrix();
    }

    public void displayChanged(GLAutoDrawable drawable,
                               boolean modeChanged,
                               boolean deviceChanged) {}
 
    // オブジェクト
    private void test() {
        // 触覚
        // 右
        gl.glPushMatrix();
        gl.glTranslatef(0.2f, 3.4f, 0.0f);
        gl.glRotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.2f, 1.0f);
        gl.glVertex3f(0.0f, 0.7f, 0.7f);
        gl.glEnd();
        gl.glPopMatrix(); 
        // 左
        gl.glPushMatrix();
        gl.glTranslatef(-0.2f, 3.4f, 0.0f);
        gl.glRotatef(20.0f, 0.0f, 0.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.2f, 1.0f);
        gl.glVertex3f(0.0f, 0.7f, 0.7f);
        gl.glEnd();
        gl.glPopMatrix(); 
        
        // 頭
        gl.glPushMatrix();
        gl.glTranslatef(0.0f, 2.4f, 0.0f);
        gl.glScalef(1.0f, 1.13f, 1.0f);
        glut.glutSolidSphere(1.1f, 20, 20);
        gl.glPopMatrix();   
        
        // 足
        // 前右足
        gl.glPushMatrix();
        gl.glRotatef(40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(1.1f, 0.0f, 1.1f);
        gl.glVertex3f(2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();   
        // 前左足
        gl.glPushMatrix();
        gl.glRotatef(-40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(-1.1f, 0.0f, 1.1f);
        gl.glVertex3f(-2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();
        // 中右足
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(1.1f, 0.0f, 1.1f);
        gl.glVertex3f(2.0f, 0.0f, -1.3f);
        gl.glEnd();
        // 中左足
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(-1.1f, 0.0f, 1.1f);
        gl.glVertex3f(-2.0f, 0.0f, -1.3f);
        gl.glEnd();
        // 後右足
        gl.glPushMatrix();
        gl.glRotatef(-40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(1.1f, 0.0f, 1.1f);
        gl.glVertex3f(2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();   
        // 後左足
        gl.glPushMatrix();
        gl.glRotatef(40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(-1.1f, 0.0f, 1.1f);
        gl.glVertex3f(-2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();       
        
        // 真ん中
        gl.glPushMatrix();
        gl.glScalef(1.0f, 1.5625f, 1.0f);
        glut.glutSolidSphere(0.8f, 20, 20);
        gl.glPopMatrix();       
        
        // おしり
        gl.glPushMatrix();
        gl.glTranslatef(0.0f, -2.7f, 0.0f);
        gl.glScalef(1.0f, 1.15f, 1.0f);
        glut.glutSolidSphere(1.3f, 20, 20);
        gl.glPopMatrix();      
    }

    public static void main(String[] args) {
        new ObjectTester();
    }

	public void dispose(GLAutoDrawable arg0) {}

	// ドラッグ
	public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();

        if (e.isShiftDown()) {
            // 移動量の算出
            float diffX = (float)(x - prevMouseX)/10.0f;
            float diffY = (float)(prevMouseY - y)/10.0f;

            // 移動量の更新
            distanceX += diffX;
            distanceY += diffY;
        } else {	    
            Dimension size = e.getComponent().getSize();

            // 回転量の算出
            // ウィンドウの端から端までで、360度回転するようにする
            float thetaY = 360.0f * ((float)(x-prevMouseX)/size.width);
            float thetaX = 360.0f * ((float)(prevMouseY-y)/size.height);

            // 角度の更新
            angleX -= thetaX;
            angleY += thetaY;
        }

        // 現在のマウスの位置を保存
        prevMouseX = x;
        prevMouseY = y;
	}

	public void mouseMoved(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}

	// マウスを押したとき
	public void mousePressed(MouseEvent e) {
        prevMouseX = e.getX();
        prevMouseY = e.getY();
	}
	
	public void mouseReleased(MouseEvent e) {}
}

