package agent;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

import javax.imageio.ImageIO;

import manager.Manager;

// 自律虫集合
public class Autonomous_Bug_Set {

	// 管理クラス
	private Manager manager = new Manager();

	public static final int energy_limit = 1600;	// 突然変異のエネルギー数
	public static final int energy_half = 800;		// 突然変異後のエネルギー
	public static final int abs_init_count = 100;
	private int max_abs_count = 0;
	private int abs_count = 0;
	private int ab_id = 0;

	// 座標(x,y)にいる自律虫の数の配列 (0523)
	// 1つの餌をみんなで当分して食べます
	public ArrayList<ArrayList<LinkedList<Autonomous_Bug>>> ab_coordinate = null;

	// 自律虫
	public HashMap<Integer, Autonomous_Bug> abSet = null;

	// 自律虫画像
	public BufferedImage autonomous_bug = null;

	// コンストラクタ
	public Autonomous_Bug_Set(Manager manager){
		ab_coordinate = new ArrayList<ArrayList<LinkedList<Autonomous_Bug>>>();
		for(int i=0;i<100;i++){
			ab_coordinate.add(new ArrayList<LinkedList<Autonomous_Bug>>());
			for(int j=0;j<100;j++)
				ab_coordinate.get(i).add(new LinkedList<Autonomous_Bug>());
		}

		abs_count = abs_init_count;
		max_abs_count = abs_count;
		// 画像読み込み
		readImage();
		// abSetの初期化
		abSet = new HashMap<Integer, Autonomous_Bug>();

	}

	// 自律虫画像読み込みメソッド
	private void readImage(){
		// 画像のロード
		try{
			autonomous_bug = ImageIO.read(new File("png/autonomous_bug.png"));
		}
		catch(IOException ie){
			ie.printStackTrace();
		}
	}

	public int getCurrentAbsCount() {
		return this.abs_count;
	}

	public void absIncrement() {
		abs_count++;
	}

	public void absDecrement() {
		abs_count--;
	}

	public int getMaxAbsCount() {
		return this.max_abs_count;
	}

	public void setMaxAbsCount(int max) {
		this.max_abs_count = max;
	}

	// 自律虫のID発行 + IDをプラス1
	public int getAB_ID() {
		return ab_id++;
	}

	// 現在のエネルギー最大値算出メソッド
	public int getMaxEnergy(Manager manager) {
		int max = 0;
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			max = (max < ab.energy) ? ab.energy : max;
		}
		return max;
	}

	// 現在のエネルギー最小値算出メソッド
	public int getMinEnergy(Manager manager) {
		int min = Integer.MAX_VALUE;
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			min = (min > ab.energy) ? ab.energy : min;
		}
		return min;
	}

	// 現在のエネルギー平均値算出メソッド
	public int getAveEnergy(Manager manager) {
		int ave = 0;
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ave += ab.energy;
		}
		return (int)((double)ave/manager.abs.abSet.size());
	}

	// 長老(生きているステップが最大の虫)の歳(ステップ数)を返すメソッド
	public int getElderSteps(Manager manager) {
		int step = 0;
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			step = (step < ab.ab_step) ? ab.ab_step : step;
		}
		return step;
	}

	// 若者(生きているステップが最小の虫)の歳(ステップ数)を返すメソッド
	public int getYoungerSteps(Manager manager) {
		int step = Integer.MAX_VALUE;
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			step = (step > ab.ab_step) ? ab.ab_step : step;
		}
		return step;
	}

	// 虫達の平均年齢を返すメソッド
	public int getAverageSteps(Manager manager) {
		int step_ave = 0;
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			step_ave += ab.ab_step;
		}
		return (int)((double)step_ave/manager.abs.abSet.size());
	}



	public void set_initial_behavior(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.initial_behavior = input;
		}
	}

	public void set_diff_behavior(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.diff_behavior = input;
		}
	}

	public void set_energy_rod(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.energy_rod = input;
		}
	}

	public void set_energy_diff(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.energy_diff = input;
		}
	}

	public void set_energy_init(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.energy_init = input;
		}
	}

	public void set_rest_turn(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.rest_turn = input;
		}
	}

	public void set_energy_rest(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.energy_rest = input;
		}
	}

	public void set_rest(int input, Manager manager){
		Autonomous_Bug ab;
		for(int key : manager.abs.abSet.keySet()){
			ab = manager.abs.abSet.get(key);
			ab.rest = input;
		}
	}
}
