package agent;

import java.util.Random;



// 自律虫
public class Autonomous_Bug {

	// ユーザ定義変数		[5021]
	public double initial_behavior = 2.0;		// 行動評価初期値
	public double diff_behavior = 0.2;			// 獲得分の行動評価値の増加分
	public int energy_rod = 100;				// エネルギー減少率
	public int energy_diff = 500;				// エサ取得時の増分
	public int energy_init = 1000;				// エネルギーの初期値
	private double mutation_weight = 1;

	public int rest_turn = 5;					// 何回に1回行動するか
	public int energy_rest = 200;				// 行動が遅くなるエネルギー
	public int rest;							// 死にそうな時は(rest_turn)ターンに1回行動

	public int id;					// 虫のID

	// 定数
	// heading
	private static final int N = 0;
	private static final int NE = 1;
	private static final int E = 2;
	private static final int SE = 3;
	private static final int S = 4;
	private static final int SW = 5;
	private static final int W = 6;
	private static final int NW = 7;


	private static final int F = 0;
	private static final int HR = 1;
	private static final int HL = 2;
	private static final int R = 3;
	private static final int L = 4;
	private static final int HRB = 5;
	private static final int HLB = 6;

	public static final int NONE = 0;
	public static final int DIV = 1;
	public static final int DEATH = 2;

	// フィールド
	public int x;						// x座標
	public int y;						// y座標
	public int lastX;					// 前回のx座標
	public int lastY;					// 前回のy座標
	public int energy;					// エネルギー
	public int heading = N;				// 頭の向き
	public int lastH;					// 前回の頭の向き
	public int move;					// 進行方向
	public double[] table;				// 行動評価テーブル
	public double eval_sum = 0.0;		// 行動評価合計数 (Σe^biに相当)	[0521]
	public int ab_step	= 0;					// 虫の年齢	[0523]


	// コンストラクタ
	public Autonomous_Bug(int id){
		this.id = id;
		// 生まれた時は0歳
		ab_step = 0;


		// 初期座標(x0,y0)はランダム
		x = 20;//(int)(100.0 * Math.random());
		y = 20;//(int)(100.0 * Math.random());
		// 初期状態における頭の向きはランダム
		Random rnd = new Random();
		heading = rnd.nextInt(8);

		// 前の座標値を初期化
		lastX = x;
		lastY = y;
		lastH = heading;

		// 評価テーブルの初期化		[0521]
		table = new double[7];
		for(int i=0; i<table.length; i++)
			eval_sum += table[i] = initial_behavior;

		// 初期エネルギーは1000
		energy = energy_init;

	}

	// コンストラクタ (mutation用) [0522]
	public Autonomous_Bug(int id, int x, int y, int energy, double[] table){
		this.id = id;
		// 生まれた時は0歳
		ab_step = 0;


		int mutation = 0;
		// 初期座標(x0,y0)は親の隣接位置
		this.x = x;
		this.y = y;
		// 初期状態における頭の向きはランダム
		Random rnd = new Random();
		heading = rnd.nextInt(8);

		// 前の座標値を初期化
		lastX = x;
		lastY = y;
		lastH = heading;

		// 乱数生成
		mutation = rnd.nextInt(7);

		// 評価テーブルの初期化		[0521]
		this.table = new double[7];
		// 評価テーブルに突然変異を適用
		for(int i=0; i<this.table.length; i++)
			eval_sum +=
				this.table[i] =
					(i==mutation) ? mutation_weight : table[i];


		// 初期エネルギーは親の半分
		this.energy = energy;
	}

	// 行動関数(0523変更@本庄)
	public int action(){

		int ab_state = NONE;		// return用の状態変数

		// 分裂判定
		if(energy>=Autonomous_Bug_Set.energy_limit) ab_state = DIV;

		// エネルギーを減少
		energy -= energy_rod;
		//System.out.println("energy:"+this.energy);
		//System.out.println("table("+table[0]+","+table[1]+","+table[2]+","+table[3]+","+table[4]+","+table[5]+","+table[6]+")");

		// 死亡判定
		if(energy<=0) return DEATH;

		double rand = 0.0;
		double eval_temp = 0.0;
		move = 0;
		eval_sum = 0.0;

		// 前回の座標,行動を保存
		lastX = x;
		lastY = y;
		lastH = heading;

		// 行動評価のための処理	[0521]
		for(int i = 0; i < table.length; i++)
			eval_sum += table[i];

		// 行動決定アルゴリズム		[0521]
		rand = Math.random() * eval_sum;
		if(rand > table[0]) {
			for(move = 1; move < table.length; move++) {
				eval_temp += table[move-1];
				if(eval_temp < rand && rand <= (eval_temp + table[move]))
					break;
			}
		}

		switch(move){
		case F :
			break;
		case HR :
			heading++;
			break;
		case HL :
			heading--;
			break;
		case R :
			heading += 2;
			break;
		case L :
			heading -= 2;
			break;
		case HRB :
			heading +=3;
			break;
		case HLB :
			heading -= 3;
			break;
		default :
			System.out.println("action : error");
		}

		if(heading<0) heading += 8;
		else if(heading>=8) heading -= 8;

		switch(heading){
			case N :
				y--;
				break;
			case NE :
				x++;
				y--;
				break;
			case E :
				x++;
				break;
			case SE :
				x++;
				y++;
				break;
			case S :
				y++;
				break;
			case SW :
				x--;
				y++;
				break;
			case W :
				x--;
				break;
			case NW :
				x--;
				y--;
				break;
			default :
				System.out.println("action : error");
		}

		// トーラス
		if(x<0) x += 100;
		else if(x>=100) x -= 100;

		if(y<0) y += 100;
		else if(y>=100) y -= 100;

		return ab_state;
	}

	// 餌を取得したら、エネルギーを増加させるメソッド	[0521]
	// 餌を等分させる
	public void increaseEnergy(int ab_num) {
		this.energy += (int)( (double)energy_diff / (double)ab_num );
	}

	// 行動評価改善用のメソッド					[0521]
	public void setTable() {
		int diffHeading;

		if(Math.abs(this.heading - lastH)>3)
			diffHeading = (this.heading < lastH) ? 2 * ((8 + this.heading) - lastH) - 1 : 2 * ((8 + lastH) - this.heading);
		else
			diffHeading = (this.heading <= lastH) ? 2 * (lastH - this.heading) : 2 * (this.heading - lastH) - 1;
		this.table[diffHeading] += diff_behavior;
	}

	// mutation用　エネルギーを半分にするメソッド	[0522]
	public void setEnergy() {
		this.energy /= 2;
	}

	// mutation用　評価テーブルを半分にするメソッド	[0522]
	public void setHalfTable() {
		for(int i=0; i<this.table.length; i++)
		this.table[i] /= 2.0;
	}
	// 歳を取らせるメソッド
	public void addStep() {
		this.ab_step++;
	}

}
