#include "oltImage.h"
#include "OlthrusSystem.h"

int oltImageWidth_str(const oltImage & target)
{
	return target.handle->nWidth_str;
}
int oltImageWidth_pix(const oltImage & target)
{
	return target.handle->nWidth_pix;
}
int oltImageWidth(const oltImage & target)
{
	return oltImageWidth_str(target);
}

int oltImageHeight_str(const oltImage & target)
{
	return target.handle->nHeight_str;
}
int oltImageHeight_pix(const oltImage & target)
{
	return target.handle->nHeight_pix;
}
int oltImageHeight(const oltImage & target)
{
	return oltImageHeight_str(target);
}

float oltGetImage_fX_pix(const oltImage & target)
{
	return target.fX;
}
float oltGetImage_fX_str(const oltImage & target)
{
	return target.fX/oltFontWidth();
}
float oltGetImage_fX(const oltImage & target)
{
	return oltGetImage_fX_str(target);
}

float oltGetImage_fY_pix(const oltImage & target)
{
	return target.fY;
}
float oltGetImage_fY_str(const oltImage & target)
{
	return target.fY/oltFontHeight();
}
float oltGetImage_fY(const oltImage & target)
{
	return oltGetImage_fY_str(target);
}

int oltGetImage_nX_pix(const oltImage & target)
{
	return (int)target.fX;
}
int oltGetImage_nX_str(const oltImage & target)
{
	return (int)target.fX/oltFontWidth();
}
int oltGetImage_nX(const oltImage & target)
{
	return oltGetImage_nX_str(target);
}

int oltGetImage_nY_pix(const oltImage & target)
{
	return (int)target.fY;
}
int oltGetImage_nY_str(const oltImage & target)
{
	return (int)target.fY/oltFontHeight();
}
int oltGetImage_nY(const oltImage & target)
{
	return oltGetImage_nY_str(target);
}
