#include "oltImage.h"
#include "elstring.h"
#include "oltTable.h"
#include "BMPManager.h"
#include "CSRGB.h"
#include "OlthrusSystem.h"
#include "AlphaColor.h"


bool oltLoadImage(oltImage & image, const char * path)
{
	image.handle = (oltImgHandle)malloc(sizeof(oltImgData));
	aaTDot & dotss = image.handle->dotss;
	aaTDotInit(dotss);
	oltTableRegist(image);

	const unsigned int dotPblock = oltFontWidth() * oltFontHeight();

	BMPManager bmpm;
	initBMPM(bmpm);
	if (loadBMPM(bmpm, path) == false)
	{
		endBMPM(bmpm);
		return false;
	}
	int blocksize = BlockSizeBMPM(bmpm);

	image.handle->nWidth_pix = widthBMPM(bmpm);
	image.handle->nHeight_pix = heightBMPM(bmpm);
	image.handle->nWidth_str = image.handle->nWidth_pix / oltFontWidth();
	image.handle->nHeight_str = image.handle->nHeight_pix / oltFontHeight();
	aaTDotSetsize(dotss, image.handle->nHeight_str);
	for (unsigned int nDotsIndex = 0; nDotsIndex < aaTDotSize(dotss); ++nDotsIndex)
	{
		aTDot & dots = aaTDotAt(dotss, nDotsIndex);
		aTDotInit(dots);
		aTDotSetsize(dots, image.handle->nWidth_str);

		for (unsigned int nDotIndex = 0; nDotIndex < aTDotSize(dots); ++nDotIndex)
		{
			TDot & dot = aTDotAt(dots, nDotIndex);
			dot.nX = (int)nDotIndex;
			dot.nY = (int)nDotsIndex;
		}
	}

	for (int nBlockIndex = 0; nBlockIndex < blocksize; ++nBlockIndex)
	{
		CSRGB csbgr;
		initCSBGR(csbgr);
		for (int nDotIndex = 0; (unsigned int) (nDotIndex) < dotPblock; ++nDotIndex)
		{
			const int nX = blockToXBMPM(bmpm, nBlockIndex);
			const int nY = blockToYBMPM(bmpm, nBlockIndex);
			const BGR & bgr = BGRonBlockDotBMPM(bmpm, nX, nY, nDotIndex);
			addCSBGR(csbgr, bgr);
		}
		averageCSBGR(csbgr, dotPblock);	// computing average

		char colorcode = ColorCode(csbgr);

		int nX = blockToXBMPM(bmpm, nBlockIndex);
		int nY = blockToYBMPM(bmpm, nBlockIndex);

		aTDot & dots = aaTDotAt(dotss, nY);
		TDot & dot = aTDotAt(dots, nX);

		dot.nColor = colorcode;
	}

	endBMPM(bmpm);

	return true;
}

unsigned int private_ComputeBlockIndex(const unsigned int nDotX, const unsigned int nDotY)
{
	unsigned int nBlockX = nDotX / oltFontWidth();
	unsigned int nBlockY = nDotY / oltFontHeight();

	return oltScreenWidth()*nBlockY + nBlockX;
}

bool oltLoadImage_a(oltImage & image, const char * path)	// todo
{
	image.handle = (oltImgHandle)malloc(sizeof(oltImgData));
	aaTDot & dotss = image.handle->dotss;
	aaTDotInit(dotss);
	oltTableRegist(image);

	const unsigned int dotPblock = oltFontWidth() * oltFontHeight();

	BMPManager bmpm;
	initBMPM(bmpm);
	if (loadBMPM(bmpm, path) == false)
	{
		endBMPM(bmpm);
		return false;
	}

	image.handle->nWidth_pix = widthBMPM(bmpm);
	image.handle->nHeight_pix = heightBMPM(bmpm);
	image.handle->nWidth_str = image.handle->nWidth_pix / oltFontWidth();
	image.handle->nHeight_str = image.handle->nHeight_pix / oltFontHeight();
	aaTDotSetsize(dotss, image.handle->nHeight_str);
	for (unsigned int nDotsIndex = 0; nDotsIndex < aaTDotSize(dotss); ++nDotsIndex)
	{
		aTDot & dots = aaTDotAt(dotss, nDotsIndex);
		aTDotInit(dots);
		aTDotSetsize(dots, image.handle->nWidth_str);

		for (unsigned int nDotIndex = 0, nXIndex = 0; nXIndex < aTDotSize(dots); ++nDotIndex, ++nXIndex)
		{

			CSRGB csbgr;
			initCSBGR(csbgr);

			//*
			for (unsigned int nPixelIndex = 0; nPixelIndex < dotPblock; ++nPixelIndex)
			{
				const int nBlockIndex = private_ComputeBlockIndex(nDotIndex, nDotsIndex);
				const BGR & bgr = BGRonBlockDotBMPM(bmpm, nDotIndex, nDotsIndex, nPixelIndex);
				addCSBGR(csbgr, bgr);
			}
			averageCSBGR(csbgr, dotPblock);	// computing average

			int nBaseColCode = CSRGB_to_ColorCode(csbgr);
			//*/

			/*
			csbgr.r = 0xff;
			csbgr.g = 0xff;
			csbgr.b = 0xff;
			int nBaseColCode = 0;
			if (nDotIndex < 5 && nDotsIndex<5)
			{
				nBaseColCode = oltAlphaColor();
			}
			//*/
			//*
			if (nBaseColCode == oltAlphaColor())
			{
				aTDotPop(dots);
				--nXIndex;
				continue;
			}
			//*/

			TDot & dot = aTDotAt(dots, nXIndex);

			dot.nColor = ColorCode(csbgr);
			dot.nX = nDotIndex;
			dot.nY = nDotsIndex;


		}
	}

	endBMPM(bmpm);

	return true;
}

void oltCopyImgData(oltImage & target, const oltImage & base)
{
	target.handle = base.handle;
}