#include "oltImage.h"

void draw(const oltImage & target, int nX, int nY)
{
	aaTDot & dotss = target.handle->dotss;
	for (unsigned int nDotsIndex = 0; nDotsIndex < aaTDotSize(dotss); ++nDotsIndex)
	{
		aTDot & dots = aaTDotAt(dotss, nDotsIndex);
		for (unsigned int nDotIndex = 0; nDotIndex < aTDotSize(dots); ++nDotIndex)
		{
			TDot & dot = aTDotAt(dots, nDotIndex);
			oltDrawTDot_rel(dot, nX, nY);
		}
	}
}

void oltDrawImage(const oltImage & target)
{
	draw(target, oltGetImage_nX(target), oltGetImage_nY(target));
}

void oltDrawImage_rel(const oltImage & target, float fX, float fY)
{
	draw(target, (int)(fX+oltGetImage_fX(target)), (int)(fY+oltGetImage_fY(target)));
}



