#include "elstring.h"

#pragma warning(push)
#pragma warning(disable:4996)

DefElasticArray(char)

void elsInit(elstring & target)
{
	acharInit(target);
	acharAdd(target, '\0');
}
void elsRequre(elstring & target, int nSize)
{
	acharRequre(target, nSize);
}
void elsAppend(elstring & target, const char * str)
{
	acharSetsize(target, strlen(str)+1);
	strcpy(target.pContents, str);
}
void elsConcat(elstring & target, const char * str)
{
	elsConcat_from(target, elsSize(target), str);
}
void elsConcat_from(elstring & target, int nFrom, const char * str)
{
	acharAddsize(target, strlen(str));
	char * pcFrom = target.pContents + nFrom;
	strcpy(pcFrom, str);
}
void elsConcat_code(elstring & target, char cCode)
{
	acharAddsize(target, 2);
	int nLastIndex = elsSize(target);
	acharAt(target, nLastIndex) = cCode;
	acharAt(target, nLastIndex + 1) = '\0';
}
void elsConcat_int(elstring & target, int num)
{
	char buff[16];
	itoa(num, buff, 10);
	elsConcat(target, buff);
}
const char * elsC_str(const elstring & target)
{
	return target.pContents;
}
int elsSize(const elstring & target)
{
	return strlen(target.pContents);
}
elstring elsSubstr(const elstring & target, int nBeg, int nLen)
{
	elstring myels;
	elsInit(myels);
	memcpy(myels.pContents, target.pContents + nBeg, nLen);
	return myels;
}
elstring elsSubstr_dex(const elstring & target, int nBeg, int nEnd)
{
	return elsSubstr(target, nBeg, nEnd - nBeg);
}
elstring elsSubstr_head(const elstring & target, int nLen)
{
	elstring myels;
	elsInit(myels);
	elsAt(myels, nLen) = '\0';
	return myels;
}
const char * elsTail(const elstring & target, int nHead)
{
	return target.pContents + nHead;
}
char & elsAt(elstring & target, int nIndex)
{
	return target.pContents[nIndex];
}
const char & elsAt_c(const elstring & target, int nIndex)
{
	return target.pContents[nIndex];
}
void elsEnd(elstring & target)
{
	acharEnd(target);
}

#pragma warning(pop)