#include "OlthrusSystem.h"
#include <string.h>
#include "TText.h"

void oltInitTText(TText & target)
{
	elsInit(target.text);
}


void draw(const TText & text, float nRecX, float nRecY)
{
	int nTextBeg = 0;
	int nTextSize = elsSize(text.text);
	int nX = (int) nRecX;

	if (nRecY < 0) return;
	if (nX >= oltScreenWidth() ) return;
	if (nRecY >= oltScreenHeight() ) return;

	if (nX < 0)
	{
		if (nX + nTextSize < 0) return;
		nTextBeg = nX*-1;
		nX = 0;
		nTextSize -= nTextBeg;

		// SpɑΉ
#		if 1
		char cCode = elsAt_c(text.text, nTextBeg - 1);
		if (TheZenkaku(cCode))
		{
			++nTextBeg;
		}
#		endif
	}
	if (nX + nTextSize > oltScreenWidth() )
	{
		nTextSize = oltScreenWidth() - nX;

		// SpɑΉ
#		if 1
		char cCode = elsAt_c(text.text, oltScreenWidth() - 1);
		if (TheZenkaku(cCode))
		{
			--nTextSize;
		}
#		endif
	}

	memcpy(&(AccessScreen(nX, (int) nRecY)), &(elsAt_c(text.text, nTextBeg)), nTextSize);
	for (int i = 0; i < nTextSize; ++i)
	{
		AccessColor(nX + i, (int) nRecY) = text.nColor;
		AccessBGColor(nX + i, (int) nRecY) = text.nBGColor;
	}
}

void oltDrawTText(const TText & text)
{
	draw(text, text.fX, text.fY);
}


void oltDrawTText_rel(const TText & text, float fX, float fY)
{
	draw(text, fX + text.fX, fY + text.fY);
}


void oltEndTText(TText & target)
{
	elsEnd(target.text);
}