#include "TSentence.h"

DefElasticArray(TText)	// Define aTText

void oltInitTSentence(TSentence & target)
{
	aTTextInit(target);
}

void oltDrawTSentence(const TSentence & sentence)
{
	for (unsigned int nSentIndex = 0; nSentIndex < aTTextSize(sentence); ++nSentIndex)
	{
		const TText & text = aTTextAt_c(sentence, nSentIndex);
		oltDrawTText(text);
	}
}

void oltDrawTSentence_rel(const TSentence & sentence, float fX, float fY)
{
	for (unsigned int nSentIndex = 0; nSentIndex < aTTextSize(sentence); ++nSentIndex)
	{
		const TText & text = aTTextAt_c(sentence, nSentIndex);
		oltDrawTText_rel(text, fX, fY);
	}
}

void oltEndTSentence(TSentence & target)
{
	for (unsigned int nSentIndex = 0; nSentIndex < aTTextSize(target); ++nSentIndex)
	{
		TText & text = aTTextAt(target, nSentIndex);
		oltEndTText(text);
	}

	aTTextEnd(target);
}

#if 0

#include "OlthrusSystem.h"

int oltSentenceSize(const TSentence & sentence)
{
	return sentence.nSize;
}

TText & oltSentenceAt(TSentence & sentence, int nIndex)
{
	return sentence.pContents[nIndex];
}
const TText & oltSentenceAt_c(const TSentence & sentence, int nIndex)
{
	return sentence.pContents[nIndex];
}

#endif