#include "OlthrusSystem.h"
#include "TDot.h"

void private_tdot_draw(int nColor, int nX, int nY)
{
	if (nX < 0) return;
	if (nY < 0) return;
	if (nX >= oltScreenWidth() ) return;
	if (nY >= oltScreenHeight() ) return;

	AccessScreen(nX, nY) = ' ';	// Xy[X
	AccessBGColor(nX, nY) = nColor;
}

void oltDrawTDot(const TDot & dot)
{
	private_tdot_draw(dot.nColor, dot.nX, dot.nY);
}

void oltDrawTDot_rel(const TDot & target, int nX, int nY)
{
	private_tdot_draw(target.nColor, nX + target.nX, nY + target.nY);
}