#include "OlthrusSystem.h"
#include <CScreen.h>

void SwapScreen()
{
	g_cCSDBScreenSwitch ^= 1;
}

void fps60()
{
	do
	{
		clock_t now = clock();
		if (now - g_CSDBTimer >= 33)
		{
			g_CSDBTimer = now;
			break;
		}
	} while (true);
}


int IndexToX(int nIndex)
{
	return nIndex%oltScreenWidth();
}

int IndexToY(int nIndex)
{
	return nIndex / oltScreenWidth();
}


int SameColNum(int nBeg, int & nTextCol)
{
	nTextCol = aintAt_c(AfterScreen().pnColor, nBeg);
	int nBGCol = aintAt_c(AfterScreen().pnBGColor, nBeg);
	int nIndex = nBeg;

	if (acharAt_c(AfterScreen().szText, nBeg) == ' '/*space*/)
	{
		nTextCol = -1;
	}

	for (; nIndex < oltMaxScreenIndex(); ++nIndex)
	{
		if (aintAt_c(AfterScreen().pnBGColor, nIndex) != nBGCol)
		{
			break;
		}

		if (acharAt_c(AfterScreen().szText, nIndex) != ' '/*space*/)
		{
			if (nTextCol != -1)
			{
				if (aintAt_c(AfterScreen().pnColor, nIndex) != nTextCol)
				{
					break;
				}
			}
			else
			{
				nTextCol = aintAt_c(AfterScreen().pnColor, nIndex);
			}
		}
	}

	return nIndex - nBeg;
}

bool SameBefAft(int nBeg, int nSameColNum, int & nDefBeg)
{
	for (int nIndex = nBeg; nIndex < nBeg + nSameColNum; ++nIndex)
	{
		if (aintAt_c(AfterScreen().pnBGColor, nIndex) != aintAt_c(BeforeScreen().pnBGColor, nIndex))
		{
			nDefBeg = nIndex;
			return false;
		}

		if (acharAt_c(AfterScreen().szText, nIndex) != acharAt_c(BeforeScreen().szText, nIndex))
		{
			nDefBeg = nIndex;
			return false;
		}

		if (acharAt_c(AfterScreen().szText, nIndex) != ' '/*space*/)
		{
			if (aintAt_c(AfterScreen().pnColor, nIndex) != aintAt_c(BeforeScreen().pnColor, nIndex))
			{
				nDefBeg = nIndex;
				return false;
			}
		}
	}

	return true;
}

int DefNum(int nBeg, int nDefBeg, int nSameColNum)
{
	int nDefNum = nBeg+nSameColNum -nDefBeg;

	for (; nDefNum > 1; --nDefNum)
	{
		int nIndex = nDefBeg + nDefNum - 1;
		if (aintAt_c(AfterScreen().pnBGColor, nIndex) != aintAt_c(BeforeScreen().pnBGColor, nIndex)) return nDefNum;
		if (acharAt_c(AfterScreen().szText, nIndex) != acharAt_c(BeforeScreen().szText, nIndex)) return nDefNum;
		if (acharAt_c(AfterScreen().szText, nIndex) != ' '/*space*/)
		{
			if (aintAt_c(AfterScreen().pnColor, nIndex) != aintAt_c(BeforeScreen().pnColor, nIndex)) return nDefNum;
		}
	}

	return 1;
}

void draw(int nBeg, int nNum, int nTextCol)
{
	LOCATE(IndexToX(nBeg)+1, IndexToY(nBeg)+1);
	COLOR(nTextCol, aintAt_c(AfterScreen().pnBGColor, nBeg));
	char & r_cWord = acharAt(AfterScreen().szText, nBeg + nNum);
	char strage = r_cWord;
	r_cWord = '\0';
	printf("%s", &(acharAt_c(AfterScreen().szText, nBeg)));
	r_cWord = strage;
}


void oltShowScreen()
{
	int nBeg = 0;

	while (true)
	{
		// Jnn_ƓFĂ邩
		// Jnn_In_܂łׂđOƓǂׂ
		// uׂēvł͂ȂꍇĂJnn_ƍŌ̈Ăn_ÅԂ`悷
		// Jnn_In_̎ɐݒ肷

		if (nBeg >= oltMaxScreenIndex()) break;
		int nTextCol;
		int nSameColNum = SameColNum(nBeg, nTextCol);
		int nDefBeg;
		bool bResult = SameBefAft(nBeg, nSameColNum, nDefBeg);
		if (bResult == false)
		{
			int nDefNum = DefNum(nBeg, nDefBeg, nSameColNum);
			draw(nDefBeg, nDefNum, nTextCol);
		}
		nBeg += nSameColNum;
	}

	SwapScreen();

	LOCATE(oltScreenWidth(), oltScreenHeight() );

	if (g_bCSDBTimerFlag) fps60();
}