#include "OlthrusSystem.h"
#include "TScreen.h"
#include <stdlib.h>
#include <CScreen.h>
#include "oltTable.h"
#include "EoltFontSizeType.h"
#include "AlphaColor.h"

void oltInit(EoltFontSizeType enoltFontSizeType, int nScreenWidth, int nScreenHeight, bool bTimerFlag)
{
	if (enoltFontSizeType == eFontSizeType_3_5)
	{
		oltSetFontWidth(3);
		oltSetFontHeight(5);
	}

	if (enoltFontSizeType == eFontSizeType_5_8)
	{
		oltSetFontWidth(5);
		oltSetFontHeight(8);
	}

	if (enoltFontSizeType == eFontSizeType_6_13)
	{
		oltSetFontWidth(6);
		oltSetFontHeight(13);
	}

	if (enoltFontSizeType == eFontSizeType_8_18)
	{
		oltSetFontWidth(8);
		oltSetFontHeight(18);
	}

	oltSetScreenWidth(nScreenWidth, oltFontWidth() );
	oltSetScreenHeight(nScreenHeight, oltFontHeight() );


	g_bCSDBTimerFlag = bTimerFlag;
	if (g_bCSDBTimerFlag) g_CSDBTimer = clock();

	g_cCSDBScreenSwitch = 0;
	g_pCSDBScreens[0] = (TScreen *)malloc(sizeof(TScreen) );
	g_pCSDBScreens[1] = (TScreen *)malloc(sizeof(TScreen) );

	InitTScreen(BeforeScreen());
	InitTScreen(AfterScreen());

	for (int nScreenIndex = 0; nScreenIndex < oltMaxScreenIndex(); ++nScreenIndex)
	{
		acharAt(BeforeScreen().szText, nScreenIndex) = ' ';
		aintAt(BeforeScreen().pnColor, nScreenIndex) = BLACK;
		aintAt(BeforeScreen().pnBGColor, nScreenIndex) = BLACK;
	}

	acharAt(BeforeScreen().szText, oltMaxScreenIndex()) = '\0';
	LOCATE(1, 1);
	COLOR(BLACK, BLACK);
	printf(elsC_str(BeforeScreen().szText));

	oltTableInit();

	oltInitAlphaColor();
}