#include <stdlib.h>
#include <string.h>


# define DecElasticArray(type)														\
	typedef struct																	\
	{																				\
		type * pContents;															\
		unsigned int nSize;															\
		unsigned int nSpace;														\
	} a##type;																		\
																					\
	void a##type##Init(a##type & target);											\
	unsigned int a##type##Size(const a##type & target);								\
	void a##type##Resecure(a##type & target, unsigned int nNewspace);				\
	type & a##type##At(a##type & target, unsigned int nIndex);						\
	const type & a##type##At_c(const a##type & target, unsigned int nIndex);		\
	type & a##type##Last(a##type & target);											\
	void a##type##End(a##type & target);											\
	void a##type##Secure(a##type & target, unsigned int nSize);						\
	void a##type##Requre(a##type & target, unsigned int nReqsize);					\
	void a##type##Addcure(a##type & target, int nAddsize);							\
	void a##type##Popcure(a##type & target, int nPopsize);							\
	void a##type##Zerocure(a##type & target);										\
	void a##type##Addsize(a##type & target, int nSize);								\
	const type & a##type##Add(a##type & target, const type & req);					\
	void a##type##Popsize(a##type & target, int nSize);								\
	void a##type##Pop(a##type & target);											\
	void a##type##Setsize(a##type & target, unsigned int nSize);					\
	void a##type##Reqsize(a##type & target, unsigned int nSize);					\


# define DefElasticArray(type)														\
	void a##type##Init(a##type & target)											\
	{																				\
		target.pContents = (type *) 0/* null_ptr */;								\
		target.nSize = 0;															\
		target.nSpace = 0;															\
	}																				\
																					\
	unsigned int a##type##Size(const a##type & target)								\
	{																				\
		return target.nSize;														\
	}																				\
																					\
	void a##type##Resecure(a##type & target, unsigned int nNewspace)				\
	{																				\
		type * newcont = (type *) malloc(sizeof(type) *nNewspace);					\
		if (target.pContents != (type *)0/*null_ptr*/)								\
		{																			\
			unsigned int nSize = target.nSize;										\
			if (nSize > nNewspace) nSize = nNewspace;								\
			memcpy(newcont, target.pContents, nSize);								\
			free(target.pContents);													\
		}																			\
		target.pContents = newcont;													\
		target.nSpace = nNewspace;													\
	}																				\
																					\
	type & a##type##At(a##type & target, unsigned int nIndex)						\
	{																				\
		return target.pContents[nIndex];											\
	}																				\
	const type & a##type##At_c(const a##type & target, unsigned int nIndex)			\
	{																				\
		return target.pContents[nIndex];											\
	}																				\
	type & a##type##Last(a##type & target)											\
	{																				\
		return a##type##At(target, target.nSize - 1);								\
	}																				\
																					\
	void a##type##End(a##type & target)												\
	{																				\
		if (target.pContents != (type *)0/*null_ptr*/)								\
		{																			\
			free(target.pContents);													\
			target.pContents = (type *)0/*null_ptr*/;								\
		}																			\
	}																				\
																					\
	void a##type##Secure(a##type & target, unsigned int nSize)						\
	{																				\
		if (nSize != target.nSpace) a##type##Resecure(target, nSize);				\
	}																				\
	void a##type##Requre(a##type & target, unsigned int nReqsize)					\
	{																				\
		if (nReqsize > target.nSpace) a##type##Resecure(target, nReqsize);			\
	}																				\
	void a##type##Addcure(a##type & target, int nAddsize)							\
	{																				\
		nAddsize = target.nSpace + nAddsize;										\
		if (nAddsize < 0) nAddsize = 0;												\
		a##type##Resecure(target, nAddsize);										\
	}																				\
	void a##type##Popcure(a##type & target, int nPopsize)							\
	{																				\
		nPopsize = target.nSpace - nPopsize;										\
		if (nPopsize < 0) nPopsize = 0;												\
		a##type##Secure(target, nPopsize);											\
	}																				\
	void a##type##Zerocure(a##type & target)										\
	{																				\
		a##type##Secure(target, 0);													\
	}																				\
																					\
	void a##type##Addsize(a##type & target, int nSize)								\
	{																				\
		int nNeedsize = (int)target.nSize + nSize;									\
		if (nNeedsize < 0) nNeedsize = 0;											\
		if ( (unsigned int)nNeedsize > target.nSpace)								\
		{																			\
			unsigned int nNewSize = nNeedsize * 2;									\
			if (nNewSize == 2) nNewSize = 256;										\
			a##type##Resecure(target, nNewSize);									\
		}																			\
		target.nSize += nSize;														\
	}																				\
																					\
	const type & a##type##Add(a##type & target, const type & req)					\
	{																				\
		a##type##Addsize(target, 1);												\
		a##type##Last(target) = req;												\
		return req;																	\
	}																				\
																					\
	void a##type##Popsize(a##type & target, int nSize)								\
	{																				\
		a##type##Addsize(target, -nSize);											\
	}																				\
	void a##type##Pop(a##type & target)												\
	{																				\
		a##type##Popsize(target, 1);												\
	}																				\
																					\
	void a##type##Setsize(a##type & target, unsigned int nSize)						\
	{																				\
		int gap = nSize - target.nSize;												\
		a##type##Addsize(target, gap);												\
	}																				\
																					\
	void a##type##Reqsize(a##type & target, unsigned int nSize)						\
	{																				\
		if (nSize > target.nSize)													\
		{																			\
			a##type##Addsize(target, target.nSize - nSize);							\
		}																			\
	}																				\






