#include "ColorList.h"

void initColorList(ColorList & colist)
{
	aBGRInit(colist.BGRs);
	BGR bgr;

	bgr.r = 0;
	bgr.g = 0;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0;
	bgr.g = 0;
	bgr.b = 0x80;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0;
	bgr.g = 0x80;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0;
	bgr.g = 0x80;
	bgr.b = 0x80;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0x80;
	bgr.g = 0;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0x80;
	bgr.g = 0;
	bgr.b = 0x80;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0x80;
	bgr.g = 0x80;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0xc0;
	bgr.g = 0xc0;
	bgr.b = 0xc0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0x80;
	bgr.g = 0x80;
	bgr.b = 0x80;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0;
	bgr.g = 0;
	bgr.b = 0xff;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0;
	bgr.g = 0xff;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0;
	bgr.g = 0xff;
	bgr.b = 0xff;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0xff;
	bgr.g = 0;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0xff;
	bgr.g = 0;
	bgr.b = 0xff;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0xff;
	bgr.g = 0xff;
	bgr.b = 0;
	aBGRAdd(colist.BGRs, bgr);

	bgr.r = 0xff;
	bgr.g = 0xff;
	bgr.b = 0xff;
	aBGRAdd(colist.BGRs, bgr);
}

void endColorList(ColorList & colist)
{
	aBGREnd(colist.BGRs);
}

const BGR & bgrColorList(const ColorList & colist, int index)
{
	return aBGRAt_c(colist.BGRs, index);
}
