#include "CSRGB.h"
#include "ColorList.h"
#include "OlthrusSystem.h"

char ColorCode(const CSRGB & csrgb)
{
	typedef unsigned int uint;

	CSRGB colist[] = {
		{ 0, 0, 0 },
		{ 0, 0, 0x80 },
		{ 0, 0x80, 0 },
		{ 0, 0x80, 0x80 },
		{ 0x80, 0, 0 },
		{ 0x80, 0, 0x80 },
		{ 0x80, 0x80, 0 },
		{ 0xc0, 0xc0, 0xc0 },
		{ 0x80, 0x80, 0x80 },
		{ 0, 0, 0xff },
		{ 0, 0xff, 0 },
		{ 0, 0xff, 0xff },
		{ 0xff, 0, 0 },
		{ 0xff, 0, 0xff },
		{ 0xff, 0xff, 0 },
		{ 0xff, 0xff, 0xff },
	};

	uint r = csrgb.r;
	uint g = csrgb.g;
	uint b = csrgb.b;

	uint dist2 = r*r + g*g + b*b;
	char code = 0;

	for (int i = 1; i < COLORS16NUM; ++i)
	{
		int r = (int) (csrgb.r) - (int) (colist[i].r);
		int g = (int) (csrgb.g) - (int) (colist[i].g);
		int b = (int) (csrgb.b) - (int) (colist[i].b);

		uint d2 = b*b + g*g + r*r;

		if (d2 < dist2)
		{
			code = i;
			dist2 = d2;
		}
	}


	return code;
}