#include "CSRGB.h"

void initCSBGR(CSRGB & csbgr)
{
	csbgr.b = 0;
	csbgr.g = 0;
	csbgr.r = 0;
}

void addCSBGR(CSRGB & csbgr, const BGR & bgr)
{
	csbgr.b += bgr.b;
	csbgr.g += bgr.g;
	csbgr.r += bgr.r;
}

void averageCSBGR(CSRGB & csbgr, unsigned int num)
{
	csbgr.b /= num;
	csbgr.g /= num;
	csbgr.r /= num;
}

int CSRGB_to_ColorCode(const CSRGB & csbgr)
{
	int r = csbgr.r * 16*16 * 16*16;
	int g = csbgr.g * 16*16;
	int b = csbgr.b;
	return r + g + b;
}