#pragma once

#include "BGR.h"
#include "BMPImage.h"

typedef struct
{
	BMPImage bmpi;
} BMPManager;

void initBMPM(BMPManager & bmpm);
bool loadBMPM(BMPManager & bmpm, const char * path);
int widthBMPM(const BMPManager & bmpm);
int heightBMPM(const BMPManager & bmpm);
BGR & bgrBMPM(BMPManager & bmpm, const int x, const int y);
const BGR & bgrBMPM_c(const BMPManager & bmpm, const int x, const int y);
const BGR & BGRonBlockDotBMPM(const BMPManager & bmpm, const unsigned int blockX, const unsigned int blockY, unsigned int dotNo);
int BlockSizeBMPM(const BMPManager & bmpm);
int blockToXBMPM(const BMPManager & bmpm, const int blockNo);
int blockToYBMPM(const BMPManager & bmpm, const int blockNo);
int dotToXBMPM(const int dotNo);
int dotToYBMPM(const int dotNo);
int bgrIndexBMPM(const BMPManager & bmpm, const int blockNo, const int dotNo);
void endBMPM(BMPManager & bmpm);
