#include "BGR.h"
#include "BMPImage.h"
#include "BMPManager.h"
#include "OlthrusSystem.h"

void initBMPM(BMPManager & bmpm)
{
	initBMPI(bmpm.bmpi);
}

bool loadBMPM(BMPManager & bmpm, const char * path)
{
	bool res = false;
	res = loadBMPI(bmpm.bmpi, path);

	if (widthBMPI(bmpm.bmpi) % oltFontWidth() != 0)
	{
		printf("摜̉%d̔{łȂΕϊł܂\n", oltFontWidth());
		return false;
	}
	if (heightBMPI(bmpm.bmpi) % oltFontHeight() != 0)
	{
		printf("摜̏c%d̔{łȂΕϊł܂\n", oltFontHeight());
		return false;
	}

	return res;
}

int widthBMPM(const BMPManager & bmpm)
{
	return widthBMPI(bmpm.bmpi);
}
int heightBMPM(const BMPManager & bmpm)
{
	return heightBMPI(bmpm.bmpi);
}

BGR & bgrBMPM(BMPManager & bmpm, const int x, const int y)
{
	return aBGRAt(aaBGRAt(bgrBMPI(bmpm.bmpi), y), x);
}
const BGR & bgrBMPM_c(const BMPManager & bmpm, const int x, const int y)
{
	return aBGRAt_c(aaBGRAt_c(bgrBMPI_c(bmpm.bmpi), y), x);
}
const BGR & BGRonBlockDotBMPM(const BMPManager & bmpm, const unsigned int blockX, const unsigned int blockY, const unsigned int dotNo)
{
	int x = oltFontWidth()*blockX + dotToXBMPM( dotNo);
	int y = oltFontHeight()*blockY + dotToYBMPM( dotNo);

	return  aBGRAt_c(aaBGRAt_c(bgrBMPI_c(bmpm.bmpi), y), x);
}

int BlockSizeBMPM(const BMPManager & bmpm)
{
	int xnum = widthBMPM(bmpm) / oltFontWidth();
	int ynum = heightBMPM(bmpm) / oltFontHeight();

	return xnum * ynum;
}

int blockToXBMPM(const BMPManager & bmpm, const int blockNo)
{
	return blockNo % (widthBMPM(bmpm) / oltFontWidth());
}

int blockToYBMPM(const BMPManager & bmpm, const int blockNo)
{
	return blockNo / (widthBMPM(bmpm) / oltFontWidth());
}

int dotToXBMPM(const int dotNo)
{
	return dotNo%oltFontWidth();
}

int dotToYBMPM(const int dotNo)
{
	return dotNo / oltFontWidth();
}

int bgrIndexBMPM(const BMPManager & bmpm, const int blockNo, const int dotNo)
{
	int x = blockToXBMPM(bmpm, blockNo) + dotToXBMPM(dotNo);
	int y = blockToYBMPM(bmpm, blockNo) + dotToYBMPM(dotNo);

	return  widthBMPM(bmpm)*y + x;
}

void endBMPM(BMPManager & bmpm)
{
	endBMPI(bmpm.bmpi);
}
