#pragma once

#include <stdio.h>
#include "BGR.h"
#include "ElasticArray.h"
#include "elstring.h"


typedef unsigned int uint;

typedef struct
{
	uint Width;
	uint Height;
	aaBGR mybgr;
	bool ReverseFlag;

} BMPImage;

void initBMPI(BMPImage & bmpi);
bool loadBMPI(BMPImage & bmpi, const char * path);
bool loadBMPI(BMPImage & bmpi, const elstring & path);
uint widthBMPI(const BMPImage & bmpi);
uint heightBMPI(const BMPImage & bmpi);
aaBGR & bgrBMPI(BMPImage & bmpi);
const aaBGR & bgrBMPI_c(const BMPImage & bmpi);
void endBMPI(BMPImage & bmpi);

	typedef struct
	{
		unsigned char B;
		unsigned char M;
		unsigned long  bfSize;
		unsigned short bfReserved1;
		unsigned short bfReserved2;
		unsigned long  bfOffBits;

	} BITMAPFILEHEADER;

	typedef struct
	{
		unsigned long  bcSize;
		short          bcWidth;
		short          bcHeight;
		unsigned short bcPlanes;
		unsigned short bcBitCount;

	} BITMAPCOREHEADER;

	typedef struct
	{
		unsigned long  biSize;
		long           biWidth;
		long           biHeight;
		unsigned short biPlanes;
		unsigned short biBitCount;
		unsigned long  biCompression;
		unsigned long  biSizeImage;
		long           biXPixPerMeter;
		long           biYPixPerMeter;
		unsigned long  biClrUsed;
		unsigned long  biClrImporant;

	} BITMAPINFOHEADER;


	// @return	ǂ
	bool LoadHeaderBMPI(BMPImage & bmpi, FILE * fp);

	// @return	ǂ
	bool LoadInfoBMPI(BMPImage & bmpi, FILE * fp);
	// @return	ǂ
	bool LoadRGBBMPI(BMPImage & bmpi, FILE * fp);
