#include "BMPImage.h"

#pragma warning(push)
#pragma warning(disable:4996)

void initBMPI(BMPImage & bmpi)
{
	aaBGRInit(bmpi.mybgr);
}

bool loadBMPI(BMPImage & bmpi, const char * path)
{
	FILE * fp = fopen(path, "rb");

	if (fp == NULL)
	{
		printf("t@CJ܂ł\n");
		return false;
	}

	if (LoadHeaderBMPI(bmpi, fp) == false)
	{
		return false;
	}

	if (LoadInfoBMPI(bmpi, fp) == false)	// ̎_w,h킩
	{
		return false;
	}

	bmpi.ReverseFlag = true;
	if (heightBMPI(bmpi) < 0)
	{
		bmpi.Height = heightBMPI(bmpi)*-1;
		bmpi.ReverseFlag = false;
	}
	aaBGRSetsize(bmpi.mybgr, heightBMPI(bmpi));
	for (int i = 0; i < int(heightBMPI(bmpi)); ++i)
	{
		aBGR & BGRs = aaBGRAt(bmpi.mybgr, i);
		aBGRInit(BGRs);
		aBGRSetsize(BGRs, widthBMPI(bmpi));	// todo memcpy.asm not found
	}

	bool result = false;
	result = LoadRGBBMPI(bmpi, fp);	// todo memcpy.asm not found


	fclose(fp);

	return result;
}
bool loadBMPI(BMPImage & bmpi, const elstring & path)
{
	return loadBMPI(bmpi, elsC_str(path));
}
uint widthBMPI(const BMPImage & bmpi){ return bmpi.Width; }
uint heightBMPI(const BMPImage & bmpi){ return bmpi.Height; }
aaBGR & bgrBMPI(BMPImage & bmpi){ return bmpi.mybgr; }
const aaBGR & bgrBMPI_c(const BMPImage & bmpi){ return bmpi.mybgr; }


// @return	ǂ
bool LoadHeaderBMPI(BMPImage & bmpi, FILE * fp)
{

	BITMAPFILEHEADER header;

	if (fread(&header, 14, 1, fp) == 0) return false;

	if (header.B != 'B' || header.M != 'M') return false;

	return true;
}

// @return	ǂ
bool LoadInfoBMPI(BMPImage & bmpi, FILE * fp)
{

	const char rgbmode_OS2 = 0;
	const char rgbmode_win = 1;

	int size = 0;
	char rgbmode;

	if (fread(&size, 4, 1, fp) == 0) return false;
	if (fseek(fp, -4, SEEK_CUR) != 0) return false;

	unsigned short BitCount;
	unsigned long compression = 0;

	if (size == 12)
	{
		BITMAPCOREHEADER info;

		if (fread(&info, 12, 1, fp) == 0) return false;

		bmpi.Width = info.bcWidth;
		bmpi.Height = info.bcHeight;
		BitCount = info.bcBitCount;
		rgbmode = rgbmode_OS2;
	}
	if (size == 40)
	{
		BITMAPINFOHEADER info;

		if (fread(&info, 40, 1, fp) == 0) return false;

		bmpi.Width = info.biWidth;
		bmpi.Height = info.biHeight;
		BitCount = info.biBitCount;
		compression = info.biCompression;
		rgbmode = rgbmode_win;
	}
	if (size != 14 && size != 40) return false;

	if (BitCount != 24)
	{
		printf("24bitȊOBMPt@Cɂ͑ΉĂ܂B\n");
		return false;
	}
	if (compression != 0)
	{
		printf("kĂBMPt@Cɂ͑ΉĂ܂B\n");
		return false;
	}

	return true;
}

typedef unsigned char uchar;

// @return	ǂ
bool LoadRGBBMPI(BMPImage & bmpi, FILE * fp)
{
	long trash = 0;

	long rem = (3 * widthBMPI(bmpi)) % 4;
	if (rem != 0) trash = 4 - rem;

	for (int i = 0; i < int(heightBMPI(bmpi)); ++i)
	{
		int index = i;
		if (bmpi.ReverseFlag == true) index = heightBMPI(bmpi) - 1 - i;
		aBGR & BGRs = aaBGRAt(bmpi.mybgr, index);

		for (int j = 0; j < int(widthBMPI(bmpi)); ++j)
		{
			BGR & anRGB = aBGRAt(BGRs, j);
			if (fread(&(anRGB.b), sizeof(uchar), 1, fp) == 0) return false;
			if (fread(&(anRGB.g), sizeof(uchar), 1, fp) == 0) return false;
			if (fread(&(anRGB.r), sizeof(uchar), 1, fp) == 0) return false;
		}
		fseek(fp, trash, SEEK_CUR);
	}

	return true;
}

void endBMPI(BMPImage & bmpi)
{
	aaBGREnd(bmpi.mybgr);
}


#pragma warning(pop)