/*
 * Decompiled with CFR 0.152.
 */
package twitclient.url;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class URLShorter {
    private static URLShorter urlShorter = new URLShorter();
    private final String login = "ntrhano";
    private final String apiKey = "R_6c9ec0147d34e4d107eb58845b3cf1fa";
    private final String format = "format=xml";
    private final String shorten = "/v3/shorten";
    private final String expand = "/v3/expand";
    private final String validate = "/v3/validate";
    private final String clicks = "/v3/clicks";
    private String serviceName = "bit.ly";
    private String userLogin = "";
    private String userAPIKey = "";
    private String basicArgs = "";
    private LinkedHashMap<String, String> shortenURLMap = new LinkedHashMap();
    private final String configFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "url_shorten.xml";

    public static URLShorter getInstance() {
        return urlShorter;
    }

    private URLShorter() {
        System.out.println("Read configuration(URL Shorten) from: " + this.configFileName);
        File configFile = new File(this.configFileName);
        if (configFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(configFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node node;
                    int j;
                    NodeList nodelist;
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("url-shorten-service")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.serviceName = node.getNodeValue();
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("user-login")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.userLogin = node.getNodeValue();
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("user-api-key")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.userAPIKey = node.getNodeValue();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.setup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.writeConfigurationFile();
        }
    }

    public void writeConfigurationFile() {
        FileOutputStream out = null;
        try {
            File configFile = new File(this.configFileName);
            File dir = configFile.getParentFile();
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Cannot create client directory");
                System.exit(1);
            }
            out = new FileOutputStream(this.configFileName);
            Document doc = null;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            DOMImplementation impl = bld.getDOMImplementation();
            doc = impl.createDocument("", "config", null);
            doc.setXmlStandalone(true);
            Element root = doc.getDocumentElement();
            Element serv = doc.createElement("url-shorten-service");
            serv.appendChild(doc.createTextNode(this.serviceName));
            Element login = doc.createElement("user-login");
            login.appendChild(doc.createTextNode(this.userLogin));
            Element api = doc.createElement("user-api-key");
            api.appendChild(doc.createTextNode(this.userAPIKey));
            root.appendChild(serv);
            root.appendChild(login);
            root.appendChild(api);
            DOMSource dsrc = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult sr = new StreamResult(out);
            transformer.transform(dsrc, sr);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void setup() {
        this.basicArgs = "login=ntrhano&apiKey=R_6c9ec0147d34e4d107eb58845b3cf1fa&format=xml";
        if (!this.userLogin.isEmpty() && !this.userAPIKey.isEmpty()) {
            try {
                String args = String.valueOf(this.basicArgs) + "&" + "x_login=" + this.userLogin + "&x_apiKey=" + this.userAPIKey;
                String urlStr = "http://api." + this.serviceName + "/v3/validate" + "?" + args;
                URL url = new URL(urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                int status = connection.getResponseCode();
                if (status == 200) {
                    InputStream in = connection.getInputStream();
                    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(in);
                    Element root = doc.getDocumentElement();
                    NodeList valid = root.getElementsByTagName("valid");
                    String isValid = valid.item(0).getTextContent();
                    if (isValid.equals("1")) {
                        this.basicArgs = args;
                    }
                }
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList<String> shortenURL(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        return this.shortenURLs(urls);
    }

    public ArrayList<String> shortenURLs(ArrayList<String> urls) {
        ArrayList<String> results = new ArrayList<String>();
        for (String url : urls) {
            try {
                String encodedURL = URLEncoder.encode(url, "utf-8");
                String args = String.valueOf(this.basicArgs) + "&" + "longUrl=" + encodedURL;
                String urlStr = "http://api." + this.serviceName + "/v3/shorten" + "?" + args;
                URL target = new URL(urlStr);
                HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                int status = connection.getResponseCode();
                if (status == 200) {
                    InputStream in = connection.getInputStream();
                    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(in);
                    Element root = doc.getDocumentElement();
                    NodeList data = root.getElementsByTagName("data");
                    String originalURL = "";
                    String shortenURL = "";
                    int i = 0;
                    while (i < data.getLength()) {
                        NodeList node = (NodeList)((Object)data.item(i));
                        int j = 0;
                        while (j < node.getLength()) {
                            Node n = node.item(j);
                            String name = n.getNodeName();
                            if (name.equals("url")) {
                                shortenURL = n.getTextContent();
                            } else if (!name.equals("hash") && !name.equals("global_hash")) {
                                if (name.equals("long_url")) {
                                    originalURL = n.getTextContent();
                                } else {
                                    name.equals("new_hash");
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (!originalURL.isEmpty() && !shortenURL.isEmpty()) {
                        results.add(shortenURL);
                        this.shortenURLMap.put(shortenURL, originalURL);
                    } else {
                        results.add("");
                    }
                }
                connection.disconnect();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public ArrayList<String> expandShortenURL(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        return this.expandShortenURLs(urls);
    }

    public ArrayList<String> expandShortenURLs(ArrayList<String> urls) {
        ArrayList<String> results = new ArrayList<String>();
        String shortURLs = "";
        for (String url : urls) {
            try {
                String encodedURL = URLEncoder.encode(url, "utf-8");
                shortURLs = String.valueOf(shortURLs) + "&" + "shortUrl=" + encodedURL;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        try {
            String urlStr = "http://api." + this.serviceName + "/v3/expand" + "?" + this.basicArgs + shortURLs;
            URL target = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)target.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 200) {
                InputStream in = connection.getInputStream();
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(in);
                Element root = doc.getDocumentElement();
                NodeList data = root.getElementsByTagName("data");
                String originalURL = "";
                String shortenURL = "";
                int i = 0;
                while (i < data.getLength()) {
                    NodeList node = (NodeList)((Object)data.item(i));
                    int j = 0;
                    while (j < node.getLength()) {
                        Node n = node.item(j);
                        String name = n.getNodeName();
                        if (name.equals("entry")) {
                            NodeList nodelist = n.getChildNodes();
                            int k = 0;
                            while (k < nodelist.getLength()) {
                                n = nodelist.item(k);
                                name = n.getNodeName();
                                if (name.equals("short_url")) {
                                    shortenURL = n.getTextContent();
                                } else if (name.equals("long_url")) {
                                    originalURL = n.getTextContent();
                                } else if (!name.equals("user_hash")) {
                                    name.equals("global_hash");
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!originalURL.isEmpty() && !shortenURL.isEmpty()) {
                    results.add(shortenURL);
                    this.shortenURLMap.put(shortenURL, originalURL);
                } else {
                    results.add("");
                }
            }
            connection.disconnect();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    public boolean hasShortenURLInformation(String url) {
        return this.shortenURLMap.containsKey(url);
    }

    public String getShortenURL(String url) {
        if (this.shortenURLMap.containsValue(url)) {
            for (String key : this.shortenURLMap.keySet()) {
                if (!this.shortenURLMap.get(key).equals(url)) continue;
                return key;
            }
        }
        return "";
    }

    public String getExpandURL(String url) {
        if (this.shortenURLMap.containsKey(url)) {
            return this.shortenURLMap.get(url);
        }
        return "";
    }
}

