/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.gui.ClientComponentConfiguration;

public class TweetViewPanel
extends JPanel {
    private static final long serialVersionUID = 486167012179384019L;
    private JTextArea tweetArea;
    private JLabel iconLabel;

    public TweetViewPanel(Tweet tweet, boolean isSelected) {
        int col = tweet.getText().length() / 20;
        this.tweetArea = new JTextArea(col + 2, 20);
        this.setLayout(new BorderLayout());
        this.tweetArea.setEditable(false);
        this.tweetArea.setLineWrap(true);
        this.tweetArea.setWrapStyleWord(true);
        this.tweetArea.setText(tweet.getTweetText());
        this.setToolTipText(tweet.getTweetInfo());
        ClientComponentConfiguration conf = ClientComponentConfiguration.getInstance();
        String tweetTitle = tweet.getTweetTitle();
        tweetTitle = NTRClient.getInstance().getTwitterController().isFollowingEachOther(tweet.getUser().getId()) ? "+ " + tweetTitle : "! " + tweetTitle;
        if (isSelected) {
            this.tweetArea.setFont(conf.getSelectedTweetFont());
            this.tweetArea.setBackground(conf.getSelectedTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getSelectedTweetForegroundColor());
            TitledBorder border = BorderFactory.createTitledBorder(conf.getUnselectedTweetBorder(), tweetTitle, 0, 0, conf.getSelectedTweetFont(), conf.getSelectedTweetBorderColor());
            this.tweetArea.setBorder(border);
        } else if (!tweet.isRead()) {
            this.tweetArea.setFont(conf.getUnreadTweetFont());
            this.tweetArea.setBackground(conf.getUnreadTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getUnreadTweetForegroundColor());
            TitledBorder border = BorderFactory.createTitledBorder(conf.getUnreadTweetBorder(), tweetTitle, 0, 0, conf.getUnreadTweetFont(), conf.getUnreadTweetBorderColor());
            this.tweetArea.setBorder(border);
        } else if (tweet.isFavorited()) {
            this.tweetArea.setFont(conf.getFavoriteTweetFont());
            this.tweetArea.setBackground(conf.getFavoriteTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getFavoriteTweetForegroundColor());
            TitledBorder border = BorderFactory.createTitledBorder(conf.getFavoriteTweetBorder(), tweetTitle, 0, 0, conf.getFavoriteTweetFont(), conf.getFavoriteTweetBorderColor());
            this.tweetArea.setBorder(border);
        } else {
            this.tweetArea.setFont(conf.getUnselectedTweetFont());
            this.tweetArea.setBackground(conf.getUnselectedTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getUnselectedTweetForegroundColor());
            TitledBorder border = BorderFactory.createTitledBorder(conf.getUnselectedTweetBorder(), tweetTitle, 0, 0, conf.getUnselectedTweetFont(), conf.getUnselectedTweetBorderColor());
            this.tweetArea.setBorder(border);
        }
        this.iconLabel = new JLabel(tweet.getIcon());
        this.add((Component)this.iconLabel, "West");
        this.add((Component)this.tweetArea, "Center");
    }
}

