/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import twitclient.DirectMessage;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.TwitterUserInfo;
import twitclient.gui.ClientShortcutKeyManager;
import twitclient.gui.ReplyChainFrame;
import twitclient.url.URLShorter;

public class PostManager
implements ActionListener,
ListSelectionListener,
KeyListener {
    private static PostManager postManager = new PostManager();
    private ClientShortcutKeyManager shortcutManager = ClientShortcutKeyManager.getInstance();
    private URLShorter urlShorter = URLShorter.getInstance();
    private LinkedHashMap<String, Tweet> selectedTweet = new LinkedHashMap();
    private Tweet replyTarget = null;
    private DirectMessage selectedDirectMessage = null;
    private JTextArea tweetArea;
    private JTextField footerArea;
    private JButton postButton;
    private boolean enableToPost = true;

    public void setTweetArea(JTextArea tweetArea) {
        this.tweetArea = tweetArea;
    }

    public void setFooterArea(JTextField footerArea) {
        this.footerArea = footerArea;
    }

    public void setPostButton(JButton postButton) {
        this.postButton = postButton;
        this.postButton.setForeground(Color.black);
    }

    private PostManager() {
    }

    public static PostManager getInstance() {
        return postManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("send tweet")) {
            this.postTweet();
        } else if (e.getActionCommand().equals("clear footer")) {
            this.footerArea.setText("");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof JList) {
            JList list = (JList)e.getSource();
            Object obj = list.getSelectedValue();
            if (obj instanceof Tweet) {
                Tweet t = (Tweet)list.getSelectedValue();
                t.read();
                String view = NTRClient.getInstance().getMainFrame().getCurrentView();
                if (view != null && t != null) {
                    this.selectedTweet.put(view, t);
                }
            } else if (obj instanceof DirectMessage) {
                this.selectedDirectMessage = (DirectMessage)list.getSelectedValue();
                this.selectedDirectMessage.read();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.shortcutManager.isPostTweet(e)) {
            this.postTweet();
        } else if (this.shortcutManager.isSelectReplyTo(e)) {
            this.replayToSelectedTweet();
        } else if (this.shortcutManager.isRetweet(e)) {
            this.rewteetSelectedTweet();
        } else if (this.shortcutManager.isQuoteTweet(e)) {
            this.quoteTweetToSelectedTweet();
        } else if (this.shortcutManager.isSendDirectMessage(e)) {
            this.sendDirectMessegeToSelectedUser();
        } else if (this.shortcutManager.isFavorite(e)) {
            this.manageFavoriteFlag();
        } else if (this.shortcutManager.isDeleteMyTweet(e)) {
            this.deleteSelectedTweet();
        } else if (this.shortcutManager.isShortenURLInTweet(e)) {
            this.shortenURLinTweet();
        } else if (this.shortcutManager.isExpandURLInTweet(e)) {
            this.expandURLinTweet();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateNumberOfCurrentTweet();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() instanceof JList) {
            if (e.getKeyCode() == 38) {
                JList list = (JList)e.getSource();
                int selectedIndex = list.getSelectedIndex();
                list.setSelectedIndex(selectedIndex - 1);
                if (list.getSelectedValue() instanceof Tweet) {
                    Tweet t = (Tweet)list.getSelectedValue();
                    String view = NTRClient.getInstance().getMainFrame().getCurrentView();
                    this.selectedTweet.put(view, t);
                }
            } else if (e.getKeyCode() == 40 && e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                int selectedIndex = list.getSelectedIndex();
                list.setSelectedIndex(selectedIndex + 1);
                if (list.getSelectedValue() instanceof Tweet) {
                    Tweet t = (Tweet)list.getSelectedValue();
                    String view = NTRClient.getInstance().getMainFrame().getCurrentView();
                    this.selectedTweet.put(view, t);
                }
            }
        }
    }

    private void updateNumberOfCurrentTweet() {
        String[] components;
        String post = this.tweetArea.getText();
        String footer = this.footerArea.getText();
        if (!footer.isEmpty()) {
            post = String.valueOf(post) + " " + footer;
        }
        if (post.matches("[D][ ]\\w+[ ].*") && (components = post.split(" ")).length >= 3 && components[0].equals("D")) {
            String text = components[2];
            int i = 3;
            while (i < components.length) {
                text = String.valueOf(text) + " " + components[i];
                ++i;
            }
            post = text;
        }
        if (post.length() == 0) {
            this.replyTarget = null;
        }
        int rest = 140 - post.length();
        this.postButton.setText("<html><div align=\"center\">Post<br>" + rest + "</div></html>");
        if (rest < 0) {
            this.enableToPost = false;
            this.postButton.setForeground(Color.red);
        } else {
            this.enableToPost = true;
            this.postButton.setForeground(Color.black);
        }
        this.postButton.setEnabled(this.enableToPost);
    }

    public void postTweet() {
        if (!this.enableToPost) {
            JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), "Your tweet is over 140 characters.", "Too long tweet!!", 0);
            return;
        }
        String post = this.tweetArea.getText();
        String footer = this.footerArea.getText();
        if (!footer.isEmpty()) {
            post = String.valueOf(post) + " " + footer;
        }
        if (post.matches("[D][ ]\\w+[ ].*")) {
            String[] components = post.split(" ");
            if (components.length >= 3) {
                String screenName = components[1];
                String text = components[2];
                int i = 3;
                while (i < components.length) {
                    text = String.valueOf(text) + " " + components[i];
                    ++i;
                }
                System.out.println("Send direct message: " + text + " to " + screenName);
                int status = NTRClient.getInstance().sendDirectMessage(text, screenName);
                if (200 == status) {
                    this.clearTextAndTarget();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            } else {
                System.out.println("Invalid direct message");
                this.clearTextAndTarget();
            }
        } else if (this.replyTarget != null) {
            if (post.contains("@" + this.replyTarget.getUser().getScreenName())) {
                System.out.println("Post: " + post + " to " + this.replyTarget);
                int status = NTRClient.getInstance().postTweet(post, this.replyTarget);
                if (200 == status) {
                    this.clearTextAndTarget();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            } else {
                System.out.println("Post: " + post);
                int status = NTRClient.getInstance().postTweet(post);
                if (200 == status) {
                    this.clearTextAndTarget();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        } else {
            System.out.println("Post: " + post);
            int status = NTRClient.getInstance().postTweet(post);
            if (200 == status) {
                this.clearTextAndTarget();
            } else {
                JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
            }
        }
    }

    private void clearTextAndTarget() {
        this.tweetArea.setText("");
        this.replyTarget = null;
        NTRClient.getInstance().updateRateLimit();
        this.updateNumberOfCurrentTweet();
    }

    public void deleteSelectedTweet() {
        if (NTRClient.getInstance().getMainFrame().isShowDirectMessage()) {
            if (this.selectedDirectMessage != null) {
                System.out.println("Delete: " + this.selectedDirectMessage);
                int status = NTRClient.getInstance().destroyDirectMessage(this.selectedDirectMessage);
                if (200 != status) {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        } else {
            String view = NTRClient.getInstance().getMainFrame().getCurrentView();
            if (this.selectedTweet.containsKey(view)) {
                Tweet t = this.selectedTweet.get(view);
                System.out.println("Delete: " + t);
                int status = NTRClient.getInstance().deleteTweet(t);
                if (200 != status) {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        }
    }

    public void replayToSelectedTweet() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            this.tweetArea.setText("@" + t.getUser().getScreenName() + " ");
            this.tweetArea.setCaretPosition(this.tweetArea.getText().length());
            this.replyTarget = t;
            this.tweetArea.requestFocus();
        }
    }

    public void rewteetSelectedTweet() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            int status = NTRClient.getInstance().retweet(t);
            if (200 == status) {
                this.clearTextAndTarget();
            } else {
                JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
            }
            System.out.println("ReTweet: " + t);
        }
    }

    public void quoteTweetToSelectedTweet() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            this.tweetArea.setText(" QT @" + t.getUser().getScreenName() + ": " + t.getText());
            this.tweetArea.setCaretPosition(0);
            this.replyTarget = t;
            this.tweetArea.requestFocus();
            System.out.println("Quote Tweet: " + this.selectedTweet);
        }
    }

    public void sendDirectMessegeToSelectedUser() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            this.tweetArea.setText("D " + t.getUser().getScreenName() + " ");
            this.tweetArea.setCaretPosition(this.tweetArea.getText().length() - 1);
            this.replyTarget = t;
            System.out.println("Direct message to: " + t.getUser().getScreenName());
        }
    }

    public void manageFavoriteFlag() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            if (t.isFavorited()) {
                System.out.println("Un-favorited: " + t.getId());
                int status = NTRClient.getInstance().destroyFavorite(t);
                if (status == 200) {
                    t.setFavorited(false);
                    NTRClient.getInstance().getMainFrame().updateFavoriteView(NTRClient.getInstance().getTwitterController().getFavorite());
                    NTRClient.getInstance().getMainFrame().repaint();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            } else {
                System.out.println("Favorited: " + t.getId());
                int status = NTRClient.getInstance().createFavorite(t);
                if (status == 200) {
                    t.setFavorited(true);
                    NTRClient.getInstance().getMainFrame().repaint();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        }
    }

    public void shortenURLinTweet() {
        String text = this.tweetArea.getText();
        Pattern pattern = Pattern.compile("http://[[a-zA-Z0-9\\p{Punct}]*/{1}]*");
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> urls = new ArrayList<String>();
        while (matcher.find()) {
            urls.add(matcher.group());
        }
        this.urlShorter.shortenURLs(urls);
        for (String u : urls) {
            String s = this.urlShorter.getShortenURL(u);
            text = text.replace(u, s);
        }
        this.tweetArea.setText(text);
        this.tweetArea.setCaretPosition(text.length());
        this.tweetArea.requestFocus();
    }

    public void expandURLinTweet() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            ArrayList urls = (ArrayList)t.getTweetedURLs();
            this.urlShorter.expandShortenURLs(urls);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String s : urls) {
                String u = this.urlShorter.getExpandURL(s);
                if (u.isEmpty()) continue;
                map.put(s, u);
            }
            t.replaceShortenURLs(map);
            NTRClient.getInstance().getMainFrame().updateTimelineView(NTRClient.getInstance().getTwitterController().getTimeline());
        }
    }

    public void showReplyChain() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            System.out.println("Show reply chain from: " + t);
            ReplyChainFrame rcFrame = new ReplyChainFrame(t);
            rcFrame.pack();
            rcFrame.setVisible(true);
            NTRClient.getInstance().updateRateLimit();
        }
    }

    public TwitterUserInfo getSelectedUserInformation() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            return t.getUser();
        }
        return null;
    }

    public Tweet getSelectedTweet() {
        String view = NTRClient.getInstance().getMainFrame().getCurrentView();
        if (this.selectedTweet.containsKey(view)) {
            Tweet t = this.selectedTweet.get(view);
            return t;
        }
        return null;
    }
}

