/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import twitclient.NTRClient;
import twitclient.TwitterList;
import twitclient.TwitterUserInfo;
import twitclient.gui.ClientMenuHandler;

public class ListManagerWindow
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -4648898746711582287L;
    private JTextField name;
    private JTextArea description;
    private JCheckBox modeCheck;
    private JList memberList;
    private JList nonMemberList;
    private JList listOfLists;
    private JComboBox listComboBox;
    private ArrayList<TwitterUserInfo> allUsers = new ArrayList();

    public ListManagerWindow(String mode) {
        super(mode);
        if (mode.equals(ClientMenuHandler.ListMenuItems[0])) {
            this.memberList = new JList();
            this.nonMemberList = new JList();
            DefaultListModel<TwitterUserInfo> model = new DefaultListModel<TwitterUserInfo>();
            for (TwitterUserInfo user : NTRClient.getInstance().getTwitterController().getUsersInTimeline()) {
                model.addElement(user);
            }
            this.nonMemberList.setModel(model);
            this.nonMemberList.setSelectionMode(2);
            model = new DefaultListModel();
            this.memberList.setModel(model);
            this.memberList.setSelectionMode(2);
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 0));
            JPanel nonMember = new JPanel(new BorderLayout());
            JScrollPane nonMemberScroll = new JScrollPane(this.nonMemberList);
            JButton refreshButton = new JButton("Refresh");
            refreshButton.setActionCommand("Refresh");
            refreshButton.addActionListener(this);
            nonMember.add((Component)nonMemberScroll, "Center");
            nonMember.add((Component)refreshButton, "Last");
            nonMember.setPreferredSize(new Dimension(80, 200));
            nonMember.setMinimumSize(new Dimension(80, 200));
            mainPanel.add(nonMember);
            JPanel addRemove = new JPanel();
            addRemove.setLayout(new BoxLayout(addRemove, 1));
            JButton add = new JButton(">>");
            add.setActionCommand("Add user");
            add.addActionListener(this);
            JButton rem = new JButton("<<");
            rem.setActionCommand("Remove user");
            rem.addActionListener(this);
            addRemove.add(add);
            addRemove.add(rem);
            mainPanel.add(addRemove);
            JPanel member = new JPanel(new BorderLayout());
            JScrollPane memberScroll = new JScrollPane(this.memberList);
            JButton addXButton = new JButton("Add User");
            addXButton.setActionCommand("Add X");
            addXButton.addActionListener(this);
            member.add((Component)memberScroll, "Center");
            member.add((Component)addXButton, "Last");
            member.setPreferredSize(new Dimension(80, 200));
            member.setMinimumSize(new Dimension(80, 200));
            mainPanel.add(member);
            JPanel header = new JPanel(new BorderLayout());
            this.name = new JTextField();
            this.name.setBorder(BorderFactory.createTitledBorder("List name"));
            int index = 0;
            for (String filterName : NTRClient.getInstance().getTwitterController().getOwnedListNames()) {
                String term;
                if (!filterName.startsWith("my-tl") || !(term = filterName.replace("my-tl", "")).matches("[0-9]+")) continue;
                int ci = Integer.parseInt(term) + 1;
                index = Math.max(ci, index);
            }
            this.name.setText("my-tl" + index);
            header.add((Component)this.name, "First");
            this.modeCheck = new JCheckBox("Private List");
            header.add((Component)this.modeCheck, "Last");
            JPanel footer = new JPanel(new BorderLayout());
            this.description = new JTextArea(4, 50);
            this.description.setBorder(BorderFactory.createTitledBorder("Description"));
            JButton addButton = new JButton("Add");
            addButton.setActionCommand(mode);
            addButton.addActionListener(this);
            footer.add((Component)this.description, "Center");
            footer.add((Component)addButton, "Last");
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)header, "First");
            panel.add((Component)mainPanel, "Center");
            panel.add((Component)footer, "Last");
            this.add(panel);
        } else if (mode.equals(ClientMenuHandler.ListMenuItems[1])) {
            JPanel panel = new JPanel(new BorderLayout());
            this.listOfLists = new JList();
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (TwitterList list : NTRClient.getInstance().getTwitterController().getOwnedLists()) {
                model.addElement(list.getSlug());
            }
            this.listOfLists.setModel(model);
            this.listOfLists.setSelectionMode(2);
            JScrollPane scrollPane = new JScrollPane(this.listOfLists);
            this.listOfLists.setPreferredSize(new Dimension(200, 100));
            JButton removeButton = new JButton("Remove");
            removeButton.setActionCommand(mode);
            removeButton.addActionListener(this);
            panel.add((Component)scrollPane, "Center");
            panel.add((Component)removeButton, "Last");
            this.add(panel);
        } else if (mode.equals(ClientMenuHandler.ListMenuItems[2])) {
            this.listComboBox = new JComboBox();
            TwitterList firstList = null;
            for (TwitterList list : NTRClient.getInstance().getTwitterController().getOwnedLists()) {
                this.listComboBox.addItem(list);
                if (firstList != null) continue;
                firstList = list;
            }
            this.listComboBox.addItemListener(this);
            this.memberList = new JList();
            this.nonMemberList = new JList();
            DefaultListModel model = new DefaultListModel();
            this.nonMemberList.setModel(model);
            this.nonMemberList.setSelectionMode(2);
            model = new DefaultListModel();
            this.memberList.setModel(model);
            this.memberList.setSelectionMode(2);
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 0));
            JPanel nonMember = new JPanel(new BorderLayout());
            JScrollPane nonMemberScroll = new JScrollPane(this.nonMemberList);
            JButton refreshButton = new JButton("Refresh");
            refreshButton.setActionCommand("Refresh");
            refreshButton.addActionListener(this);
            nonMember.add((Component)nonMemberScroll, "Center");
            nonMember.add((Component)refreshButton, "Last");
            nonMember.setPreferredSize(new Dimension(80, 200));
            nonMember.setMinimumSize(new Dimension(80, 200));
            mainPanel.add(nonMember);
            JPanel addRemove = new JPanel();
            addRemove.setLayout(new BoxLayout(addRemove, 1));
            JButton add = new JButton(">>");
            add.setActionCommand("Add user");
            add.addActionListener(this);
            JButton rem = new JButton("<<");
            rem.setActionCommand("Remove user");
            rem.addActionListener(this);
            addRemove.add(add);
            addRemove.add(rem);
            mainPanel.add(addRemove);
            JPanel member = new JPanel(new BorderLayout());
            JScrollPane memberScroll = new JScrollPane(this.memberList);
            JButton addXButton = new JButton("Add User");
            addXButton.setActionCommand("Add X");
            addXButton.addActionListener(this);
            member.add((Component)memberScroll, "Center");
            member.add((Component)addXButton, "Last");
            member.setPreferredSize(new Dimension(80, 200));
            member.setMinimumSize(new Dimension(80, 200));
            mainPanel.add(member);
            JPanel header = new JPanel(new BorderLayout());
            this.name = new JTextField();
            this.name.setBorder(BorderFactory.createTitledBorder("List name"));
            this.name.setText("");
            this.name.setEditable(false);
            header.add((Component)this.name, "First");
            this.modeCheck = new JCheckBox("Private List");
            header.add((Component)this.modeCheck, "Last");
            JPanel footer = new JPanel(new BorderLayout());
            this.description = new JTextArea(4, 50);
            this.description.setBorder(BorderFactory.createTitledBorder("Description"));
            JButton updateButton = new JButton("Update");
            updateButton.setActionCommand(mode);
            updateButton.addActionListener(this);
            footer.add((Component)this.description, "Center");
            footer.add((Component)updateButton, "Last");
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)header, "First");
            topPanel.add((Component)mainPanel, "Center");
            topPanel.add((Component)footer, "Last");
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.listComboBox, "First");
            panel.add((Component)topPanel, "Center");
            this.add(panel);
            this.changePanel(firstList.getSlug(), firstList);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String str;
        String command = e.getActionCommand();
        if (command.equals(ClientMenuHandler.ListMenuItems[0])) {
            this.setCursor(new Cursor(3));
            String slug = this.name.getText();
            boolean isPrivate = this.modeCheck.isSelected();
            String descr = this.description.getText();
            NTRClient.getInstance().createList(slug, isPrivate, descr);
            DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
            int i = 0;
            while (i < memberModel.getSize()) {
                Object obj2 = memberModel.get(i);
                if (obj2 instanceof TwitterUserInfo) {
                    TwitterUserInfo user = (TwitterUserInfo)obj2;
                    NTRClient.getInstance().addMemberToList(slug, user.getId());
                } else if (obj2 instanceof String) {
                    NTRClient.getInstance().addMemberToList(slug, obj2.toString());
                }
                ++i;
            }
            NTRClient.getInstance().updateOwnedList(slug);
            this.setCursor(new Cursor(0));
            this.dispose();
        } else if (command.equals(ClientMenuHandler.ListMenuItems[1])) {
            Object[] objs = this.listOfLists.getSelectedValues();
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof String) {
                    String name = (String)objs[i];
                    NTRClient.getInstance().removeList(name);
                }
                ++i;
            }
            this.dispose();
        } else if (command.equals(ClientMenuHandler.ListMenuItems[2])) {
            Object obj = this.listComboBox.getSelectedItem();
            if (obj instanceof TwitterList) {
                boolean found;
                this.setCursor(new Cursor(3));
                TwitterList list = (TwitterList)obj;
                String slug = this.name.getText();
                boolean isPrivate = this.modeCheck.isSelected();
                String descr = this.description.getText();
                if (!(list.getSlug().equals(slug) && list.getDescription().equals(descr) && list.getMode().equals("private") && isPrivate)) {
                    int obj2 = NTRClient.getInstance().updateList(list.getSlug(), slug, isPrivate, descr);
                }
                DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
                ArrayList<TwitterUserInfo> currentMembers = list.getMembers();
                int i = 0;
                while (i < memberModel.getSize()) {
                    Object ob = memberModel.get(i);
                    if (ob instanceof TwitterUserInfo) {
                        found = false;
                        TwitterUserInfo user = (TwitterUserInfo)ob;
                        for (TwitterUserInfo twitterUserInfo : currentMembers) {
                            if (twitterUserInfo.getId() != user.getId()) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            NTRClient.getInstance().addMemberToList(slug, user.getId());
                        }
                    } else if (ob instanceof String) {
                        found = false;
                        for (TwitterUserInfo u3 : currentMembers) {
                            if (!u3.getScreenName().equals(ob)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            NTRClient.getInstance().addMemberToList(slug, ob.toString());
                        }
                    }
                    ++i;
                }
                for (TwitterUserInfo user : currentMembers) {
                    found = false;
                    int i2 = 0;
                    while (i2 < memberModel.getSize()) {
                        if (memberModel.get(i2) instanceof TwitterUserInfo) {
                            TwitterUserInfo twitterUserInfo = (TwitterUserInfo)memberModel.get(i2);
                            if (twitterUserInfo.getId() == user.getId()) {
                                found = true;
                                break;
                            }
                        } else if (memberModel.get(i2) instanceof String && memberModel.get(i2).toString().equals(user.getScreenName())) {
                            found = true;
                            break;
                        }
                        ++i2;
                    }
                    if (found) continue;
                    NTRClient.getInstance().removeMemberToList(slug, user.getId());
                }
                for (TwitterList l : NTRClient.getInstance().getTwitterController().getOwnedLists()) {
                    if (!l.getSlug().equals(slug)) continue;
                    l.clearMembers();
                    break;
                }
                this.setCursor(new Cursor(0));
            }
            this.dispose();
        } else if (command.equals("Refresh")) {
            if (this.allUsers.isEmpty()) {
                this.setCursor(new Cursor(3));
                DefaultListModel<TwitterUserInfo> model = new DefaultListModel<TwitterUserInfo>();
                DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
                ArrayList<Long> memberIDs = new ArrayList<Long>();
                int i = 0;
                while (i < memberModel.getSize()) {
                    if (memberModel.get(i) instanceof TwitterUserInfo) {
                        memberIDs.add(((TwitterUserInfo)memberModel.get(i)).getId());
                    }
                    ++i;
                }
                for (TwitterUserInfo user : NTRClient.getInstance().getTwitterController().getAllKnownUsers()) {
                    this.allUsers.add(user);
                    if (memberIDs.contains(user.getId())) continue;
                    model.addElement(user);
                }
                this.nonMemberList.setModel(model);
                this.setCursor(new Cursor(0));
            } else {
                DefaultListModel<TwitterUserInfo> model = new DefaultListModel<TwitterUserInfo>();
                DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
                ArrayList<Long> memberIDs = new ArrayList<Long>();
                int i = 0;
                while (i < memberModel.getSize()) {
                    if (memberModel.get(i) instanceof TwitterUserInfo) {
                        memberIDs.add(((TwitterUserInfo)memberModel.get(i)).getId());
                    }
                    ++i;
                }
                for (TwitterUserInfo user : this.allUsers) {
                    if (memberIDs.contains(user.getId())) continue;
                    model.addElement(user);
                }
                this.nonMemberList.setModel(model);
            }
            this.repaint();
        } else if (command.equals("Add user")) {
            Object[] objs = this.nonMemberList.getSelectedValues();
            DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
            DefaultListModel nonMemberModel = (DefaultListModel)this.nonMemberList.getModel();
            int i = 0;
            while (i < objs.length) {
                nonMemberModel.removeElement(objs[i]);
                memberModel.addElement(objs[i]);
                ++i;
            }
            this.repaint();
        } else if (command.equals("Remove user")) {
            Object[] objs = this.memberList.getSelectedValues();
            DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
            DefaultListModel nonMemberModel = (DefaultListModel)this.nonMemberList.getModel();
            int i = 0;
            while (i < objs.length) {
                memberModel.removeElement(objs[i]);
                nonMemberModel.addElement(objs[i]);
                ++i;
            }
            this.repaint();
        } else if (command.equals("Add X") && !(str = JOptionPane.showInputDialog(this, (Object)"Input user name to add this list.")).isEmpty()) {
            DefaultListModel memberModel = (DefaultListModel)this.memberList.getModel();
            DefaultListModel nonMemberModel = (DefaultListModel)this.nonMemberList.getModel();
            memberModel.addElement(str);
            int i = 0;
            while (i < nonMemberModel.getSize()) {
                Object obj = nonMemberModel.get(i);
                if (obj instanceof TwitterUserInfo) {
                    TwitterUserInfo user = (TwitterUserInfo)obj;
                    if (user.getScreenName().equals(str)) {
                        nonMemberModel.remove(i);
                        break;
                    }
                } else {
                    boolean cfr_ignored_0 = obj instanceof String;
                }
                ++i;
            }
            this.repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getItem();
        if (obj instanceof String) {
            String name = (String)obj;
            TwitterList list = null;
            for (TwitterList l : NTRClient.getInstance().getTwitterController().getOwnedLists()) {
                if (!l.getSlug().equals(name)) continue;
                list = l;
                break;
            }
            if (list == null) {
                return;
            }
            this.changePanel(name, list);
        }
    }

    private void changePanel(String name, TwitterList list) {
        this.setCursor(new Cursor(3));
        DefaultListModel<TwitterUserInfo> model = new DefaultListModel<TwitterUserInfo>();
        ArrayList<Long> memberIDs = new ArrayList<Long>();
        for (TwitterUserInfo user : this.allUsers) {
            if (memberIDs.contains(user.getId())) continue;
            model.addElement(user);
        }
        for (TwitterUserInfo user : NTRClient.getInstance().getTwitterController().getMembersInOwnedList(name)) {
            model.addElement(user);
            memberIDs.add(user.getId());
        }
        this.memberList.setModel(model);
        model = new DefaultListModel();
        if (this.allUsers.isEmpty()) {
            for (TwitterUserInfo user : NTRClient.getInstance().getTwitterController().getUsersInTimeline()) {
                if (memberIDs.contains(user.getId())) continue;
                model.addElement(user);
            }
        } else {
            for (TwitterUserInfo user : this.allUsers) {
                if (memberIDs.contains(user.getId())) continue;
                model.addElement(user);
            }
        }
        this.nonMemberList.setModel(model);
        if (list.getMode().equals("private")) {
            this.modeCheck.setSelected(true);
        }
        this.name.setText(list.getSlug());
        this.description.setText(list.getDescription());
        this.setCursor(new Cursor(0));
    }
}

