/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import twitclient.DirectMessage;
import twitclient.NTRClient;
import twitclient.gui.ClientComponentConfiguration;

public class DirectMessageViewPanel
extends JPanel {
    private static final long serialVersionUID = 3818759124693878900L;
    JTextArea tweetArea;

    public DirectMessageViewPanel(DirectMessage dm, boolean isSelected) {
        TitledBorder border;
        this.setLayout(new BorderLayout());
        int col = dm.getText().length() / 20;
        this.tweetArea = new JTextArea(col + 2, 20);
        this.tweetArea.setLineWrap(true);
        this.tweetArea.setWrapStyleWord(true);
        this.tweetArea.setEditable(false);
        ClientComponentConfiguration conf = ClientComponentConfiguration.getInstance();
        String tweetTitle = dm.getTweetTitle();
        tweetTitle = NTRClient.getInstance().getTwitterController().isFollowingEachOther(dm.getSender().getId()) ? "+ " + tweetTitle : "! " + tweetTitle;
        if (isSelected) {
            this.tweetArea.setFont(conf.getSelectedTweetFont());
            this.tweetArea.setBackground(conf.getSelectedTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getSelectedTweetForegroundColor());
            border = BorderFactory.createTitledBorder(conf.getUnselectedTweetBorder(), tweetTitle, 0, 0, conf.getSelectedTweetFont(), conf.getSelectedTweetBorderColor());
            this.tweetArea.setBorder(border);
        } else if (!dm.isRead()) {
            this.tweetArea.setFont(conf.getUnreadTweetFont());
            this.tweetArea.setBackground(conf.getUnreadTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getUnreadTweetForegroundColor());
            border = BorderFactory.createTitledBorder(conf.getUnreadTweetBorder(), tweetTitle, 0, 0, conf.getUnreadTweetFont(), conf.getUnreadTweetBorderColor());
            this.tweetArea.setBorder(border);
        } else {
            this.tweetArea.setFont(conf.getUnselectedTweetFont());
            this.tweetArea.setBackground(conf.getUnselectedTweetBackgroundColor());
            this.tweetArea.setForeground(conf.getUnselectedTweetForegroundColor());
            border = BorderFactory.createTitledBorder(conf.getUnselectedTweetBorder(), tweetTitle, 0, 0, conf.getUnselectedTweetFont(), conf.getUnselectedTweetBorderColor());
            this.tweetArea.setBorder(border);
        }
        this.tweetArea.append(dm.getTweetText());
        this.setToolTipText(dm.getTweetInfo());
        JLabel iconLabel = new JLabel(dm.getIcon());
        this.add((Component)iconLabel, "West");
        this.add((Component)this.tweetArea, "Center");
    }
}

