/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JOptionPane;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.TwitterUserInfo;
import twitclient.gui.PostManager;

public class ClientToolBarHandler
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        System.out.println(cmd);
        if (cmd.equals("update")) {
            String currentView = NTRClient.getInstance().getMainFrame().getCurrentView();
            if (currentView.equals("Timeline")) {
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
                NTRClient.getInstance().updateHomeTimeline();
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
            } else if (currentView.equals("Mentions")) {
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
                NTRClient.getInstance().updateMentions();
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
            } else if (currentView.equals("Direct Message")) {
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
                NTRClient.getInstance().updateDirectMessageInBox();
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
            } else if (currentView.equals("Favorites")) {
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
                NTRClient.getInstance().updateFavorite();
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
            } else if (currentView.equals("Filters")) {
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
                NTRClient.getInstance().updateHomeTimeline();
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
            } else if (currentView.equals("Lists")) {
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
                NTRClient.getInstance().updateOwnedList();
                NTRClient.getInstance().updateSubscribedList();
                NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
            }
        } else if (cmd.equals("update timeline")) {
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
            NTRClient.getInstance().updateHomeTimeline();
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
        } else if (cmd.equals("update mentions")) {
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
            NTRClient.getInstance().updateMentions();
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
        } else if (cmd.equals("update direct message")) {
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
            NTRClient.getInstance().updateDirectMessageInBox();
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
        } else if (cmd.equals("update favorite")) {
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(3));
            NTRClient.getInstance().updateFavorite();
            NTRClient.getInstance().getMainFrame().setCursor(new Cursor(0));
        } else if (cmd.equals("reply to")) {
            PostManager.getInstance().replayToSelectedTweet();
        } else if (cmd.equals("send direct message")) {
            PostManager.getInstance().sendDirectMessegeToSelectedUser();
        } else if (cmd.equals("show reply chain")) {
            PostManager.getInstance().showReplyChain();
        } else if (cmd.equals("go twitter home")) {
            String screenName = PostManager.getInstance().getSelectedUserInformation().getScreenName();
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI("http://www.twitter.com/" + screenName));
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            catch (URISyntaxException exception) {
                exception.printStackTrace();
            }
        } else if (cmd.equals("go user web")) {
            URL url = PostManager.getInstance().getSelectedUserInformation().getUrl();
            if (url == null) {
                TwitterUserInfo info = PostManager.getInstance().getSelectedUserInformation();
                JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(info.getScreenName()) + " does not have web page.", "User's web not found", 0);
            } else {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(url.toURI());
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (URISyntaxException exception) {
                    exception.printStackTrace();
                }
            }
        } else if (cmd.equals("open tweet url")) {
            Tweet tweet = PostManager.getInstance().getSelectedTweet();
            Desktop desktop = Desktop.getDesktop();
            try {
                for (String url : tweet.getTweetedURLs()) {
                    desktop.browse(new URI(url));
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            catch (URISyntaxException exception) {
                exception.printStackTrace();
            }
        }
    }
}

