/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.TwitterUserInfo;
import twitclient.gui.FilterManagerWindow;
import twitclient.gui.ListManagerWindow;
import twitclient.gui.PostManager;

public class ClientMenuHandler
implements ActionListener {
    public static String FileMenu = "File";
    public static String[] FileMenuItems = new String[]{"Exit"};
    public static String UpdateMenu = "Update";
    public static String[] UpdateMenuItems = new String[]{"Timeline", "Mentions", "Direct Message", "Favorite", "Friendship", "My List", "Subscribed List"};
    public static String TweetMenu = "Tweet";
    public static String[] TweetMenuItems = new String[]{"Post", "Reply", "Retweet", "Quote Tweet", "Send direct message", "----", "Favorite", "----", "Delete", "----", "Show reply chain", "----", "Expand URL", "Shorten URL"};
    public static String TweetPopupMenu = "TweetPopup";
    public static String[] TweetPopupMenuItems = new String[]{"Reply", "Retweet", "Quote Tweet", "Send direct message", "----", "Favorite", "----", "Delete", "----", "Show reply chain", "----", "Open selected user's web", "Open selected user's twitter home", "Open selected user's twilog", "Open tweet in browser", "Open tweeted URL", "Expand URL"};
    public static String FilterMenu = "Filter";
    public static String[] FilterMenuItems = new String[]{"Add filter", "Remove filter", "Edit filter"};
    public static String ListMenu = "List";
    public static String[] ListMenuItems = new String[]{"Add list", "Remove list", "Edit list"};
    public static String WindowMenu = "Window";
    public static String[] WindowMenuItems = new String[]{"Timeline", "Mentions", "Direct Message", "Favorite", "Filters", "Lists"};

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String[] components = source.getName().split(" ");
        int size = components.length;
        String from = components[size - 1];
        String command = components[0];
        int i = 1;
        while (i < size - 1) {
            command = String.valueOf(command) + " " + components[i];
            ++i;
        }
        System.out.println(String.valueOf(from) + "-" + command);
        if (from.equals(FileMenu)) {
            if (command.equals(FileMenuItems[0])) {
                WindowEvent windowEvent = new WindowEvent(NTRClient.getInstance().getMainFrame(), 201);
                NTRClient.getInstance().getMainFrame().windowClosing(windowEvent);
            }
        } else if (from.equals(UpdateMenu)) {
            if (command.equals(UpdateMenuItems[0])) {
                NTRClient.getInstance().updateHomeTimeline();
            } else if (command.equals(UpdateMenuItems[1])) {
                NTRClient.getInstance().updateMentions();
            } else if (command.equals(UpdateMenuItems[2])) {
                NTRClient.getInstance().updateDirectMessageInBox();
            } else if (command.equals(UpdateMenuItems[3])) {
                NTRClient.getInstance().updateFavorite();
            } else if (command.equals(UpdateMenuItems[4])) {
                NTRClient.getInstance().updateFriendship();
            } else if (command.equals(UpdateMenuItems[5])) {
                NTRClient.getInstance().updateOwnedList();
            } else if (command.equals(UpdateMenuItems[6])) {
                NTRClient.getInstance().updateSubscribedList();
            }
        } else if (from.equals(TweetMenu)) {
            PostManager postManager = PostManager.getInstance();
            if (command.equals(TweetMenuItems[0])) {
                postManager.postTweet();
            } else if (command.equals(TweetMenuItems[1])) {
                postManager.replayToSelectedTweet();
            } else if (command.equals(TweetMenuItems[2])) {
                postManager.rewteetSelectedTweet();
            } else if (command.equals(TweetMenuItems[3])) {
                postManager.quoteTweetToSelectedTweet();
            } else if (command.equals(TweetMenuItems[4])) {
                postManager.sendDirectMessegeToSelectedUser();
            } else if (command.equals(TweetMenuItems[6])) {
                postManager.manageFavoriteFlag();
            } else if (command.equals(TweetMenuItems[8])) {
                postManager.deleteSelectedTweet();
            } else if (command.equals(TweetMenuItems[10])) {
                postManager.showReplyChain();
            } else if (command.equals(TweetMenuItems[12])) {
                postManager.expandURLinTweet();
            } else if (command.equals(TweetMenuItems[13])) {
                postManager.shortenURLinTweet();
            }
        } else if (from.equals(TweetPopupMenu)) {
            PostManager postManager = PostManager.getInstance();
            if (command.equals(TweetPopupMenuItems[0])) {
                postManager.replayToSelectedTweet();
            } else if (command.equals(TweetPopupMenuItems[1])) {
                postManager.rewteetSelectedTweet();
            } else if (command.equals(TweetPopupMenuItems[2])) {
                postManager.quoteTweetToSelectedTweet();
            } else if (command.equals(TweetPopupMenuItems[3])) {
                postManager.sendDirectMessegeToSelectedUser();
            } else if (command.equals(TweetPopupMenuItems[5])) {
                postManager.manageFavoriteFlag();
            } else if (command.equals(TweetPopupMenuItems[7])) {
                postManager.deleteSelectedTweet();
            } else if (command.equals(TweetPopupMenuItems[9])) {
                postManager.showReplyChain();
            } else if (command.equals(TweetPopupMenuItems[11])) {
                URL url = postManager.getSelectedUserInformation().getUrl();
                if (url == null) {
                    TwitterUserInfo info = postManager.getSelectedUserInformation();
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(info.getScreenName()) + " does not have web page.", "User's web not found", 0);
                } else {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(url.toURI());
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                    catch (URISyntaxException exception) {
                        exception.printStackTrace();
                    }
                }
            } else if (command.equals(TweetPopupMenuItems[12])) {
                String screenName = postManager.getSelectedUserInformation().getScreenName();
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.twitter.com/" + screenName));
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (URISyntaxException exception) {
                    exception.printStackTrace();
                }
            } else if (command.equals(TweetPopupMenuItems[13])) {
                String screenName = postManager.getSelectedUserInformation().getScreenName();
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://twilog.org/" + screenName));
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (URISyntaxException exception) {
                    exception.printStackTrace();
                }
            } else if (command.equals(TweetPopupMenuItems[14])) {
                long id = postManager.getSelectedTweet().getId();
                String screenName = postManager.getSelectedUserInformation().getScreenName();
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.twitter.com/" + screenName + "/statuses/" + id));
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (URISyntaxException exception) {
                    exception.printStackTrace();
                }
            } else if (command.equals(TweetPopupMenuItems[15])) {
                Tweet tweet = postManager.getSelectedTweet();
                Desktop desktop = Desktop.getDesktop();
                try {
                    for (String url : tweet.getTweetedURLs()) {
                        desktop.browse(new URI(url));
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (URISyntaxException exception) {
                    exception.printStackTrace();
                }
            } else if (command.equals(TweetPopupMenuItems[16])) {
                postManager.expandURLinTweet();
            }
        } else if (from.equals(FilterMenu)) {
            if (command.equals(FilterMenuItems[0])) {
                FilterManagerWindow filterManage = new FilterManagerWindow(command);
                filterManage.pack();
                filterManage.setVisible(true);
            } else if (command.equals(FilterMenuItems[1])) {
                FilterManagerWindow filterManage = new FilterManagerWindow(command);
                filterManage.pack();
                filterManage.setVisible(true);
            } else if (command.equals(FilterMenuItems[2])) {
                FilterManagerWindow filterManage = new FilterManagerWindow(command);
                filterManage.pack();
                filterManage.setVisible(true);
            }
        } else if (from.equals(ListMenu)) {
            ArrayList lists;
            if (command.equals(ListMenuItems[0])) {
                ListManagerWindow listManage = new ListManagerWindow(command);
                listManage.pack();
                listManage.setVisible(true);
            } else if (command.equals(ListMenuItems[1])) {
                ArrayList lists2 = (ArrayList)NTRClient.getInstance().getTwitterController().getOwnedLists();
                if (!lists2.isEmpty()) {
                    ListManagerWindow listManage = new ListManagerWindow(command);
                    listManage.pack();
                    listManage.setVisible(true);
                }
            } else if (command.equals(ListMenuItems[2]) && !(lists = (ArrayList)NTRClient.getInstance().getTwitterController().getOwnedLists()).isEmpty()) {
                ListManagerWindow listManage = new ListManagerWindow(command);
                listManage.pack();
                listManage.setVisible(true);
            }
        } else if (from.equals(WindowMenu)) {
            if (command.equals(WindowMenuItems[0])) {
                NTRClient.getInstance().getMainFrame().showTimelineView();
            } else if (command.equals(WindowMenuItems[1])) {
                NTRClient.getInstance().getMainFrame().showMentionsView();
            } else if (command.equals(WindowMenuItems[2])) {
                NTRClient.getInstance().getMainFrame().showDirectMessageView();
            } else if (command.equals(WindowMenuItems[3])) {
                NTRClient.getInstance().getMainFrame().showFavoriteView();
            } else if (command.equals(WindowMenuItems[4])) {
                NTRClient.getInstance().getMainFrame().showFiltersView();
            } else if (command.equals(WindowMenuItems[5])) {
                NTRClient.getInstance().getMainFrame().showListsView();
            }
        }
    }
}

