/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import twitclient.NTRClient;
import twitclient.TwitterList;
import twitclient.gui.TimelineViewPanel;

public class ClientListViewPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -7017446968650945767L;
    private TimelineViewPanel listMainPanel;
    private JComboBox listComboBox;

    public ClientListViewPanel() {
        super(new BorderLayout());
        JPanel comboBoxPane = new JPanel(new GridLayout(1, 1));
        this.listComboBox = new JComboBox();
        this.listComboBox.setEditable(false);
        this.listComboBox.addItemListener(this);
        comboBoxPane.add(this.listComboBox);
        this.listMainPanel = new TimelineViewPanel();
        this.add((Component)comboBoxPane, "First");
        this.add((Component)this.listMainPanel, "Center");
    }

    public void updateListOfLists(ArrayList<String> ownedList, ArrayList<String> subscribedList) {
        this.listComboBox.removeAllItems();
        this.listComboBox.addItem("My Lists");
        for (String str : ownedList) {
            this.listComboBox.addItem(str);
        }
        this.listComboBox.addItem("Subscribed Lists");
        for (String str : subscribedList) {
            this.listComboBox.addItem(str);
        }
    }

    public void update(Iterable<TwitterList> lists) {
        for (TwitterList list : lists) {
            String name = list.getFullName();
            if (!name.equals(this.listMainPanel.getName())) continue;
            this.listMainPanel.update(list.getTweets());
            break;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String listName = (String)e.getItem();
        boolean found = false;
        for (TwitterList list : NTRClient.getInstance().getTwitterController().getAllLists()) {
            if (!list.getFullName().equals(listName)) continue;
            this.listMainPanel.remove();
            this.listMainPanel.setName(listName);
            this.listMainPanel.update(list.getTweets());
            this.listMainPanel.repaint();
            found = true;
            break;
        }
    }
}

