/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import twitclient.Tweet;
import twitclient.gui.TimelineViewPanel;

public class ClientFilterViewPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -2159333045564084701L;
    private JPanel filterMainPanel;
    private JComboBox filterComboBox;

    public ClientFilterViewPanel() {
        super(new BorderLayout());
        JPanel comboBoxPane = new JPanel(new GridLayout(1, 1));
        this.filterComboBox = new JComboBox();
        this.filterComboBox.setEditable(false);
        this.filterComboBox.addItemListener(this);
        comboBoxPane.add(this.filterComboBox);
        this.filterMainPanel = new JPanel(new CardLayout());
        this.add((Component)comboBoxPane, "First");
        this.add((Component)this.filterMainPanel, "Center");
    }

    public void updateFilterList(Iterable<String> filterNames) {
        this.filterComboBox.removeAllItems();
        for (String str : filterNames) {
            this.filterComboBox.addItem(str);
        }
        if (this.filterComboBox.getItemCount() == 0) {
            this.filterComboBox.addItem("No filters");
            this.filterMainPanel.removeAll();
        }
    }

    public void update(Iterable<Tweet> tweets, String filterName) {
        Component[] comps = this.filterMainPanel.getComponents();
        boolean found = false;
        int i = 0;
        while (i < comps.length) {
            if (comps[i].getName().equals(filterName)) {
                ((TimelineViewPanel)comps[i]).update(tweets);
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            TimelineViewPanel panel = new TimelineViewPanel();
            panel.setName(filterName);
            panel.update(tweets);
            this.filterMainPanel.add((Component)panel, filterName);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CardLayout cl = (CardLayout)this.filterMainPanel.getLayout();
        cl.show(this.filterMainPanel, (String)e.getItem());
    }
}

