/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientComponentConfiguration {
    private static ClientComponentConfiguration conf = new ClientComponentConfiguration();
    private String unselectedTweetFontName = "SansSerif";
    private int unselectedTweetFontSize = 12;
    private Color unselectedTweetFontColor = Color.black;
    private int unselectedTweetFontStyle = 0;
    private Color unselectedTweetBorderColor = Color.black;
    private int unselectedTweetBorderSize = 1;
    private Color unselectedTweetBackgroundColor = Color.white;
    private Color unselectedTweetForegroundColor = Color.black;
    private Font unselectedTweetFont = new Font(this.unselectedTweetFontName, this.unselectedTweetFontStyle, this.unselectedTweetFontSize);
    private Border unselectedTweetBorder = BorderFactory.createLineBorder(this.unselectedTweetBorderColor, this.unselectedTweetBorderSize);
    private String selectedTweetFontName = "SansSerif";
    private int selectedTweetFontSize = 12;
    private Color selectedTweetFontColor = Color.black;
    private int selectedTweetFontStyle = 1;
    private Color selectedTweetBorderColor = Color.black;
    private int selectedTweetBorderSize = 2;
    private Color selectedTweetBackgroundColor = Color.white;
    private Color selectedTweetForegroundColor = Color.black;
    private Font selectedTweetFont = new Font(this.selectedTweetFontName, this.selectedTweetFontStyle, this.selectedTweetFontSize);
    private Border selectedTweetBorder = BorderFactory.createLineBorder(this.selectedTweetBorderColor, this.selectedTweetBorderSize);
    private String unreadTweetFontName = "SansSerif";
    private int unreadTweetFontSize = 12;
    private Color unreadTweetFontColor = Color.red;
    private int unreadTweetFontStyle = 0;
    private Color unreadTweetBorderColor = Color.red;
    private int unreadTweetBorderSize = 1;
    private Color unreadTweetBackgroundColor = Color.white;
    private Color unreadTweetForegroundColor = Color.red;
    private Font unreadTweetFont = new Font(this.unreadTweetFontName, this.unreadTweetFontStyle, this.unreadTweetFontSize);
    private Border unreadTweetBorder = BorderFactory.createLineBorder(this.unreadTweetBorderColor, this.unreadTweetBorderSize);
    private String favoriteTweetFontName = "SansSerif";
    private int favoriteTweetFontSize = 12;
    private Color favoriteTweetFontColor = Color.black;
    private int favoriteTweetFontStyle = 0;
    private Color favoriteTweetBorderColor = Color.black;
    private int favoriteTweetBorderSize = 1;
    private Color favoriteTweetBackgroundColor = Color.white;
    private Color favoriteTweetForegroundColor = Color.black;
    private Font favoriteTweetFont = new Font(this.favoriteTweetFontName, this.favoriteTweetFontStyle, this.favoriteTweetFontSize);
    private Border favoriteTweetBorder = BorderFactory.createLineBorder(this.favoriteTweetBorderColor, this.favoriteTweetBorderSize);
    private final String configFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "gui_config.xml";

    private ClientComponentConfiguration() {
        System.out.println("Read GUI configuration from: " + this.configFileName);
        File configFile = new File(this.configFileName);
        if (configFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(configFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    NodeList nodelist;
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("unselected-tweet")) {
                        nodelist = nodes.getChildNodes();
                        this.readUnselectedTweetConfiguration(nodelist);
                    } else if (nodeName.equals("selected-tweet")) {
                        nodelist = nodes.getChildNodes();
                        this.readSelectedTweetConfiguration(nodelist);
                    } else if (nodeName.equals("unread-tweet")) {
                        nodelist = nodes.getChildNodes();
                        this.readUnreadTweetConfiguration(nodelist);
                    } else if (nodeName.equals("favorite-tweet")) {
                        nodelist = nodes.getChildNodes();
                        this.readFavoriteTweetConfiguration(nodelist);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.writeConfigurationFile();
        }
    }

    public void writeConfigurationFile() {
        FileOutputStream out = null;
        try {
            File configFile = new File(this.configFileName);
            File dir = configFile.getParentFile();
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Cannot create client directory");
                System.exit(1);
            }
            out = new FileOutputStream(this.configFileName);
            Document doc = null;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            DOMImplementation impl = bld.getDOMImplementation();
            doc = impl.createDocument("", "config", null);
            doc.setXmlStandalone(true);
            Element root = doc.getDocumentElement();
            root.appendChild(this.writeUnselectedTweetConfiguration(doc));
            root.appendChild(this.writeSelectedTweetConfiguration(doc));
            root.appendChild(this.writeUnreadTweetConfiguration(doc));
            root.appendChild(this.writeFavoriteTweetConfiguration(doc));
            DOMSource dsrc = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult sr = new StreamResult(out);
            transformer.transform(dsrc, sr);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void readUnselectedTweetConfiguration(NodeList nodelist) {
        int i = 0;
        while (i < nodelist.getLength()) {
            long color;
            Node node;
            int j;
            NodeList childNodes;
            Node nodes = nodelist.item(i);
            String nodeName = nodes.getNodeName();
            if (nodeName.equals("font-name")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.unselectedTweetFontName = node.getNodeValue();
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.unselectedTweetFontSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unselectedTweetFontColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-style")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        String style = node.getNodeValue();
                        this.unselectedTweetFontStyle = style.equalsIgnoreCase("plain") ? 0 : (style.equalsIgnoreCase("bold") ? 1 : (style.equalsIgnoreCase("italic") ? 2 : 0));
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unselectedTweetBorderColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.unselectedTweetBorderSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("background-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unselectedTweetBackgroundColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("foreground-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unselectedTweetForegroundColor = new Color((int)color);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.unselectedTweetFont = new Font(this.unselectedTweetFontName, this.unselectedTweetFontStyle, this.unselectedTweetFontSize);
        this.unselectedTweetBorder = BorderFactory.createLineBorder(this.unselectedTweetBorderColor, this.unselectedTweetBorderSize);
    }

    private void readSelectedTweetConfiguration(NodeList nodelist) {
        int i = 0;
        while (i < nodelist.getLength()) {
            long color;
            Node node;
            int j;
            NodeList childNodes;
            Node nodes = nodelist.item(i);
            String nodeName = nodes.getNodeName();
            if (nodeName.equals("font-name")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.selectedTweetFontName = node.getNodeValue();
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.selectedTweetFontSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.selectedTweetFontColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-style")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        String style = node.getNodeValue();
                        this.selectedTweetFontStyle = style.equalsIgnoreCase("plain") ? 0 : (style.equalsIgnoreCase("bold") ? 1 : (style.equalsIgnoreCase("italic") ? 2 : 0));
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.selectedTweetBorderColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.selectedTweetBorderSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("background-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.selectedTweetBackgroundColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("foreground-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.selectedTweetForegroundColor = new Color((int)color);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.selectedTweetFont = new Font(this.selectedTweetFontName, this.selectedTweetFontStyle, this.selectedTweetFontSize);
        this.selectedTweetBorder = BorderFactory.createLineBorder(this.selectedTweetBorderColor, this.selectedTweetBorderSize);
    }

    private void readUnreadTweetConfiguration(NodeList nodelist) {
        int i = 0;
        while (i < nodelist.getLength()) {
            long color;
            Node node;
            int j;
            NodeList childNodes;
            Node nodes = nodelist.item(i);
            String nodeName = nodes.getNodeName();
            if (nodeName.equals("font-name")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.unreadTweetFontName = node.getNodeValue();
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.unreadTweetFontSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unreadTweetFontColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-style")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        String style = node.getNodeValue();
                        this.unreadTweetFontStyle = style.equalsIgnoreCase("plain") ? 0 : (style.equalsIgnoreCase("bold") ? 1 : (style.equalsIgnoreCase("italic") ? 2 : 0));
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unreadTweetBorderColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.unreadTweetBorderSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("background-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unreadTweetBackgroundColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("foreground-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.unreadTweetForegroundColor = new Color((int)color);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.unreadTweetFont = new Font(this.unreadTweetFontName, this.unreadTweetFontStyle, this.unreadTweetFontSize);
        this.unreadTweetBorder = BorderFactory.createLineBorder(this.unreadTweetBorderColor, this.unreadTweetBorderSize);
    }

    private void readFavoriteTweetConfiguration(NodeList nodelist) {
        int i = 0;
        while (i < nodelist.getLength()) {
            long color;
            Node node;
            int j;
            NodeList childNodes;
            Node nodes = nodelist.item(i);
            String nodeName = nodes.getNodeName();
            if (nodeName.equals("font-name")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.favoriteTweetFontName = node.getNodeValue();
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.favoriteTweetFontSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.favoriteTweetFontColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("font-style")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        String style = node.getNodeValue();
                        this.favoriteTweetFontStyle = style.equalsIgnoreCase("plain") ? 0 : (style.equalsIgnoreCase("bold") ? 1 : (style.equalsIgnoreCase("italic") ? 2 : 0));
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.favoriteTweetBorderColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("border-size")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        this.favoriteTweetBorderSize = Integer.parseInt(node.getNodeValue());
                    }
                    ++j;
                }
            } else if (nodeName.equals("background-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.favoriteTweetBackgroundColor = new Color((int)color);
                    }
                    ++j;
                }
            } else if (nodeName.equals("foreground-color")) {
                childNodes = nodes.getChildNodes();
                j = 0;
                while (j < childNodes.getLength()) {
                    node = childNodes.item(j);
                    if (node.getNodeType() == 3) {
                        color = Long.parseLong(node.getNodeValue(), 16);
                        this.favoriteTweetForegroundColor = new Color((int)color);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.favoriteTweetFont = new Font(this.favoriteTweetFontName, this.favoriteTweetFontStyle, this.favoriteTweetFontSize);
        this.favoriteTweetBorder = BorderFactory.createLineBorder(this.favoriteTweetBorderColor, this.favoriteTweetBorderSize);
    }

    private Element writeUnselectedTweetConfiguration(Document doc) {
        Element element = doc.createElement("unselected-tweet");
        Element fontName = doc.createElement("font-name");
        fontName.appendChild(doc.createTextNode(this.unselectedTweetFontName));
        Element fontSize = doc.createElement("font-size");
        fontSize.appendChild(doc.createTextNode(Integer.toString(this.unselectedTweetFontSize)));
        Element fontColor = doc.createElement("font-color");
        fontColor.appendChild(doc.createTextNode(Integer.toHexString(this.unselectedTweetFontColor.getRGB())));
        Element fontStyle = doc.createElement("font-style");
        if (this.unselectedTweetFontStyle == 0) {
            fontStyle.appendChild(doc.createTextNode("plain"));
        } else if (this.unselectedTweetFontStyle == 1) {
            fontStyle.appendChild(doc.createTextNode("bold"));
        } else if (this.unselectedTweetFontStyle == 2) {
            fontStyle.appendChild(doc.createTextNode("italic"));
        }
        Element borderColor = doc.createElement("border-color");
        borderColor.appendChild(doc.createTextNode(Integer.toHexString(this.unselectedTweetBorderColor.getRGB())));
        Element borderSize = doc.createElement("border-size");
        borderSize.appendChild(doc.createTextNode(Integer.toString(this.unselectedTweetBorderSize)));
        Element backColor = doc.createElement("background-color");
        backColor.appendChild(doc.createTextNode(Integer.toHexString(this.unselectedTweetBackgroundColor.getRGB())));
        Element foreColor = doc.createElement("foreground-color");
        foreColor.appendChild(doc.createTextNode(Integer.toHexString(this.unselectedTweetForegroundColor.getRGB())));
        element.appendChild(fontName);
        element.appendChild(fontSize);
        element.appendChild(fontColor);
        element.appendChild(fontStyle);
        element.appendChild(borderColor);
        element.appendChild(borderSize);
        element.appendChild(backColor);
        element.appendChild(foreColor);
        return element;
    }

    private Element writeSelectedTweetConfiguration(Document doc) {
        Element element = doc.createElement("selected-tweet");
        Element fontName = doc.createElement("font-name");
        fontName.appendChild(doc.createTextNode(this.selectedTweetFontName));
        Element fontSize = doc.createElement("font-size");
        fontSize.appendChild(doc.createTextNode(Integer.toString(this.selectedTweetFontSize)));
        Element fontColor = doc.createElement("font-color");
        fontColor.appendChild(doc.createTextNode(Integer.toHexString(this.selectedTweetFontColor.getRGB())));
        Element fontStyle = doc.createElement("font-style");
        if (this.selectedTweetFontStyle == 0) {
            fontStyle.appendChild(doc.createTextNode("plain"));
        } else if (this.selectedTweetFontStyle == 1) {
            fontStyle.appendChild(doc.createTextNode("bold"));
        } else if (this.selectedTweetFontStyle == 2) {
            fontStyle.appendChild(doc.createTextNode("italic"));
        }
        Element borderColor = doc.createElement("border-color");
        borderColor.appendChild(doc.createTextNode(Integer.toHexString(this.selectedTweetBorderColor.getRGB())));
        Element borderSize = doc.createElement("border-size");
        borderSize.appendChild(doc.createTextNode(Integer.toString(this.selectedTweetBorderSize)));
        Element backColor = doc.createElement("background-color");
        backColor.appendChild(doc.createTextNode(Integer.toHexString(this.selectedTweetBackgroundColor.getRGB())));
        Element foreColor = doc.createElement("foreground-color");
        foreColor.appendChild(doc.createTextNode(Integer.toHexString(this.selectedTweetForegroundColor.getRGB())));
        element.appendChild(fontName);
        element.appendChild(fontSize);
        element.appendChild(fontColor);
        element.appendChild(fontStyle);
        element.appendChild(borderColor);
        element.appendChild(borderSize);
        element.appendChild(backColor);
        element.appendChild(foreColor);
        return element;
    }

    private Element writeUnreadTweetConfiguration(Document doc) {
        Element element = doc.createElement("unread-tweet");
        Element fontName = doc.createElement("font-name");
        fontName.appendChild(doc.createTextNode(this.unreadTweetFontName));
        Element fontSize = doc.createElement("font-size");
        fontSize.appendChild(doc.createTextNode(Integer.toString(this.unreadTweetFontSize)));
        Element fontColor = doc.createElement("font-color");
        fontColor.appendChild(doc.createTextNode(Integer.toHexString(this.unreadTweetFontColor.getRGB())));
        Element fontStyle = doc.createElement("font-style");
        if (this.unreadTweetFontStyle == 0) {
            fontStyle.appendChild(doc.createTextNode("plain"));
        } else if (this.unreadTweetFontStyle == 1) {
            fontStyle.appendChild(doc.createTextNode("bold"));
        } else if (this.unreadTweetFontStyle == 2) {
            fontStyle.appendChild(doc.createTextNode("italic"));
        }
        Element borderColor = doc.createElement("border-color");
        borderColor.appendChild(doc.createTextNode(Integer.toHexString(this.unreadTweetBorderColor.getRGB())));
        Element borderSize = doc.createElement("border-size");
        borderSize.appendChild(doc.createTextNode(Integer.toString(this.unreadTweetBorderSize)));
        Element backColor = doc.createElement("background-color");
        backColor.appendChild(doc.createTextNode(Integer.toHexString(this.unreadTweetBackgroundColor.getRGB())));
        Element foreColor = doc.createElement("foreground-color");
        foreColor.appendChild(doc.createTextNode(Integer.toHexString(this.unreadTweetForegroundColor.getRGB())));
        element.appendChild(fontName);
        element.appendChild(fontSize);
        element.appendChild(fontColor);
        element.appendChild(fontStyle);
        element.appendChild(borderColor);
        element.appendChild(borderSize);
        element.appendChild(backColor);
        element.appendChild(foreColor);
        return element;
    }

    private Element writeFavoriteTweetConfiguration(Document doc) {
        Element element = doc.createElement("favorite-tweet");
        Element fontName = doc.createElement("font-name");
        fontName.appendChild(doc.createTextNode(this.favoriteTweetFontName));
        Element fontSize = doc.createElement("font-size");
        fontSize.appendChild(doc.createTextNode(Integer.toString(this.favoriteTweetFontSize)));
        Element fontColor = doc.createElement("font-color");
        fontColor.appendChild(doc.createTextNode(Integer.toHexString(this.favoriteTweetFontColor.getRGB())));
        Element fontStyle = doc.createElement("font-style");
        if (this.favoriteTweetFontStyle == 0) {
            fontStyle.appendChild(doc.createTextNode("plain"));
        } else if (this.favoriteTweetFontStyle == 1) {
            fontStyle.appendChild(doc.createTextNode("bold"));
        } else if (this.favoriteTweetFontStyle == 2) {
            fontStyle.appendChild(doc.createTextNode("italic"));
        }
        Element borderColor = doc.createElement("border-color");
        borderColor.appendChild(doc.createTextNode(Integer.toHexString(this.favoriteTweetBorderColor.getRGB())));
        Element borderSize = doc.createElement("border-size");
        borderSize.appendChild(doc.createTextNode(Integer.toString(this.favoriteTweetBorderSize)));
        Element backColor = doc.createElement("background-color");
        backColor.appendChild(doc.createTextNode(Integer.toHexString(this.favoriteTweetBackgroundColor.getRGB())));
        Element foreColor = doc.createElement("foreground-color");
        foreColor.appendChild(doc.createTextNode(Integer.toHexString(this.favoriteTweetForegroundColor.getRGB())));
        element.appendChild(fontName);
        element.appendChild(fontSize);
        element.appendChild(fontColor);
        element.appendChild(fontStyle);
        element.appendChild(borderColor);
        element.appendChild(borderSize);
        element.appendChild(backColor);
        element.appendChild(foreColor);
        return element;
    }

    public static ClientComponentConfiguration getInstance() {
        return conf;
    }

    public String getUnselectedTweetFontName() {
        return this.unselectedTweetFontName;
    }

    public void setUnselectedTweetFontName(String unselectedTweetFontName) {
        this.unselectedTweetFontName = unselectedTweetFontName;
    }

    public int getUnselectedTweetFontSize() {
        return this.unselectedTweetFontSize;
    }

    public void setUnselectedTweetFontSize(int unselectedTweetFontSize) {
        this.unselectedTweetFontSize = unselectedTweetFontSize;
    }

    public Color getUnselectedTweetFontColor() {
        return this.unselectedTweetFontColor;
    }

    public void setUnselectedTweetFontColor(Color unselectedTweetFontColor) {
        this.unselectedTweetFontColor = unselectedTweetFontColor;
    }

    public int getUnselectedTweetFontStyle() {
        return this.unselectedTweetFontStyle;
    }

    public void setUnselectedTweetFontStyle(int unselectedTweetFontStyle) {
        this.unselectedTweetFontStyle = unselectedTweetFontStyle;
    }

    public Color getUnselectedTweetBorderColor() {
        return this.unselectedTweetBorderColor;
    }

    public void setUnselectedTweetBorderColor(Color unselectedTweetBorderColor) {
        this.unselectedTweetBorderColor = unselectedTweetBorderColor;
    }

    public int getUnselectedTweetBorderSize() {
        return this.unselectedTweetBorderSize;
    }

    public void setUnselectedTweetBorderSize(int unselectedTweetBorderSize) {
        this.unselectedTweetBorderSize = unselectedTweetBorderSize;
    }

    public Color getUnselectedTweetBackgroundColor() {
        return this.unselectedTweetBackgroundColor;
    }

    public void setUnselectedTweetBackgroundColor(Color unselectedTweetBackgroundColor) {
        this.unselectedTweetBackgroundColor = unselectedTweetBackgroundColor;
    }

    public Color getUnselectedTweetForegroundColor() {
        return this.unselectedTweetForegroundColor;
    }

    public void setUnselectedTweetForegroundColor(Color unselectedTweetForegroundColor) {
        this.unselectedTweetForegroundColor = unselectedTweetForegroundColor;
    }

    public Font getUnselectedTweetFont() {
        return this.unselectedTweetFont;
    }

    public void setUnselectedTweetFont(Font unselectedTweetFont) {
        this.unselectedTweetFont = unselectedTweetFont;
    }

    public Border getUnselectedTweetBorder() {
        return this.unselectedTweetBorder;
    }

    public void setUnselectedTweetBorder(Border unselectedTweetBorder) {
        this.unselectedTweetBorder = unselectedTweetBorder;
    }

    public String getSelectedTweetFontName() {
        return this.selectedTweetFontName;
    }

    public void setSelectedTweetFontName(String selectedTweetFontName) {
        this.selectedTweetFontName = selectedTweetFontName;
    }

    public int getSelectedTweetFontSize() {
        return this.selectedTweetFontSize;
    }

    public void setSelectedTweetFontSize(int selectedTweetFontSize) {
        this.selectedTweetFontSize = selectedTweetFontSize;
    }

    public Color getSelectedTweetFontColor() {
        return this.selectedTweetFontColor;
    }

    public void setSelectedTweetFontColor(Color selectedTweetFontColor) {
        this.selectedTweetFontColor = selectedTweetFontColor;
    }

    public int getSelectedTweetFontStyle() {
        return this.selectedTweetFontStyle;
    }

    public void setSelectedTweetFontStyle(int selectedTweetFontStyle) {
        this.selectedTweetFontStyle = selectedTweetFontStyle;
    }

    public Color getSelectedTweetBorderColor() {
        return this.selectedTweetBorderColor;
    }

    public void setSelectedTweetBorderColor(Color selectedTweetBorderColor) {
        this.selectedTweetBorderColor = selectedTweetBorderColor;
    }

    public int getSelectedTweetBorderSize() {
        return this.selectedTweetBorderSize;
    }

    public void setSelectedTweetBorderSize(int selectedTweetBorderSize) {
        this.selectedTweetBorderSize = selectedTweetBorderSize;
    }

    public Color getSelectedTweetBackgroundColor() {
        return this.selectedTweetBackgroundColor;
    }

    public void setSelectedTweetBackgroundColor(Color selectedTweetBackgroundColor) {
        this.selectedTweetBackgroundColor = selectedTweetBackgroundColor;
    }

    public Color getSelectedTweetForegroundColor() {
        return this.selectedTweetForegroundColor;
    }

    public void setSelectedTweetForegroundColor(Color selectedTweetForegroundColor) {
        this.selectedTweetForegroundColor = selectedTweetForegroundColor;
    }

    public Font getSelectedTweetFont() {
        return this.selectedTweetFont;
    }

    public void setSelectedTweetFont(Font selectedTweetFont) {
        this.selectedTweetFont = selectedTweetFont;
    }

    public Border getSelectedTweetBorder() {
        return this.selectedTweetBorder;
    }

    public void setSelectedTweetBorder(Border selectedTweetBorder) {
        this.selectedTweetBorder = selectedTweetBorder;
    }

    public String getUnreadTweetFontName() {
        return this.unreadTweetFontName;
    }

    public void setUnreadTweetFontName(String unreadTweetFontName) {
        this.unreadTweetFontName = unreadTweetFontName;
    }

    public int getUnreadTweetFontSize() {
        return this.unreadTweetFontSize;
    }

    public void setUnreadTweetFontSize(int unreadTweetFontSize) {
        this.unreadTweetFontSize = unreadTweetFontSize;
    }

    public Color getUnreadTweetFontColor() {
        return this.unreadTweetFontColor;
    }

    public void setUnreadTweetFontColor(Color unreadTweetFontColor) {
        this.unreadTweetFontColor = unreadTweetFontColor;
    }

    public int getUnreadTweetFontStyle() {
        return this.unreadTweetFontStyle;
    }

    public void setUnreadTweetFontStyle(int unreadTweetFontStyle) {
        this.unreadTweetFontStyle = unreadTweetFontStyle;
    }

    public Color getUnreadTweetBorderColor() {
        return this.unreadTweetBorderColor;
    }

    public void setUnreadTweetBorderColor(Color unreadTweetBorderColor) {
        this.unreadTweetBorderColor = unreadTweetBorderColor;
    }

    public int getUnreadTweetBorderSize() {
        return this.unreadTweetBorderSize;
    }

    public void setUnreadTweetBorderSize(int unreadTweetBorderSize) {
        this.unreadTweetBorderSize = unreadTweetBorderSize;
    }

    public Color getUnreadTweetBackgroundColor() {
        return this.unreadTweetBackgroundColor;
    }

    public void setUnreadTweetBackgroundColor(Color unreadTweetBackgroundColor) {
        this.unreadTweetBackgroundColor = unreadTweetBackgroundColor;
    }

    public Color getUnreadTweetForegroundColor() {
        return this.unreadTweetForegroundColor;
    }

    public void setUnreadTweetForegroundColor(Color unreadTweetForegroundColor) {
        this.unreadTweetForegroundColor = unreadTweetForegroundColor;
    }

    public Font getUnreadTweetFont() {
        return this.unreadTweetFont;
    }

    public void setUnreadTweetFont(Font unreadTweetFont) {
        this.unreadTweetFont = unreadTweetFont;
    }

    public Border getUnreadTweetBorder() {
        return this.unreadTweetBorder;
    }

    public void setUnreadTweetBorder(Border unreadTweetBorder) {
        this.unreadTweetBorder = unreadTweetBorder;
    }

    public String getFavoriteTweetFontName() {
        return this.favoriteTweetFontName;
    }

    public void setFavoriteTweetFontName(String favoriteTweetFontName) {
        this.favoriteTweetFontName = favoriteTweetFontName;
    }

    public int getFavoriteTweetFontSize() {
        return this.favoriteTweetFontSize;
    }

    public void setFavoriteTweetFontSize(int favoriteTweetFontSize) {
        this.favoriteTweetFontSize = favoriteTweetFontSize;
    }

    public Color getFavoriteTweetFontColor() {
        return this.favoriteTweetFontColor;
    }

    public void setFavoriteTweetFontColor(Color favoriteTweetFontColor) {
        this.favoriteTweetFontColor = favoriteTweetFontColor;
    }

    public int getFavoriteTweetFontStyle() {
        return this.favoriteTweetFontStyle;
    }

    public void setFavoriteTweetFontStyle(int favoriteTweetFontStyle) {
        this.favoriteTweetFontStyle = favoriteTweetFontStyle;
    }

    public Color getFavoriteTweetBorderColor() {
        return this.favoriteTweetBorderColor;
    }

    public void setFavoriteTweetBorderColor(Color favoriteTweetBorderColor) {
        this.favoriteTweetBorderColor = favoriteTweetBorderColor;
    }

    public int getFavoriteTweetBorderSize() {
        return this.favoriteTweetBorderSize;
    }

    public void setFavoriteTweetBorderSize(int favoriteTweetBorderSize) {
        this.favoriteTweetBorderSize = favoriteTweetBorderSize;
    }

    public Color getFavoriteTweetBackgroundColor() {
        return this.favoriteTweetBackgroundColor;
    }

    public void setFavoriteTweetBackgroundColor(Color favoriteTweetBackgroundColor) {
        this.favoriteTweetBackgroundColor = favoriteTweetBackgroundColor;
    }

    public Color getFavoriteTweetForegroundColor() {
        return this.favoriteTweetForegroundColor;
    }

    public void setFavoriteTweetForegroundColor(Color favoriteTweetForegroundColor) {
        this.favoriteTweetForegroundColor = favoriteTweetForegroundColor;
    }

    public Font getFavoriteTweetFont() {
        return this.favoriteTweetFont;
    }

    public void setFavoriteTweetFont(Font favoriteTweetFont) {
        this.favoriteTweetFont = favoriteTweetFont;
    }

    public Border getFavoriteTweetBorder() {
        return this.favoriteTweetBorder;
    }

    public void setFavoriteTweetBorder(Border favoriteTweetBorder) {
        this.favoriteTweetBorder = favoriteTweetBorder;
    }
}

