/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TwitterUserInfo {
    private long id = -1L;
    private String name = "";
    private String screenName = "";
    private String location = "";
    private String description = "";
    private URL profileImageUrl = null;
    private URL url = null;
    private boolean isProtect = false;
    private int followersCount = 0;
    private String profileBackgroundColor = null;
    private String profileTextColor = "";
    private String profileLinkColor = "";
    private String profileSidebarFillColor = "";
    private String profileSidebarBorderColor = "";
    private int friendsCount = 0;
    private String createdAt = "";
    private int favouritesCount = 0;
    private int utcOffset = 0;
    private String timeZone;
    private URL profileBackgroundImageUrl = null;
    private boolean profileBackgroundTile = false;
    private boolean notification = false;
    private boolean geoEnabled = false;
    private boolean verified = false;
    private boolean following = false;
    private int statusesCount = 0;
    private String lang;
    private boolean contributorsEnabled = false;
    private final String[] tags = new String[]{"id", "name", "screen_name", "location", "description", "profile_image_url", "url", "protected", "followers_count", "profile_background_color", "profile_text_color", "profile_link_color", "profile_sidebar_fill_color", "profile_sidebar_border_color", "friends_count", "created_at", "favourites_count", "utc_offset", "time_zone", "profile_background_image_url", "profile_background_tile", "notifications", "geo_enabled", "verified", "following", "statuses_count", "lang", "contributors_enabled"};
    private boolean loaded = false;

    public TwitterUserInfo() {
        this.timeZone = TimeZone.getDefault().getDisplayName();
        this.lang = System.getProperty("user.language");
    }

    public boolean load(InputStream in) {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            this.loaded = this.load(childNodes);
        }
        catch (Exception e) {
            System.err.println("During reading Twitter account information, we meets error.");
            System.exit(1);
        }
        return this.loaded;
    }

    public boolean load(NodeList childNodes) {
        int loadCount = 0;
        try {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node;
                int j;
                NodeList nodelist;
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals(this.tags[0])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.id = Long.parseLong(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[1])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.name = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[2])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.screenName = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[3])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        this.location = "";
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.location = node.getNodeValue();
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[4])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        this.description = "";
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.description = node.getNodeValue();
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[5])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            try {
                                this.profileImageUrl = new URL(node.getNodeValue());
                                ++loadCount;
                            }
                            catch (MalformedURLException e) {
                                System.err.println("Profile image URL is not verified: " + node.getNodeValue());
                                this.profileImageUrl = new URL("");
                                ++loadCount;
                            }
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[6])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                try {
                                    this.url = new URL(node.getNodeValue());
                                    ++loadCount;
                                }
                                catch (MalformedURLException e) {
                                    System.err.println("Your URL is not verified: " + node.getNodeValue());
                                    this.url = new URL("");
                                    ++loadCount;
                                }
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[7])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.isProtect = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[8])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.followersCount = Integer.parseInt(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[9])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.profileBackgroundColor = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[10])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.profileTextColor = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[11])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.profileLinkColor = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[12])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.profileSidebarFillColor = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[13])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.profileSidebarBorderColor = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[14])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.friendsCount = Integer.parseInt(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[15])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.createdAt = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[16])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        ++loadCount;
                        this.favouritesCount = 0;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.favouritesCount = Integer.parseInt(node.getNodeValue());
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[17])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        this.utcOffset = 0;
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.utcOffset = Integer.parseInt(node.getNodeValue());
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[18])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        this.timeZone = "";
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.timeZone = node.getNodeValue();
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[19])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            try {
                                this.profileBackgroundImageUrl = new URL(node.getNodeValue());
                                ++loadCount;
                            }
                            catch (MalformedURLException e) {
                                System.err.println("Profile background image URL is not verified: " + node.getNodeValue());
                                this.profileBackgroundImageUrl = new URL("");
                                ++loadCount;
                            }
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[20])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.profileBackgroundTile = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[21])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        this.notification = false;
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.notification = Boolean.parseBoolean(node.getNodeValue());
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[22])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.geoEnabled = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[23])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.verified = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[24])) {
                    nodelist = nodes.getChildNodes();
                    if (nodelist.getLength() == 0) {
                        this.following = false;
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.following = Boolean.parseBoolean(node.getNodeValue());
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[25])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.statusesCount = Integer.parseInt(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[26])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.lang = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[27])) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.contributorsEnabled = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("During reading Twitter account information, we meets error.");
            System.exit(1);
        }
        if (loadCount == this.tags.length) {
            this.loaded = true;
        }
        return this.loaded;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isProtect() {
        return this.isProtect;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public String getCreatedAt() {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(this.createdAt));
            return cal.getTime().toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return this.createdAt;
        }
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public URL getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public boolean isProfileBackgounrdTile() {
        return this.profileBackgroundTile;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isContributersEnabled() {
        return this.contributorsEnabled;
    }

    public String[] getTags() {
        return this.tags;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String toString() {
        return this.screenName;
    }
}

