/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.TwitterUserInfo;

public class Tweet {
    private String createdAt = "";
    private long id;
    private String text = "";
    private String source = "";
    private boolean truncated = false;
    private long inReplyToStatusId = 0L;
    private long inReplyToUserId = 0L;
    private boolean favorited = false;
    private String inReplyToScreenName = "";
    private TwitterUserInfo user;
    private Tweet retweetTo;
    private ImageIcon icon;
    private String tweetTitle;
    private String tweetText;
    private String tweetInfo;
    private boolean read = false;
    private ArrayList<String> tweetURLs;
    private final String[] tags = new String[]{"created_at", "id", "text", "source", "truncated", "in_reply_to_status_id", "in_reply_to_user_id", "favorited", "in_reply_to_screen_name", "user", "geo", "coordinates", "place", "contributors"};
    private boolean loaded;

    public Tweet() {
        this.user = new TwitterUserInfo();
        this.tweetURLs = new ArrayList();
    }

    public boolean load(InputStream in) {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            return this.load(childNodes);
        }
        catch (Exception e) {
            System.err.println("During reading timeline, we meets error.");
            System.exit(1);
            return false;
        }
    }

    public boolean load(NodeList nodelist) {
        int loadCount = 0;
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                Node node;
                int j;
                NodeList childNodes;
                Node nodes = nodelist.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals(this.tags[0])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.createdAt = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[1])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.id = Long.parseLong(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[2])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            try {
                                this.text = URLDecoder.decode(node.getNodeValue(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                this.text = node.getNodeValue();
                            }
                            catch (IllegalArgumentException e) {
                                this.text = node.getNodeValue();
                            }
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[3])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.source = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[4])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.truncated = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[5])) {
                    childNodes = nodes.getChildNodes();
                    if (childNodes.getLength() == 0) {
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < childNodes.getLength()) {
                            node = childNodes.item(j);
                            if (node.getNodeType() == 3) {
                                this.inReplyToStatusId = Long.parseLong(node.getNodeValue());
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[6])) {
                    childNodes = nodes.getChildNodes();
                    if (childNodes.getLength() == 0) {
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < childNodes.getLength()) {
                            node = childNodes.item(j);
                            if (node.getNodeType() == 3) {
                                this.inReplyToUserId = Long.parseLong(node.getNodeValue());
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[7])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.favorited = Boolean.parseBoolean(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[8])) {
                    childNodes = nodes.getChildNodes();
                    if (childNodes.getLength() == 0) {
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < childNodes.getLength()) {
                            node = childNodes.item(j);
                            if (node.getNodeType() == 3) {
                                this.inReplyToScreenName = node.getNodeValue();
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[9])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        if (this.user.load(childNodes)) {
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[10])) {
                    ++loadCount;
                } else if (nodeName.equals(this.tags[11])) {
                    ++loadCount;
                } else if (nodeName.equals(this.tags[12])) {
                    ++loadCount;
                } else if (nodeName.equals(this.tags[13])) {
                    ++loadCount;
                } else if (nodeName.equals("retweeted_status")) {
                    this.retweetTo = new Tweet();
                    this.retweetTo.load(nodes.getChildNodes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("During reading tweet, we meets error.");
            System.exit(1);
        }
        if (loadCount == this.tags.length) {
            this.loaded = true;
            this.setup();
        }
        return this.loaded;
    }

    public void setup() {
        this.tweetURLs = new ArrayList();
        if (this.isRetweet()) {
            this.tweetInfo = "<html>Retweet by<br>User ID: " + this.user.getScreenName() + "<br>" + "Friends: " + this.user.getFriendsCount() + "<br>" + "Followers: " + this.user.getFollowersCount() + "<br>" + "# of tweets: " + this.user.getStatusesCount() + "<br>" + "From: " + this.source + "<br>" + "Since: " + this.user.getCreatedAt() + "<br>" + "<hr>" + "Original tweet by" + "<br>" + "User ID: " + this.retweetTo.getUser().getScreenName() + "<br>" + "Friends: " + this.retweetTo.getUser().getFriendsCount() + "<br>" + "Followers: " + this.retweetTo.getUser().getFollowersCount() + "<br>" + "# of tweets: " + this.retweetTo.getUser().getStatusesCount() + "<br>" + "From: " + this.retweetTo.getSource() + "<br>" + "Since: " + this.retweetTo.getUser().getCreatedAt() + "</html>";
            this.tweetTitle = "RT: " + this.retweetTo.getUser().getScreenName() + "/" + this.retweetTo.getUser().getName() + "\u2192" + this.user.getScreenName() + "/" + this.user.getName();
            if (this.isFavorited()) {
                this.tweetTitle = String.valueOf(this.tweetTitle) + " (Fav)";
            }
            Pattern pattern = Pattern.compile("http://[[a-zA-Z0-9\\p{Punct}]*/{1}]*");
            Matcher matcher = pattern.matcher(this.text);
            while (matcher.find()) {
                this.tweetURLs.add(matcher.group());
            }
            this.tweetText = String.valueOf(this.retweetTo.getText()) + "\n" + this.getCreatedAt();
            try {
                BufferedImage imgRT = ImageIO.read(this.user.getProfileImageUrl());
                BufferedImage img = ImageIO.read(this.retweetTo.getUser().getProfileImageUrl());
                BufferedImage iconImg = new BufferedImage(48, 48, 2);
                iconImg.getGraphics().drawImage(img.getScaledInstance(40, 40, 4), 0, 0, null);
                iconImg.getGraphics().drawImage(imgRT.getScaledInstance(24, 24, 4), 24, 24, null);
                this.icon = new ImageIcon(iconImg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.tweetInfo = "<html>User ID: " + this.user.getScreenName() + "<br>" + "Friends: " + this.user.getFriendsCount() + "<br>" + "Followers: " + this.user.getFollowersCount() + "<br>" + "# of tweets: " + this.user.getStatusesCount() + "<br>" + "From: " + this.source + "<br>" + "Since: " + this.user.getCreatedAt() + "</html>";
            this.tweetTitle = String.valueOf(this.user.getScreenName()) + "/" + this.user.getName();
            if (this.isFavorited()) {
                this.tweetTitle = String.valueOf(this.tweetTitle) + " (Fav)";
            }
            Pattern pattern = Pattern.compile("http://[[a-zA-Z0-9\\p{Punct}]*/{1}]*");
            Matcher matcher = pattern.matcher(this.text);
            while (matcher.find()) {
                this.tweetURLs.add(matcher.group());
            }
            this.tweetText = String.valueOf(this.text) + "\n" + this.getCreatedAt();
            Image img = Toolkit.getDefaultToolkit().createImage(this.user.getProfileImageUrl());
            img = img.getScaledInstance(48, 48, 4);
            this.icon = new ImageIcon(img);
        }
    }

    public void replaceShortenURLs(LinkedHashMap<String, String> urlMap) {
        if (this.isRetweet()) {
            this.retweetTo.replaceShortenURLs(urlMap);
            this.setup();
        } else {
            for (String key : urlMap.keySet()) {
                this.text = this.text.replace(key, urlMap.get(key));
            }
            this.setup();
        }
    }

    public String getCreatedAt() {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(this.createdAt));
            return cal.getTime().toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return this.createdAt;
        }
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public TwitterUserInfo getUser() {
        return this.user;
    }

    public String[] getTags() {
        return this.tags;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isRetweet() {
        return this.retweetTo != null;
    }

    public Tweet getReTweet() {
        return this.retweetTo;
    }

    public Iterable<String> getTweetedURLs() {
        return this.tweetURLs;
    }

    public void setFavorited(boolean favorited) {
        this.favorited = favorited;
        this.tweetTitle = String.valueOf(this.user.getScreenName()) + "/" + this.user.getName();
        if (this.isFavorited()) {
            this.tweetTitle = String.valueOf(this.tweetTitle) + " (Fav)";
        }
    }

    public Date getCreatedDate() {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(this.createdAt));
            return cal.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getTweetTitle() {
        return this.tweetTitle;
    }

    public String getTweetText() {
        return this.tweetText;
    }

    public String getTweetInfo() {
        return this.tweetInfo;
    }

    public String toSimpleString() {
        return String.valueOf(this.text) + " by " + this.user.getName() + " at " + this.getCreatedAt();
    }

    public String toString() {
        return String.valueOf(this.text) + " by " + this.user.getName() + "(" + this.user.getScreenName() + ")" + " at " + this.getCreatedAt();
    }

    public void read() {
        this.read = true;
    }

    public boolean isRead() {
        return this.read;
    }
}

