/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oauth.signpost.OAuthConsumer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.RateLimitReader;
import twitclient.Tweet;
import twitclient.TwitterList;

public class ListManager {
    private ArrayList<TwitterList> lists = new ArrayList();

    public long load(InputStream in, boolean ownership, boolean subscribed, boolean membered) {
        long nextCursor = 0L;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals("lists")) {
                    NodeList nodelist = nodes.getChildNodes();
                    int j = 0;
                    while (j < nodelist.getLength()) {
                        TwitterList list;
                        Node n = nodelist.item(j);
                        if (n.getNodeName().equals("list") && (list = new TwitterList()).load(n.getChildNodes())) {
                            if (ownership) {
                                list.setOwnership(ownership);
                            } else if (subscribed) {
                                list.setSubscribed(subscribed);
                            } else if (membered) {
                                list.setMembered(membered);
                            }
                            this.lists.add(list);
                        }
                        ++j;
                    }
                } else if (nodeName.equals("next_cursor")) {
                    nextCursor = Long.parseLong(nodes.getTextContent());
                } else {
                    nodeName.equals("previous_cursor");
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("During reading list of lists, we meets error.");
            System.exit(1);
        }
        return nextCursor;
    }

    public int updateAllLists(RateLimitReader rateLimitReader, int perPage, OAuthConsumer consumer) {
        for (TwitterList list : this.lists) {
            int status = 0;
            status = list.hasOwnership() ? list.updateOwnedLists(rateLimitReader, perPage, consumer) : list.update(rateLimitReader, perPage);
            if (status == 200) continue;
            return status;
        }
        return 200;
    }

    public int updateOwnedLists(RateLimitReader rateLimitReader, int perPage, OAuthConsumer consumer) {
        for (TwitterList list : this.getOwnedLists()) {
            int status = list.updateOwnedLists(rateLimitReader, perPage, consumer);
            if (status == 200) continue;
            return status;
        }
        return 200;
    }

    public int updateSubscribedLists(RateLimitReader rateLimitReader, int perPage) {
        for (TwitterList list : this.getSubscribedLists()) {
            int status = list.update(rateLimitReader, perPage);
            if (status == 200) continue;
            return status;
        }
        return 200;
    }

    public int updateMemberedLists(RateLimitReader rateLimitReader, int perPage) {
        for (TwitterList list : this.getMemberedLists()) {
            int status = list.update(rateLimitReader, perPage);
            if (status == 200) continue;
            return status;
        }
        return 200;
    }

    public Iterable<TwitterList> getAllLists() {
        return this.lists;
    }

    public Iterable<TwitterList> getOwnedLists() {
        ArrayList<TwitterList> results = new ArrayList<TwitterList>();
        for (TwitterList list : this.lists) {
            if (!list.hasOwnership()) continue;
            results.add(list);
        }
        return results;
    }

    public Iterable<TwitterList> getSubscribedLists() {
        ArrayList<TwitterList> results = new ArrayList<TwitterList>();
        for (TwitterList list : this.lists) {
            if (!list.isSubscribed()) continue;
            results.add(list);
        }
        return results;
    }

    public Iterable<TwitterList> getMemberedLists() {
        ArrayList<TwitterList> results = new ArrayList<TwitterList>();
        for (TwitterList list : this.lists) {
            if (!list.isMembered()) continue;
            results.add(list);
        }
        return results;
    }

    public Iterable<Tweet> getTimelineInList(long id) {
        for (TwitterList list : this.lists) {
            if (id != list.getID()) continue;
            return list.getTweets();
        }
        return new ArrayList<Tweet>();
    }

    public Iterable<Tweet> getTimelineInList(String slug) {
        for (TwitterList list : this.lists) {
            if (!list.getSlug().equals(slug)) continue;
            return list.getTweets();
        }
        return new ArrayList<Tweet>();
    }

    public long getIDFor(String slug) {
        for (TwitterList list : this.lists) {
            if (!list.getSlug().equals(slug)) continue;
            return list.getID();
        }
        return 0L;
    }

    public int getNumberOfLists() {
        return this.lists.size();
    }

    public TwitterList getListAt(int index) {
        return this.lists.get(index);
    }

    public void remove(long id) {
        TwitterList remList = null;
        for (TwitterList list : this.lists) {
            if (list.getID() != id) continue;
            remList = list;
        }
        if (remList != null) {
            this.lists.remove(remList);
        }
    }

    public void add(TwitterList list) {
        this.lists.add(list);
    }

    public void remove(String slug) {
        TwitterList remList = null;
        for (TwitterList list : this.lists) {
            if (!list.getSlug().equals(slug)) continue;
            remList = list;
        }
        if (remList != null) {
            this.lists.remove(remList);
        }
    }
}

