/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.TwitterUserInfo;

public class DirectMessage {
    private long id = 0L;
    private long senderId = 0L;
    private String text = "";
    private long recipientId = 0L;
    private String createdAt = "";
    private String senderScreenName = "";
    private String recipientScreenName = "";
    private TwitterUserInfo sender;
    private TwitterUserInfo recipient;
    private ImageIcon icon;
    private String tweetTitle;
    private String tweetText;
    private String tweetInfo;
    private boolean read = false;
    private final String[] tags = new String[]{"id", "sender_id", "text", "recipient_id", "created_at", "sender_screen_name", "recipient_screen_name", "sender", "recipient"};
    private boolean loaded;

    public DirectMessage() {
        this.sender = new TwitterUserInfo();
        this.recipient = new TwitterUserInfo();
    }

    public boolean load(NodeList nodelist) {
        int loadCount = 0;
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                Node node;
                int j;
                NodeList childNodes;
                Node nodes = nodelist.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals(this.tags[0])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.id = Long.parseLong(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[1])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.senderId = Long.parseLong(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[2])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            try {
                                this.text = URLDecoder.decode(node.getNodeValue(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                this.text = node.getNodeValue();
                            }
                            catch (IllegalArgumentException e) {
                                this.text = node.getNodeValue();
                            }
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[3])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.recipientId = Long.parseLong(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[4])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.createdAt = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[5])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.senderScreenName = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[6])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        node = childNodes.item(j);
                        if (node.getNodeType() == 3) {
                            this.recipientScreenName = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[7])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        if (this.sender.load(childNodes)) {
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[8])) {
                    childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        if (this.recipient.load(childNodes)) {
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("During reading direct message, we meets error.");
            System.exit(1);
        }
        if (loadCount == this.tags.length) {
            this.loaded = true;
            this.setup();
        }
        return this.loaded;
    }

    public void setup() {
        this.tweetInfo = "<html>User ID: " + this.sender.getScreenName() + "<br>" + "Friends: " + this.sender.getFriendsCount() + "<br>" + "Followers: " + this.sender.getFollowersCount() + "<br>" + "# of tweets: " + this.sender.getStatusesCount() + "<br>" + "Since: " + this.sender.getCreatedAt() + "</html>";
        this.tweetTitle = String.valueOf(this.sender.getScreenName()) + "/" + this.sender.getName();
        this.tweetText = String.valueOf(this.text) + "\n" + this.getCreatedAt();
        this.icon = new ImageIcon(this.sender.getProfileImageUrl());
        if (this.icon.getIconWidth() > 48 || this.icon.getIconHeight() > 48 || this.icon.getIconWidth() < 0 || this.icon.getIconHeight() < 0) {
            Image img = Toolkit.getDefaultToolkit().createImage(this.sender.getProfileImageUrl());
            img = img.getScaledInstance(48, 48, 4);
            this.icon = new ImageIcon(img);
        }
    }

    public String getCreatedAt() {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(this.createdAt));
            return cal.getTime().toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return this.createdAt;
        }
    }

    public long getID() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public long getSenderID() {
        return this.senderId;
    }

    public long getRecipientID() {
        return this.recipientId;
    }

    public String getSenderScreenName() {
        return this.senderScreenName;
    }

    public String getRecipientScreenName() {
        return this.recipientScreenName;
    }

    public TwitterUserInfo getSender() {
        return this.sender;
    }

    public TwitterUserInfo getRecipient() {
        return this.recipient;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getTweetTitle() {
        return this.tweetTitle;
    }

    public String getTweetText() {
        return this.tweetText;
    }

    public String getTweetInfo() {
        return this.tweetInfo;
    }

    public String toSimpleString() {
        return String.valueOf(this.text) + " by " + this.sender.getName() + " at " + this.getCreatedAt();
    }

    public String toString() {
        return String.valueOf(this.text) + " by " + this.sender.getName() + "(" + this.sender.getScreenName() + ")" + " at " + this.getCreatedAt();
    }

    public void read() {
        this.read = true;
    }

    public boolean isRead() {
        return this.read;
    }
}

