/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.gui.PostManager;
import twitclient.gui.TweetPopupMenu;
import twitclient.gui.TweetPopupMenuHandler;
import twitclient.gui.TweetRenderer;

public class ReplyChainFrame
extends JFrame {
    private static final long serialVersionUID = 8604042719611217319L;
    private JList list = new JList();
    private DefaultListModel model = new DefaultListModel();

    public ReplyChainFrame(Tweet tweet) {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        PostManager postManager = PostManager.getInstance();
        this.list.setCellRenderer(new TweetRenderer());
        this.list.setModel(this.model);
        this.list.addListSelectionListener(postManager);
        this.list.setSelectionMode(0);
        this.list.addKeyListener(postManager);
        TweetPopupMenu popup = new TweetPopupMenu();
        TweetPopupMenuHandler handler = new TweetPopupMenuHandler(popup);
        this.list.addMouseListener(handler);
        ArrayList<String> membersScreenName = new ArrayList<String>();
        for (Tweet t : NTRClient.getInstance().getTwitterController().getReplyChainFrom(tweet)) {
            this.model.addElement(t);
            String name = t.getUser().getScreenName();
            if (membersScreenName.contains(name)) continue;
            membersScreenName.add(name);
        }
        String title = "Conversation between: \"" + (String)membersScreenName.get(0);
        int i = 1;
        while (i < membersScreenName.size()) {
            title = String.valueOf(title) + ", " + (String)membersScreenName.get(i);
            ++i;
        }
        title = String.valueOf(title) + "\"";
        this.setTitle(title);
        panel.add(new JScrollPane(this.list));
        this.add(panel);
    }
}

