/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import twitclient.DirectMessage;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.TwitterUserInfo;
import twitclient.gui.ClientShortcutKeyManager;
import twitclient.gui.ReplyChainFrame;
import twitclient.url.URLShorter;

public class PostManager
implements ActionListener,
ListSelectionListener,
KeyListener {
    private static PostManager postManager = new PostManager();
    private ClientShortcutKeyManager shortcutManager = ClientShortcutKeyManager.getInstance();
    private URLShorter urlShorter = URLShorter.getInstance();
    private Tweet selectedTweet = null;
    private Tweet reservedTweet = null;
    private DirectMessage selectedDirectMessage = null;
    private JTextArea tweetArea;
    private JTextField footerArea;
    private JButton postButton;
    private boolean enableToPost = true;

    public void setTweetArea(JTextArea tweetArea) {
        this.tweetArea = tweetArea;
    }

    public void setFooterArea(JTextField footerArea) {
        this.footerArea = footerArea;
    }

    public void setPostButton(JButton postButton) {
        this.postButton = postButton;
        this.postButton.setForeground(Color.black);
    }

    private PostManager() {
    }

    public static PostManager getInstance() {
        return postManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("send tweet")) {
            this.postTweet();
        } else if (e.getActionCommand().equals("clear footer")) {
            this.footerArea.setText("");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof JList) {
            JList list = (JList)e.getSource();
            Object obj = list.getSelectedValue();
            if (obj instanceof Tweet) {
                this.selectedTweet = (Tweet)list.getSelectedValue();
                this.selectedTweet.read();
            } else if (obj instanceof DirectMessage) {
                this.selectedDirectMessage = (DirectMessage)list.getSelectedValue();
                this.selectedDirectMessage.read();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.shortcutManager.isPostTweet(e)) {
            this.postTweet();
        } else if (this.shortcutManager.isSelectReplyTo(e)) {
            this.replayToSelectedTweet();
        } else if (this.shortcutManager.isRetweet(e)) {
            this.rewteetSelectedTweet();
        } else if (this.shortcutManager.isQuoteTweet(e)) {
            this.quoteTweetToSelectedTweet();
        } else if (this.shortcutManager.isSendDirectMessage(e)) {
            this.sendDirectMessegeToSelectedUser();
        } else if (this.shortcutManager.isFavorite(e)) {
            this.manageFavoriteFlag();
        } else if (this.shortcutManager.isDeleteMyTweet(e)) {
            this.deleteSelectedTweet();
        } else if (this.shortcutManager.isShortenURLInTweet(e)) {
            this.shortenURLinTweet();
        } else if (this.shortcutManager.isExpandURLInTweet(e)) {
            this.expandURLinTweet();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateNumberOfCurrentTweet();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() instanceof JList) {
            if (e.getKeyCode() == 38) {
                JList list = (JList)e.getSource();
                int selectedIndex = list.getSelectedIndex();
                list.setSelectedIndex(selectedIndex - 1);
                if (list.getSelectedValue() instanceof Tweet) {
                    this.selectedTweet = (Tweet)list.getSelectedValue();
                }
            } else if (e.getKeyCode() == 40 && e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                int selectedIndex = list.getSelectedIndex();
                list.setSelectedIndex(selectedIndex + 1);
                if (list.getSelectedValue() instanceof Tweet) {
                    this.selectedTweet = (Tweet)list.getSelectedValue();
                }
            }
        }
    }

    private void updateNumberOfCurrentTweet() {
        String[] components;
        String post = this.tweetArea.getText();
        String footer = this.footerArea.getText();
        if (!footer.isEmpty()) {
            post = String.valueOf(post) + " " + footer;
        }
        if (post.matches("[D][ ]\\w+[ ].*") && (components = post.split(" ")).length >= 3) {
            String text = components[2];
            int i = 3;
            while (i < components.length) {
                text = String.valueOf(text) + " " + components[i];
                ++i;
            }
            post = text;
        }
        int rest = 140 - post.length();
        this.postButton.setText("<html><div align=\"center\">Post<br>" + rest + "</div></html>");
        if (rest < 0) {
            this.enableToPost = false;
            this.postButton.setForeground(Color.red);
        } else {
            this.enableToPost = true;
            this.postButton.setForeground(Color.black);
        }
        this.postButton.setEnabled(this.enableToPost);
    }

    public void postTweet() {
        if (!this.enableToPost) {
            JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), "Your tweet is over 140 characters.", "Too long tweet!!", 0);
            return;
        }
        String post = this.tweetArea.getText();
        String footer = this.footerArea.getText();
        if (!footer.isEmpty()) {
            post = String.valueOf(post) + " " + footer;
        }
        if (post.matches("[D][ ]\\w+[ ].*")) {
            String[] components = post.split(" ");
            if (components.length >= 3) {
                String screenName = components[1];
                String text = components[2];
                int i = 3;
                while (i < components.length) {
                    text = String.valueOf(text) + " " + components[i];
                    ++i;
                }
                System.out.println("Send direct message: " + text + " to " + screenName);
                int status = NTRClient.getInstance().sendDirectMessage(text, screenName);
                if (200 == status) {
                    this.clearTextAndTarget();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            } else {
                System.out.println("Invalid direct message");
                this.clearTextAndTarget();
            }
        } else if (this.reservedTweet != null) {
            if (post.contains("@" + this.reservedTweet.getUser().getScreenName())) {
                System.out.println("Post: " + post + " to " + this.reservedTweet);
                int status = NTRClient.getInstance().postTweet(post, this.reservedTweet);
                if (200 == status) {
                    this.clearTextAndTarget();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            } else {
                System.out.println("Post: " + post);
                int status = NTRClient.getInstance().postTweet(post);
                if (200 == status) {
                    this.clearTextAndTarget();
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        } else {
            System.out.println("Post: " + post);
            int status = NTRClient.getInstance().postTweet(post);
            if (200 == status) {
                this.clearTextAndTarget();
            } else {
                JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
            }
        }
    }

    private void clearTextAndTarget() {
        this.tweetArea.setText("");
        this.selectedTweet = null;
        this.reservedTweet = null;
        NTRClient.getInstance().updateRateLimit();
        this.updateNumberOfCurrentTweet();
    }

    public void deleteSelectedTweet() {
        if (NTRClient.getInstance().getMainFrame().isShowDirectMessage()) {
            if (this.selectedDirectMessage != null) {
                System.out.println("Delete: " + this.selectedDirectMessage);
                int status = NTRClient.getInstance().destroyDirectMessage(this.selectedDirectMessage);
                if (200 != status) {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        } else if (this.selectedTweet != null) {
            System.out.println("Delete: " + this.selectedTweet);
            int status = NTRClient.getInstance().deleteTweet(this.selectedTweet);
            if (200 != status) {
                JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
            }
        }
    }

    public void replayToSelectedTweet() {
        if (this.selectedTweet != null) {
            this.tweetArea.setText("@" + this.selectedTweet.getUser().getScreenName() + " ");
            this.tweetArea.setCaretPosition(this.tweetArea.getText().length());
            this.reservedTweet = this.selectedTweet;
            this.tweetArea.requestFocus();
        }
    }

    public void rewteetSelectedTweet() {
        if (this.selectedTweet != null) {
            int status = NTRClient.getInstance().retweet(this.selectedTweet);
            if (200 == status) {
                this.clearTextAndTarget();
            } else {
                JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
            }
            System.out.println("ReTweet: " + this.selectedTweet);
        }
    }

    public void quoteTweetToSelectedTweet() {
        if (this.selectedTweet != null) {
            this.tweetArea.setText(" QT @" + this.selectedTweet.getUser().getScreenName() + ": " + this.selectedTweet.getText());
            this.tweetArea.setCaretPosition(0);
            this.reservedTweet = this.selectedTweet;
            this.tweetArea.requestFocus();
            System.out.println("Quote Tweet: " + this.selectedTweet);
        }
    }

    public void sendDirectMessegeToSelectedUser() {
        if (this.selectedTweet != null) {
            this.tweetArea.setText("D " + this.selectedTweet.getUser().getScreenName() + " ");
            this.tweetArea.setCaretPosition(this.tweetArea.getText().length() - 1);
            this.reservedTweet = this.selectedTweet;
            System.out.println("Direct message to: " + this.selectedTweet.getUser().getScreenName());
        }
    }

    public void manageFavoriteFlag() {
        if (this.selectedTweet != null) {
            if (this.selectedTweet.isFavorited()) {
                System.out.println("Un-favorited: " + this.selectedTweet.getId());
                int status = NTRClient.getInstance().destroyFavorite(this.selectedTweet);
                if (status == 200) {
                    this.selectedTweet.setFavorited(false);
                    NTRClient.getInstance().getMainFrame().updateFavoriteView(NTRClient.getInstance().getTwitterController().getFavorite());
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            } else {
                System.out.println("Favorited: " + this.selectedTweet.getId());
                int status = NTRClient.getInstance().createFavorite(this.selectedTweet);
                if (status == 200) {
                    this.selectedTweet.setFavorited(true);
                } else {
                    JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), String.valueOf(status) + " error occurred.", "Error occurred", 0);
                }
            }
        }
    }

    public void shortenURLinTweet() {
        String text = this.tweetArea.getText();
        Pattern pattern = Pattern.compile("http://[[a-zA-Z0-9\\p{Punct}]*/{1}]*");
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> urls = new ArrayList<String>();
        while (matcher.find()) {
            urls.add(matcher.group());
        }
        this.urlShorter.shortenURLs(urls);
        for (String u : urls) {
            String s = this.urlShorter.getShortenURL(u);
            text = text.replace(u, s);
        }
        this.tweetArea.setText(text);
        this.tweetArea.setCaretPosition(text.length());
        this.tweetArea.requestFocus();
    }

    public void expandURLinTweet() {
        if (this.selectedTweet != null) {
            ArrayList urls = (ArrayList)this.selectedTweet.getTweetedURLs();
            this.urlShorter.expandShortenURLs(urls);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String s : urls) {
                String u = this.urlShorter.getExpandURL(s);
                if (u.isEmpty()) continue;
                map.put(s, u);
            }
            this.selectedTweet.replaceShortenURLs(map);
            NTRClient.getInstance().getMainFrame().updateTimelineView(NTRClient.getInstance().getTwitterController().getTimeline());
        }
    }

    public void showReplyChain() {
        if (this.selectedTweet != null) {
            System.out.println("Show reply chain from: " + this.selectedTweet);
            ReplyChainFrame rcFrame = new ReplyChainFrame(this.selectedTweet);
            rcFrame.pack();
            rcFrame.setVisible(true);
            NTRClient.getInstance().updateRateLimit();
        }
    }

    public TwitterUserInfo getSelectedUserInformation() {
        if (this.selectedTweet != null) {
            return this.selectedTweet.getUser();
        }
        return null;
    }

    public Tweet getSelectedTweet() {
        return this.selectedTweet;
    }
}

