/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import twitclient.NTRClient;
import twitclient.TimelineFilter;
import twitclient.gui.ClientMenuHandler;

public class FilterManagerWindow
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -7541836786012009675L;
    private JTextField name;
    private JTextArea includeUsers;
    private JTextArea includeWords;
    private JTextArea excludeUsers;
    private JTextArea excludeWords;
    private JCheckBox modeCheck;
    private JList filterList;
    private JPanel updatePanel;

    public FilterManagerWindow(String mode) {
        super(mode);
        if (mode.equals(ClientMenuHandler.FilterMenuItems[0])) {
            JPanel panel = new JPanel(new GridLayout(2, 2));
            this.includeUsers = new JTextArea(10, 30);
            JScrollPane scrollPane = new JScrollPane(this.includeUsers);
            scrollPane.setBorder(BorderFactory.createTitledBorder("Include Users"));
            panel.add(scrollPane);
            this.includeWords = new JTextArea(10, 30);
            scrollPane = new JScrollPane(this.includeWords);
            scrollPane.setBorder(BorderFactory.createTitledBorder("Include Words"));
            panel.add(scrollPane);
            this.excludeUsers = new JTextArea(10, 30);
            scrollPane = new JScrollPane(this.excludeUsers);
            scrollPane.setBorder(BorderFactory.createTitledBorder("Exclude Users"));
            panel.add(scrollPane);
            this.excludeWords = new JTextArea(10, 30);
            scrollPane = new JScrollPane(this.excludeWords);
            scrollPane.setBorder(BorderFactory.createTitledBorder("Exclude Words"));
            panel.add(scrollPane);
            JButton addButton = new JButton("Add");
            addButton.setActionCommand(mode);
            addButton.addActionListener(this);
            JPanel header = new JPanel(new BorderLayout());
            this.name = new JTextField();
            this.name.setBorder(BorderFactory.createTitledBorder("Filter name"));
            int index = 0;
            for (String filterName : NTRClient.getInstance().getTwitterController().getFilterNames()) {
                String term;
                if (!filterName.startsWith("my-tl") || !(term = filterName.replace("my-tl", "")).matches("[0-9]+")) continue;
                int ci = Integer.parseInt(term) + 1;
                index = Math.max(ci, index);
            }
            this.name.setText("my-tl" + index);
            header.add((Component)this.name, "First");
            this.modeCheck = new JCheckBox("Remove from timeline");
            header.add((Component)this.modeCheck, "Last");
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)header, "First");
            topPanel.add((Component)panel, "Center");
            topPanel.add((Component)addButton, "Last");
            this.add(topPanel);
        } else if (mode.equals(ClientMenuHandler.FilterMenuItems[1])) {
            JPanel panel = new JPanel(new BorderLayout());
            this.filterList = new JList();
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (String str : NTRClient.getInstance().getTwitterController().getFilterNames()) {
                model.addElement(str);
            }
            this.filterList.setModel(model);
            this.filterList.setSelectionMode(2);
            JScrollPane scrollPane = new JScrollPane(this.filterList);
            JButton removeButton = new JButton("Remove");
            removeButton.setActionCommand(mode);
            removeButton.addActionListener(this);
            panel.add((Component)scrollPane, "Center");
            panel.add((Component)removeButton, "Last");
            this.add(panel);
        } else if (mode.equals(ClientMenuHandler.FilterMenuItems[2])) {
            JComboBox<String> comboBox = new JComboBox<String>();
            this.updatePanel = new JPanel(new CardLayout());
            for (String name : NTRClient.getInstance().getTwitterController().getFilterNames()) {
                TimelineFilter filter = NTRClient.getInstance().getTwitterController().getFilter(name);
                comboBox.addItem(filter.getName());
                JPanel panel = new JPanel(new GridLayout(2, 2));
                panel.setName("condition");
                JTextArea includeUsers = new JTextArea(10, 30);
                includeUsers.setName("include-users");
                for (String str : filter.getIncludeUsers()) {
                    includeUsers.append(String.valueOf(str) + "\n");
                }
                JScrollPane scrollPane = new JScrollPane(includeUsers);
                scrollPane.setBorder(BorderFactory.createTitledBorder("Include Users"));
                panel.add(scrollPane);
                JTextArea includeWords = new JTextArea(10, 30);
                includeWords.setName("include-words");
                for (String str : filter.getIncludeWords()) {
                    includeWords.append(String.valueOf(str) + "\n");
                }
                scrollPane = new JScrollPane(includeWords);
                scrollPane.setBorder(BorderFactory.createTitledBorder("Include Words"));
                panel.add(scrollPane);
                JTextArea excludeUsers = new JTextArea(10, 30);
                excludeUsers.setName("exclude-users");
                for (String str : filter.getExcludeUsers()) {
                    excludeUsers.append(String.valueOf(str) + "\n");
                }
                scrollPane = new JScrollPane(excludeUsers);
                scrollPane.setBorder(BorderFactory.createTitledBorder("Exclude Users"));
                panel.add(scrollPane);
                JTextArea excludeWords = new JTextArea(10, 30);
                excludeWords.setName("exclude-words");
                for (String str : filter.getExcludeWords()) {
                    excludeWords.append(String.valueOf(str) + "\n");
                }
                scrollPane = new JScrollPane(excludeWords);
                scrollPane.setBorder(BorderFactory.createTitledBorder("Exclude Words"));
                panel.add(scrollPane);
                JPanel header = new JPanel(new BorderLayout());
                header.setName("header");
                JTextField filterName = new JTextField();
                filterName.setBorder(BorderFactory.createTitledBorder("Filter name"));
                filterName.setText(filter.getName());
                filterName.setName(filter.getName());
                header.add((Component)filterName, "First");
                JCheckBox modeCheck = new JCheckBox("Remove from timeline");
                modeCheck.setSelected(filter.isRemoveFromTimeline());
                header.add((Component)modeCheck, "Last");
                JPanel mainPanel = new JPanel(new BorderLayout());
                mainPanel.add((Component)header, "First");
                mainPanel.add((Component)panel, "Center");
                this.updatePanel.add((Component)mainPanel, filter.getName());
            }
            comboBox.setEditable(false);
            comboBox.addItemListener(this);
            JPanel comboBoxPane = new JPanel(new GridLayout(1, 1));
            comboBoxPane.add(comboBox);
            JButton updateButton = new JButton("Update");
            updateButton.setActionCommand(mode);
            updateButton.addActionListener(this);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)comboBoxPane, "First");
            mainPanel.add((Component)this.updatePanel, "Center");
            mainPanel.add((Component)updateButton, "Last");
            this.add(mainPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(ClientMenuHandler.FilterMenuItems[0])) {
            String filterName = this.name.getText();
            boolean remove = this.modeCheck.isSelected();
            ArrayList<String> inUsers = new ArrayList<String>();
            ArrayList<String> inWords = new ArrayList<String>();
            ArrayList<String> exUsers = new ArrayList<String>();
            ArrayList<String> exWords = new ArrayList<String>();
            String[] texts = this.includeUsers.getText().split("[\\n|\\r]");
            int i = 0;
            while (i < texts.length) {
                if (!texts[i].isEmpty()) {
                    inUsers.add(texts[i]);
                }
                ++i;
            }
            texts = this.includeWords.getText().split("[\\n|\\r]");
            i = 0;
            while (i < texts.length) {
                if (!texts[i].isEmpty()) {
                    inWords.add(texts[i]);
                }
                ++i;
            }
            texts = this.excludeUsers.getText().split("[\\n|\\r]");
            i = 0;
            while (i < texts.length) {
                if (!texts[i].isEmpty()) {
                    exUsers.add(texts[i]);
                }
                ++i;
            }
            texts = this.excludeWords.getText().split("[\\n|\\r]");
            i = 0;
            while (i < texts.length) {
                if (!texts[i].isEmpty()) {
                    exWords.add(texts[i]);
                }
                ++i;
            }
            NTRClient.getInstance().addFilter(filterName, inUsers, inWords, exUsers, exWords, remove);
        } else if (command.equals(ClientMenuHandler.FilterMenuItems[1])) {
            Object[] selObj = this.filterList.getSelectedValues();
            int i = 0;
            while (i < selObj.length) {
                if (selObj[i] instanceof String) {
                    NTRClient.getInstance().removeFilter((String)selObj[i]);
                }
                ++i;
            }
            NTRClient.getInstance().updateFilters();
        } else if (command.equals(ClientMenuHandler.FilterMenuItems[2])) {
            int size = this.updatePanel.getComponentCount();
            int i = 0;
            while (i < size) {
                String filterName = "";
                String originalFilterName = "";
                boolean remove = false;
                ArrayList<String> inUsers = new ArrayList<String>();
                ArrayList<String> inWords = new ArrayList<String>();
                ArrayList<String> exUsers = new ArrayList<String>();
                ArrayList<String> exWords = new ArrayList<String>();
                Component comp = this.updatePanel.getComponent(i);
                if (comp instanceof JPanel) {
                    JPanel mainPanel = (JPanel)comp;
                    int j = 0;
                    while (j < mainPanel.getComponentCount()) {
                        int k;
                        Component mc = mainPanel.getComponent(j);
                        if (mc.getName().equals("header")) {
                            JPanel header = (JPanel)mc;
                            k = 0;
                            while (k < header.getComponentCount()) {
                                Component hc = header.getComponent(k);
                                if (hc instanceof JTextField) {
                                    originalFilterName = hc.getName();
                                    filterName = ((JTextField)hc).getText();
                                } else if (hc instanceof JCheckBox) {
                                    remove = ((JCheckBox)hc).isSelected();
                                }
                                ++k;
                            }
                        } else if (mc.getName().equals("condition")) {
                            JPanel top = (JPanel)mc;
                            k = 0;
                            while (k < top.getComponentCount()) {
                                Component cc = top.getComponent(k);
                                if (cc instanceof JScrollPane) {
                                    JScrollPane sp = (JScrollPane)cc;
                                    int ii = 0;
                                    while (ii < sp.getComponentCount()) {
                                        if (sp.getComponent(ii) instanceof JViewport) {
                                            int l;
                                            String[] texts;
                                            JTextArea tarea = (JTextArea)((JViewport)sp.getComponent(ii)).getComponent(0);
                                            if (tarea.getName().equals("include-users")) {
                                                texts = tarea.getText().split("[\\n|\\r]");
                                                l = 0;
                                                while (l < texts.length) {
                                                    if (!texts[l].isEmpty()) {
                                                        inUsers.add(texts[l]);
                                                    }
                                                    ++l;
                                                }
                                            } else if (tarea.getName().equals("include-words")) {
                                                texts = tarea.getText().split("[\\n|\\r]");
                                                l = 0;
                                                while (l < texts.length) {
                                                    if (!texts[l].isEmpty()) {
                                                        inWords.add(texts[l]);
                                                    }
                                                    ++l;
                                                }
                                            } else if (tarea.getName().equals("exclude-users")) {
                                                texts = tarea.getText().split("[\\n|\\r]");
                                                l = 0;
                                                while (l < texts.length) {
                                                    if (!texts[l].isEmpty()) {
                                                        exUsers.add(texts[l]);
                                                    }
                                                    ++l;
                                                }
                                            } else if (tarea.getName().equals("exclude-words")) {
                                                texts = tarea.getText().split("[\\n|\\r]");
                                                l = 0;
                                                while (l < texts.length) {
                                                    if (!texts[l].isEmpty()) {
                                                        exWords.add(texts[l]);
                                                    }
                                                    ++l;
                                                }
                                            }
                                        }
                                        ++ii;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    NTRClient.getInstance().updateFilter(originalFilterName, filterName, inUsers, inWords, exUsers, exWords, remove);
                }
                ++i;
            }
        }
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CardLayout cl = (CardLayout)this.updatePanel.getLayout();
        cl.show(this.updatePanel, (String)e.getItem());
    }
}

