/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientShortcutKeyManager {
    private static ClientShortcutKeyManager manager = new ClientShortcutKeyManager();
    private String postTweet = "Ctrl+Enter";
    private String selectReply = "Ctrl+Space";
    private String retweet = "Ctrl+r";
    private String quoteTweet = "Ctrl+q";
    private String sendDirectMessage = "Ctrl+d";
    private String manageFavorite = "Ctrl+f";
    private String deleteTweet = "Ctrl+Backspace";
    private String shortenURLinTweet = "Ctrl+s";
    private String expandURLinTweet = "Ctrl+e";
    private String openTweetURL = "Ctrl+o";
    private String openTwitterHome = "Ctrl+Home";
    private final String configFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "shortcut_keys.xml";

    private ClientShortcutKeyManager() {
        System.out.println("Read GUI configuration from: " + this.configFileName);
        File configFile = new File(this.configFileName);
        if (configFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(configFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("post-tweet")) {
                        this.postTweet = this.getText(nodes);
                    } else if (nodeName.equals("select-reply-to")) {
                        this.selectReply = this.getText(nodes);
                    } else if (nodeName.equals("retweet")) {
                        this.retweet = this.getText(nodes);
                    } else if (nodeName.equals("quote-tweet")) {
                        this.quoteTweet = this.getText(nodes);
                    } else if (nodeName.equals("send-direct-message-to")) {
                        this.sendDirectMessage = this.getText(nodes);
                    } else if (nodeName.equals("favorite-or-unfavorite")) {
                        this.manageFavorite = this.getText(nodes);
                    } else if (nodeName.equals("delete-my-tweet")) {
                        this.deleteTweet = this.getText(nodes);
                    } else if (nodeName.equals("shorten-url-in-my-tweet")) {
                        this.shortenURLinTweet = this.getText(nodes);
                    } else if (nodeName.equals("expand-url-in-tweet")) {
                        this.expandURLinTweet = this.getText(nodes);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.writeConfigurationFile();
        }
    }

    public static ClientShortcutKeyManager getInstance() {
        return manager;
    }

    private String getText(Node nodes) {
        NodeList nodelist = nodes.getChildNodes();
        int j = 0;
        while (j < nodelist.getLength()) {
            Node ns = nodelist.item(j);
            if (ns.getNodeType() == 3) {
                return ns.getNodeValue();
            }
            ++j;
        }
        return "";
    }

    public void writeConfigurationFile() {
        FileOutputStream out = null;
        try {
            File configFile = new File(this.configFileName);
            File dir = configFile.getParentFile();
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Cannot create client directory");
                System.exit(1);
            }
            out = new FileOutputStream(this.configFileName);
            Document doc = null;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            DOMImplementation impl = bld.getDOMImplementation();
            doc = impl.createDocument("", "config", null);
            doc.setXmlStandalone(true);
            Element root = doc.getDocumentElement();
            Element pt = doc.createElement("post-tweet");
            pt.appendChild(doc.createTextNode(this.postTweet));
            root.appendChild(pt);
            Element srt = doc.createElement("select-reply-to");
            srt.appendChild(doc.createTextNode(this.selectReply));
            root.appendChild(srt);
            Element rt = doc.createElement("retweet");
            rt.appendChild(doc.createTextNode(this.retweet));
            root.appendChild(rt);
            Element qt = doc.createElement("quote-tweet");
            qt.appendChild(doc.createTextNode(this.quoteTweet));
            root.appendChild(qt);
            Element sdm = doc.createElement("send-direct-message-to");
            sdm.appendChild(doc.createTextNode(this.sendDirectMessage));
            root.appendChild(sdm);
            Element fav = doc.createElement("favorite-or-unfavorite");
            fav.appendChild(doc.createTextNode(this.manageFavorite));
            root.appendChild(fav);
            Element del = doc.createElement("delete-my-tweet");
            del.appendChild(doc.createTextNode(this.deleteTweet));
            root.appendChild(del);
            Element shrt = doc.createElement("shorten-url-in-my-tweet");
            shrt.appendChild(doc.createTextNode(this.shortenURLinTweet));
            root.appendChild(shrt);
            Element exp = doc.createElement("expand-url-in-tweet");
            exp.appendChild(doc.createTextNode(this.expandURLinTweet));
            root.appendChild(exp);
            DOMSource dsrc = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult sr = new StreamResult(out);
            transformer.transform(dsrc, sr);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public boolean isPostTweet(String cmd) {
        return cmd.equalsIgnoreCase(this.postTweet);
    }

    public boolean isSelectReplyTo(String cmd) {
        return cmd.equalsIgnoreCase(this.selectReply);
    }

    public boolean isRetweet(String cmd) {
        return cmd.equalsIgnoreCase(this.retweet);
    }

    public boolean isQuoteTweet(String cmd) {
        return cmd.equalsIgnoreCase(this.quoteTweet);
    }

    public boolean isSendDirectMessage(String cmd) {
        return cmd.equalsIgnoreCase(this.sendDirectMessage);
    }

    public boolean isFavorite(String cmd) {
        return cmd.equalsIgnoreCase(this.manageFavorite);
    }

    public boolean isDeleteMyTweet(String cmd) {
        return cmd.equalsIgnoreCase(this.deleteTweet);
    }

    public boolean isShortenURLInTweet(String cmd) {
        return cmd.equalsIgnoreCase(this.shortenURLinTweet);
    }

    public boolean isExpandURLInTweet(String cmd) {
        return cmd.equalsIgnoreCase(this.expandURLinTweet);
    }

    public boolean isPostTweet(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isPostTweet(cmd);
    }

    public boolean isSelectReplyTo(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isSelectReplyTo(cmd);
    }

    public boolean isRetweet(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isRetweet(cmd);
    }

    public boolean isQuoteTweet(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isQuoteTweet(cmd);
    }

    public boolean isSendDirectMessage(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isSendDirectMessage(cmd);
    }

    public boolean isFavorite(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isFavorite(cmd);
    }

    public boolean isDeleteMyTweet(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isDeleteMyTweet(cmd);
    }

    public boolean isShortenURLInTweet(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isShortenURLInTweet(cmd);
    }

    public boolean isExpandURLInTweet(KeyEvent e) {
        String cmd = this.getCommandText(e);
        return this.isExpandURLInTweet(cmd);
    }

    public String getCommandText(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modex = e.getModifiersEx();
        String cmd = this.getCommandText(KeyEvent.getModifiersExText(modex));
        cmd = cmd.isEmpty() ? this.getCommandText(KeyEvent.getKeyText(keyCode)) : String.valueOf(cmd) + "+" + this.getCommandText(KeyEvent.getKeyText(keyCode));
        return cmd;
    }

    private String getCommandText(String cmd) {
        String newCmd = "";
        int i = 0;
        while (i < cmd.length()) {
            int code = cmd.codePointAt(i);
            if (Character.isLetterOrDigit(code) || Character.isWhitespace(code)) {
                newCmd = String.valueOf(newCmd) + cmd.charAt(i);
            } else {
                switch (code) {
                    case 8963: {
                        newCmd = String.valueOf(newCmd) + "Ctrl";
                        break;
                    }
                    case 8997: {
                        newCmd = String.valueOf(newCmd) + "Alt";
                        break;
                    }
                    case 8984: {
                        newCmd = String.valueOf(newCmd) + "Cmd";
                        break;
                    }
                    case 8679: {
                        newCmd = String.valueOf(newCmd) + "Shift";
                        break;
                    }
                    case 9099: {
                        newCmd = String.valueOf(newCmd) + "Esc";
                        break;
                    }
                    case 9003: {
                        newCmd = String.valueOf(newCmd) + "Backspace";
                        break;
                    }
                    case 8998: {
                        newCmd = String.valueOf(newCmd) + "Delete";
                        break;
                    }
                    case 9116: {
                        newCmd = String.valueOf(newCmd) + "Enter";
                        break;
                    }
                    case 9251: {
                        newCmd = String.valueOf(newCmd) + "Space";
                        break;
                    }
                    default: {
                        newCmd = String.valueOf(newCmd) + cmd.charAt(i);
                    }
                }
            }
            ++i;
        }
        return newCmd;
    }
}

