/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import twitclient.DirectMessage;
import twitclient.Tweet;
import twitclient.TwitterList;
import twitclient.gui.ClientDirectMessageViewPanel;
import twitclient.gui.ClientFilterViewPanel;
import twitclient.gui.ClientListViewPanel;
import twitclient.gui.ClientShortcutKeyManager;
import twitclient.gui.ClientTweetPostPanel;
import twitclient.gui.FavoriteViewPanel;
import twitclient.gui.MentionsViewPanel;
import twitclient.gui.PostManager;
import twitclient.gui.TimelineViewPanel;

public class ClientMainPanel
extends JPanel {
    private static final long serialVersionUID = 8923169903368038195L;
    private PostManager postManager = PostManager.getInstance();
    private ClientShortcutKeyManager shortcutManager = ClientShortcutKeyManager.getInstance();
    private TimelineViewPanel tlView = new TimelineViewPanel();
    private MentionsViewPanel mView = new MentionsViewPanel();
    private ClientDirectMessageViewPanel dmView = new ClientDirectMessageViewPanel();
    private FavoriteViewPanel fView = new FavoriteViewPanel();
    private ClientFilterViewPanel filView = new ClientFilterViewPanel();
    private ClientListViewPanel listView = new ClientListViewPanel();
    private JPanel mainPane = new JPanel();
    private JTabbedPane mainTab = new JTabbedPane();
    private ClientTweetPostPanel tweetPane = new ClientTweetPostPanel(this.postManager);
    private ArrayList<String> views = new ArrayList();

    public ClientMainPanel() {
        super(new BorderLayout());
        this.views.add("Timeline");
        this.views.add("Mentions");
        this.views.add("Direct Message");
        this.views.add("Favorites");
        this.views.add("Filters");
        this.views.add("Lists");
        this.mainPane = new JPanel(new BorderLayout());
        this.mainTab.addTab(this.views.get(0), this.tlView);
        this.mainTab.setMnemonicAt(0, 49);
        this.tlView.setName(this.views.get(0));
        this.mainTab.addTab(this.views.get(1), this.mView);
        this.mainTab.setMnemonicAt(1, 50);
        this.mView.setName(this.views.get(1));
        this.mainTab.addTab(this.views.get(2), this.dmView);
        this.mainTab.setMnemonicAt(2, 51);
        this.dmView.setName(this.views.get(2));
        this.mainTab.addTab(this.views.get(3), this.fView);
        this.mainTab.setMnemonicAt(3, 52);
        this.fView.setName(this.views.get(3));
        this.mainTab.addTab(this.views.get(4), this.filView);
        this.mainTab.setMnemonicAt(4, 53);
        this.fView.setName(this.views.get(4));
        this.mainTab.addTab(this.views.get(5), this.listView);
        this.mainTab.setMnemonicAt(5, 54);
        this.fView.setName(this.views.get(5));
        this.mainTab.setTabLayoutPolicy(1);
        this.mainPane.add((Component)this.mainTab, "Center");
        this.mainPane.add((Component)this.tweetPane, "Last");
        this.add(this.mainPane);
    }

    public void showTimelineView() {
        this.mainTab.setSelectedComponent(this.tlView);
    }

    public void showMentionsView() {
        this.mainTab.setSelectedComponent(this.mView);
    }

    public void showDirectMessageView() {
        this.mainTab.setSelectedComponent(this.dmView);
    }

    public void showFavoriteView() {
        this.mainTab.setSelectedComponent(this.fView);
    }

    public void showFiltersView() {
        this.mainTab.setSelectedComponent(this.filView);
    }

    public void showListsView() {
        this.mainTab.setSelectedComponent(this.listView);
    }

    public String getCurrentView() {
        return this.mainTab.getSelectedComponent().getName();
    }

    public boolean isShowDirectMessage() {
        return this.mainTab.getSelectedComponent() == this.dmView;
    }

    public void updateTimelineView(Iterable<Tweet> tweets) {
        this.tlView.update(tweets);
    }

    public void updateMentionsView(Iterable<Tweet> tweets) {
        this.mView.update(tweets);
    }

    public void updateDirectMessageView(Iterable<DirectMessage> directMessages, String type) {
        this.dmView.update(directMessages, type);
    }

    public void updateFavoriteView(Iterable<Tweet> tweets) {
        this.fView.update(tweets);
    }

    public void updateFilterList(Iterable<String> filterNames) {
        this.filView.updateFilterList(filterNames);
    }

    public void updateFilterView(Iterable<Tweet> tweets, String filterName) {
        this.filView.update(tweets, filterName);
    }

    public void updateListOfLists(ArrayList<String> ownedList, ArrayList<String> subscribedList) {
        this.listView.updateListOfLists(ownedList, subscribedList);
    }

    public void updateListView(Iterable<TwitterList> lists) {
        this.listView.update(lists);
    }

    public String getFocusedTab() {
        return this.views.get(this.mainTab.getSelectedIndex());
    }
}

