/*
 * Decompiled with CFR 0.152.
 */
package twitclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import twitclient.DirectMessage;
import twitclient.NTRClient;
import twitclient.Tweet;
import twitclient.TwitterList;
import twitclient.gui.ClientMainPanel;
import twitclient.gui.ClientMenuHandler;
import twitclient.gui.ClientStatusPanel;
import twitclient.gui.ClientToolBarHandler;

public class ClientMainFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = -4490747419918113441L;
    private JMenuBar menubar = new JMenuBar();
    private JToolBar toolBar = new JToolBar();
    private ClientMainPanel mainPane = new ClientMainPanel();
    private ClientStatusPanel statusPanel = new ClientStatusPanel();

    public ClientMainFrame(String title) {
        super(title);
        this.createMenu();
        this.createViews();
    }

    private void createMenu() {
        JMenuItem item;
        String itemStr;
        JMenu files = new JMenu(ClientMenuHandler.FileMenu);
        JMenu updates = new JMenu(ClientMenuHandler.UpdateMenu);
        JMenu tweets = new JMenu(ClientMenuHandler.TweetMenu);
        JMenu filters = new JMenu(ClientMenuHandler.FilterMenu);
        JMenu lists = new JMenu(ClientMenuHandler.ListMenu);
        JMenu windows = new JMenu(ClientMenuHandler.WindowMenu);
        String[] fileMenu = ClientMenuHandler.FileMenuItems;
        String[] updateMenu = ClientMenuHandler.UpdateMenuItems;
        String[] tweetMenu = ClientMenuHandler.TweetMenuItems;
        String[] filterMenu = ClientMenuHandler.FilterMenuItems;
        String[] listMenu = ClientMenuHandler.ListMenuItems;
        String[] windowMenu = ClientMenuHandler.WindowMenuItems;
        ClientMenuHandler menuHandler = new ClientMenuHandler();
        int i = 0;
        while (i < fileMenu.length) {
            itemStr = fileMenu[i];
            if (itemStr.equals("----")) {
                files.addSeparator();
            } else {
                item = new JMenuItem(itemStr);
                item.setName(String.valueOf(itemStr) + " " + files.getText());
                item.addActionListener(menuHandler);
                files.add(item);
            }
            ++i;
        }
        files.setName(ClientMenuHandler.FileMenu);
        i = 0;
        while (i < updateMenu.length) {
            itemStr = updateMenu[i];
            if (itemStr.equals("----")) {
                updates.addSeparator();
            } else {
                item = new JMenuItem(itemStr);
                item.setName(String.valueOf(itemStr) + " " + updates.getText());
                item.addActionListener(menuHandler);
                updates.add(item);
            }
            ++i;
        }
        updates.setName(ClientMenuHandler.UpdateMenu);
        i = 0;
        while (i < tweetMenu.length) {
            itemStr = tweetMenu[i];
            if (itemStr.equals("----")) {
                tweets.addSeparator();
            } else {
                item = new JMenuItem(itemStr);
                item.setName(String.valueOf(itemStr) + " " + tweets.getText());
                item.addActionListener(menuHandler);
                tweets.add(item);
            }
            ++i;
        }
        tweets.setName(ClientMenuHandler.TweetMenu);
        i = 0;
        while (i < filterMenu.length) {
            itemStr = filterMenu[i];
            if (itemStr.equals("----")) {
                filters.addSeparator();
            } else {
                item = new JMenuItem(itemStr);
                item.setName(String.valueOf(itemStr) + " " + filters.getText());
                item.addActionListener(menuHandler);
                filters.add(item);
            }
            ++i;
        }
        filters.setName(ClientMenuHandler.FilterMenu);
        i = 0;
        while (i < listMenu.length) {
            itemStr = listMenu[i];
            if (itemStr.equals("----")) {
                lists.addSeparator();
            } else {
                item = new JMenuItem(itemStr);
                item.setName(String.valueOf(itemStr) + " " + lists.getText());
                item.addActionListener(menuHandler);
                lists.add(item);
            }
            ++i;
        }
        lists.setName(ClientMenuHandler.ListMenu);
        i = 0;
        while (i < windowMenu.length) {
            itemStr = windowMenu[i];
            if (itemStr.equals("----")) {
                windows.addSeparator();
            } else {
                item = new JMenuItem(itemStr);
                item.setName(String.valueOf(itemStr) + " " + windows.getText());
                item.addActionListener(menuHandler);
                windows.add(item);
            }
            ++i;
        }
        windows.setName(ClientMenuHandler.WindowMenu);
        this.menubar.add(files);
        this.menubar.add(updates);
        this.menubar.add(tweets);
        this.menubar.add(filters);
        this.menubar.add(lists);
        this.menubar.add(windows);
        this.setJMenuBar(this.menubar);
    }

    private void createToolBar() {
        JButton button = null;
        ImageIcon icon = null;
        ClientToolBarHandler handler = new ClientToolBarHandler();
        button = new JButton();
        icon = this.createImageIcon("images/document-new.png");
        if (icon != null) {
            button.setIcon(icon);
        } else {
            button.setText("update timeline");
        }
        button.setToolTipText("update timeline");
        button.setActionCommand("update timeline");
        button.addActionListener(handler);
        this.toolBar.add(button);
        button = new JButton();
        icon = this.createImageIcon("images/document-new.png");
        if (icon != null) {
            button.setIcon(icon);
        } else {
            button.setText("update mentions");
        }
        button.setToolTipText("update mentions");
        button.setActionCommand("update mentions");
        button.addActionListener(handler);
        this.toolBar.add(button);
        button = new JButton();
        icon = this.createImageIcon("images/document-new.png");
        if (icon != null) {
            button.setIcon(icon);
        } else {
            button.setText("update direct message");
        }
        button.setToolTipText("update direct message");
        button.setActionCommand("update direct message");
        button.addActionListener(handler);
        this.toolBar.add(button);
        button = new JButton();
        icon = this.createImageIcon("images/document-new.png");
        if (icon != null) {
            button.setIcon(icon);
        } else {
            button.setText("update favorite");
        }
        button.setToolTipText("update favorite");
        button.setActionCommand("update favorite");
        button.addActionListener(handler);
        this.toolBar.add(button);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
    }

    private void createViews() {
        this.setLayout(new BorderLayout());
        this.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "First");
        this.getContentPane().add((Component)this.mainPane, "Center");
        this.getContentPane().add((Component)this.statusPanel, "Last");
    }

    public void showTimelineView() {
        this.mainPane.showTimelineView();
    }

    public void showMentionsView() {
        this.mainPane.showMentionsView();
    }

    public void showDirectMessageView() {
        this.mainPane.showDirectMessageView();
    }

    public void showFavoriteView() {
        this.mainPane.showFavoriteView();
    }

    public void showFiltersView() {
        this.mainPane.showFiltersView();
    }

    public void showListsView() {
        this.mainPane.showListsView();
    }

    public void updateTimelineView(Iterable<Tweet> tweets) {
        this.mainPane.updateTimelineView(tweets);
    }

    public void updateMentionsView(Iterable<Tweet> tweets) {
        this.mainPane.updateMentionsView(tweets);
    }

    public void updateDirectMessageView(Iterable<DirectMessage> directMessages, String type) {
        this.mainPane.updateDirectMessageView(directMessages, type);
    }

    public void updateStatus(int remain, int limit, String resetTime, int currentSpeedPerHour) {
        this.statusPanel.updateStatus(remain, limit, resetTime, currentSpeedPerHour);
    }

    public void updateFavoriteView(Iterable<Tweet> tweets) {
        this.mainPane.updateFavoriteView(tweets);
    }

    public void updateFilterList(Iterable<String> filterNames) {
        this.mainPane.updateFilterList(filterNames);
    }

    public void updateFilterView(Iterable<Tweet> tweets, String filterName) {
        this.mainPane.updateFilterView(tweets, filterName);
    }

    public void updateListOfLists(ArrayList<String> ownedList, ArrayList<String> subscribedList) {
        this.mainPane.updateListOfLists(ownedList, subscribedList);
    }

    public void updateListView(Iterable<TwitterList> lists) {
        this.mainPane.updateListView(lists);
    }

    public String getCurrentView() {
        return this.mainPane.getCurrentView();
    }

    public boolean isShowDirectMessage() {
        return this.mainPane.isShowDirectMessage();
    }

    public String getPINCode(String url) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(url));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String str = JOptionPane.showInputDialog(this, (Object)("<html>Access <a href=\"" + url + "\">" + url + "</a><br>Input PIN Code to below text field."));
        return str.trim();
    }

    public void alertBecauseOfNoAPI(String date) {
        JOptionPane.showMessageDialog(NTRClient.getInstance().getMainFrame(), "<html>You have no remain API to access Twitter service<br>Your API will reset around " + date + "</html>", "No remain API", 0);
    }

    private ImageIcon createImageIcon(String path) {
        URL imgURL = NTRClient.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Could not find file: " + path);
        return null;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        NTRClient.getInstance().writeConfigurationFiles();
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

