/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import twitclient.TwitterClientController;
import twitclient.gui.ClientMainFrame;

public class UpdateController
implements Runnable {
    private final TwitterClientController twitterController;
    private final ClientMainFrame mainFrame;

    public UpdateController(TwitterClientController twitterController, ClientMainFrame mainFrame) {
        this.twitterController = twitterController;
        this.mainFrame = mainFrame;
    }

    @Override
    public void run() {
        int localTime = 0;
        while (true) {
            boolean isUpdateList;
            boolean isUpdateTimeline = localTime % this.twitterController.getUserTimelineUpdateInterval() == 0;
            boolean isUpdateMentions = localTime % this.twitterController.getMentionsUpdateInterval() == 0;
            boolean isUpdateDirectMessage = localTime % this.twitterController.getDirectMessageUpdateInterval() == 0;
            boolean isUpdateFavorite = localTime % this.twitterController.getFavoriteUpdateInterval() == 0;
            boolean bl = isUpdateList = localTime % this.twitterController.getListUpdateInterval() == 0;
            if (this.twitterController.hasAPIRemain()) {
                this.update(localTime, isUpdateTimeline, isUpdateMentions, isUpdateDirectMessage, isUpdateFavorite, isUpdateList);
            } else if (isUpdateTimeline || isUpdateMentions || isUpdateDirectMessage || isUpdateFavorite || isUpdateList) {
                int status = this.twitterController.updateRateLimit();
                if (this.twitterController.hasAPIRemain()) {
                    this.update(localTime, isUpdateTimeline, isUpdateMentions, isUpdateDirectMessage, isUpdateFavorite, isUpdateList);
                } else {
                    this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
                    this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++localTime;
        }
    }

    private void update(int localTime, boolean isUpdateTimeline, boolean isUpdateMentions, boolean isUpdateDirectMessage, boolean isUpdateFavorite, boolean isUpdateList) {
        int status;
        if (isUpdateTimeline) {
            System.out.println("Update home timeline");
            status = this.twitterController.updateHomeTimeline();
            this.mainFrame.updateTimelineView(this.twitterController.getTimeline());
            for (String filterName : this.twitterController.getFilterNames()) {
                this.mainFrame.updateFilterView(this.twitterController.getTimelineInFilterFor(filterName), filterName);
            }
        }
        if (isUpdateMentions) {
            System.out.println("Update mentions");
            status = this.twitterController.updateMentions();
            this.mainFrame.updateMentionsView(this.twitterController.getMentions());
        }
        if (isUpdateDirectMessage) {
            System.out.println("Update direct message [inbox]");
            status = this.twitterController.updateDirectMessageInBox();
            this.mainFrame.updateDirectMessageView(this.twitterController.getReceivedDirectMessages(), "inbox");
            if (localTime == 0) {
                System.out.println("Update direct message [sent]");
                status = this.twitterController.updateDirectMessageSent();
                this.mainFrame.updateDirectMessageView(this.twitterController.getSentDirectMessages(), "sent");
            }
        }
        if (isUpdateFavorite) {
            System.out.println("Update favorite");
            status = this.twitterController.updateFavorite();
            this.mainFrame.updateFavoriteView(this.twitterController.getFavorite());
        }
        if (isUpdateList) {
            System.out.println("Update lists");
            status = this.twitterController.updateOwnedLists();
            status = this.twitterController.updateSubscribedLists();
            this.mainFrame.updateListView(this.twitterController.getAllLists());
        }
        if (isUpdateTimeline || isUpdateMentions || isUpdateDirectMessage || isUpdateFavorite) {
            System.out.println("Update status");
            status = this.twitterController.updateRateLimit();
            this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
            this.mainFrame.repaint();
        }
    }
}

