/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.RateLimitReader;
import twitclient.TimelineManager;
import twitclient.Tweet;
import twitclient.TwitterUserInfo;

public class TwitterList {
    private long id = 0L;
    private String name = "";
    private String fullName = "";
    private String slug;
    private String description = "";
    private int subscriberCount = 0;
    private int memberCount = 0;
    private String uri = "";
    private String mode = "";
    private TwitterUserInfo user;
    private final String[] tags = new String[]{"id", "name", "full_name", "slug", "description", "subscriber_count", "member_count", "uri", "mode", "user"};
    private boolean ownership = false;
    private boolean subscribed = false;
    private boolean membered = false;
    private TimelineManager timelineManager;
    private ArrayList<TwitterUserInfo> members;
    private boolean loaded;

    public TwitterList() {
        this.user = new TwitterUserInfo();
        this.timelineManager = new TimelineManager();
        this.members = new ArrayList();
    }

    public boolean load(InputStream in) {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            if (!this.load(childNodes)) {
                return false;
            }
        }
        catch (Exception e) {
            System.err.println("During reading list, we meets error.");
            System.exit(1);
        }
        return true;
    }

    public boolean load(NodeList nodelist) {
        int loadCount = 0;
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                Node node;
                int j;
                NodeList childNode;
                Node nodes = nodelist.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals(this.tags[0])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.id = Long.parseLong(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[1])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.name = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[2])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.fullName = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[3])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.slug = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[4])) {
                    childNode = nodes.getChildNodes();
                    if (childNode.getLength() == 0) {
                        ++loadCount;
                    } else {
                        j = 0;
                        while (j < childNode.getLength()) {
                            node = childNode.item(j);
                            if (node.getNodeType() == 3) {
                                this.description = node.getNodeValue();
                                ++loadCount;
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (nodeName.equals(this.tags[5])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.subscriberCount = Integer.parseInt(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[6])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.memberCount = Integer.parseInt(node.getNodeValue());
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[7])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.uri = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[8])) {
                    childNode = nodes.getChildNodes();
                    j = 0;
                    while (j < childNode.getLength()) {
                        node = childNode.item(j);
                        if (node.getNodeType() == 3) {
                            this.mode = node.getNodeValue();
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                } else if (nodeName.equals(this.tags[9])) {
                    NodeList childNodes = nodes.getChildNodes();
                    j = 0;
                    while (j < childNodes.getLength()) {
                        if (this.user.load(childNodes)) {
                            ++loadCount;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("During reading Twitter account information, we meets error.");
            System.exit(1);
        }
        if (loadCount == this.tags.length) {
            this.loaded = true;
        }
        return this.loaded;
    }

    public int updateOwnedLists(RateLimitReader rateLimitReader, int perPage, OAuthConsumer consumer) {
        if (this.mode.equals("public")) {
            return this.update(rateLimitReader, perPage);
        }
        try {
            String urlStr = "http://api.twitter.com/1/:user/lists/:id/statuses.xml";
            urlStr = urlStr.replace(":user", this.user.getScreenName());
            urlStr = urlStr.replace(":id", this.slug);
            ArrayList<String> args = new ArrayList<String>();
            args.add("per_page=" + perPage);
            if (this.timelineManager.getNumberOfTweets() != 0) {
                args.add("since_id=" + this.timelineManager.getLatestID());
            }
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.timelineManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.timelineManager.getNumberOfTweets()) {
                        Tweet tweet = this.timelineManager.getTweet(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During list timeline update, some errors are occurred.");
                }
                rateLimitReader.load(connection.getHeaderFields());
            } else {
                String str;
                for (String key : connection.getHeaderFields().keySet()) {
                    System.out.println(String.valueOf(key) + ": " + connection.getHeaderField(key));
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((str = reader.readLine()) != null) {
                    System.out.println(str);
                }
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int update(RateLimitReader rateLimitReader, int perPage) {
        try {
            String urlStr = "http://api.twitter.com/1/:user/lists/:id/statuses.xml";
            urlStr = urlStr.replace(":user", this.user.getScreenName());
            urlStr = urlStr.replace(":id", this.slug);
            ArrayList<String> args = new ArrayList<String>();
            args.add("per_page=" + perPage);
            if (this.timelineManager.getNumberOfTweets() != 0) {
                args.add("since_id=" + this.timelineManager.getLatestID());
            }
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.timelineManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.timelineManager.getNumberOfTweets()) {
                        Tweet tweet = this.timelineManager.getTweet(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During list timeline update, some errors are occurred.");
                }
                rateLimitReader.load(connection.getHeaderFields());
            } else {
                String str;
                for (String key : connection.getHeaderFields().keySet()) {
                    System.out.println(String.valueOf(key) + ": " + connection.getHeaderField(key));
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((str = reader.readLine()) != null) {
                    System.out.println(str);
                }
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getMembersInOwnedList(RateLimitReader rateLimitReader, OAuthConsumer consumer) {
        if (!this.members.isEmpty()) {
            return 200;
        }
        long cursor = -1L;
        while (cursor != 0L) {
            try {
                String urlStr = "http://api.twitter.com/1/:user/:list_id/members.xml";
                urlStr = urlStr.replace(":user", this.user.getScreenName());
                urlStr = urlStr.replace(":list_id", this.slug);
                urlStr = String.valueOf(urlStr) + "?cursor=" + cursor;
                URL url = new URL(urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                try {
                    consumer.sign((Object)connection);
                }
                catch (OAuthMessageSignerException e) {
                    e.printStackTrace();
                }
                catch (OAuthExpectationFailedException e) {
                    e.printStackTrace();
                }
                catch (OAuthCommunicationException e) {
                    e.printStackTrace();
                }
                int status = connection.getResponseCode();
                if (status == 200) {
                    System.out.println("Status: " + status);
                    connection.connect();
                    InputStream in = connection.getInputStream();
                    try {
                        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(in);
                        Element root = doc.getDocumentElement();
                        NodeList childNodes = root.getChildNodes();
                        int i = 0;
                        while (i < childNodes.getLength()) {
                            Node nodes = childNodes.item(i);
                            String nodeName = nodes.getNodeName();
                            if (nodeName.equals("users")) {
                                NodeList nodelist = nodes.getChildNodes();
                                int j = 0;
                                while (j < nodelist.getLength()) {
                                    TwitterUserInfo member;
                                    Node n = nodelist.item(j);
                                    if (n.getNodeName().equals("user") && (member = new TwitterUserInfo()).load(n.getChildNodes())) {
                                        this.members.add(member);
                                    }
                                    ++j;
                                }
                            } else if (nodeName.equals("next_cursor")) {
                                cursor = Long.parseLong(nodes.getTextContent());
                            } else {
                                nodeName.equals("previous_cursor");
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("During reading list of members, we meets error.");
                        System.exit(1);
                    }
                    rateLimitReader.load(connection.getHeaderFields());
                } else {
                    String str;
                    for (String key : connection.getHeaderFields().keySet()) {
                        System.out.println(String.valueOf(key) + ": " + connection.getHeaderField(key));
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((str = reader.readLine()) != null) {
                        System.out.println(str);
                    }
                    switch (status) {
                        case 400: 
                        case 401: 
                        case 403: 
                        case 404: 
                        case 500: 
                        case 502: 
                        case 503: {
                            System.err.println("Twitter service is unavailable.");
                            rateLimitReader.load(connection.getHeaderFields());
                        }
                    }
                    System.err.println("Unknown error code is returned: " + status);
                    rateLimitReader.load(connection.getHeaderFields());
                }
                return status;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void setOwnership(boolean ownership) {
        this.ownership = ownership;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public void setMembered(boolean membered) {
        this.membered = membered;
    }

    public boolean hasOwnership() {
        return this.ownership;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public boolean isMembered() {
        return this.membered;
    }

    public Iterable<Tweet> getTweets() {
        return this.timelineManager.getTweets();
    }

    public void update(String slug, boolean isPrivate, String description) {
        this.name = this.name.replace(this.slug, slug);
        this.fullName = this.fullName.replace(this.slug, slug);
        this.description = description;
        this.mode = isPrivate ? "private" : "public";
        this.slug = slug;
    }

    public long getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public String getURI() {
        return this.uri;
    }

    public String getMode() {
        return this.mode;
    }

    public TwitterUserInfo getUser() {
        return this.user;
    }

    public ArrayList<TwitterUserInfo> getMembers() {
        return this.members;
    }

    public void removeMember(long id) {
        TwitterUserInfo remUser = null;
        for (TwitterUserInfo user : this.members) {
            if (user.getId() != id) continue;
            remUser = user;
            break;
        }
        if (remUser != null) {
            this.members.remove(remUser);
        }
    }

    public void clearMembers() {
        this.members.clear();
    }

    public String toString() {
        return this.slug;
    }
}

