/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import twitclient.AuthenticationManager;
import twitclient.DirectMessage;
import twitclient.DirectMessageManager;
import twitclient.FilterManager;
import twitclient.FriendshipManager;
import twitclient.ListManager;
import twitclient.RateLimitReader;
import twitclient.TimelineFilter;
import twitclient.TimelineManager;
import twitclient.Tweet;
import twitclient.TwitterClientConfiguration;
import twitclient.TwitterList;
import twitclient.TwitterUserInfo;
import twitclient.UpdateController;
import twitclient.gui.ClientMainFrame;

public class TwitterClientController {
    private OAuthConsumer consumer = new DefaultOAuthConsumer("ITPVxxaBe8rxKLU6cgfJg", "3iyAaOi3NgkDAV4tWQzFVoNx1UrFkUjOgkjr7FjIfc4");
    private UpdateController updateController;
    private TwitterUserInfo userInfo;
    private RateLimitReader rateLimitReader;
    private TimelineManager timelineManager;
    private TimelineManager mentionsManager;
    private DirectMessageManager directMessageInBoxManager;
    private DirectMessageManager directMessageSentManager;
    private TimelineManager favoriteManager;
    private FriendshipManager friendshipManager;
    private ListManager listManager = new ListManager();
    private FilterManager filterManager = new FilterManager();
    private TwitterClientConfiguration conf;

    public void connectToTwitter(ClientMainFrame frame) {
        AuthenticationManager authManager = new AuthenticationManager(frame);
        String token = authManager.getToken();
        String tokenSecret = authManager.getTokenSecret();
        this.consumer.setTokenWithSecret(token, tokenSecret);
        this.conf = new TwitterClientConfiguration();
        this.userInfo = new TwitterUserInfo();
        this.updateUserInfo();
        this.friendshipManager = new FriendshipManager();
        if (!this.friendshipManager.readFriendshipFromFile()) {
            System.out.println("Update friendship with API");
            this.updateFrendships();
        }
        this.rateLimitReader = new RateLimitReader();
        this.timelineManager = new TimelineManager();
        this.mentionsManager = new TimelineManager();
        this.directMessageInBoxManager = new DirectMessageManager();
        this.directMessageSentManager = new DirectMessageManager();
        this.favoriteManager = new TimelineManager();
        this.listManager = new ListManager();
        this.updateListOfOnwerLists();
        this.updateListOfSubscribedLists();
        this.updateListOfMemberedLists();
        this.filterManager.loadFilters();
    }

    public void start(ClientMainFrame frame) {
        this.updateController = new UpdateController(this, frame);
        Thread t = new Thread(this.updateController);
        t.start();
    }

    public void writeConfigurationFile() {
        this.conf.writeConfigurationFile();
        this.friendshipManager.writeFriendshipToFile();
        this.filterManager.writeFilters();
    }

    public int postTweet(String tweetMessage) {
        if (tweetMessage.isEmpty()) {
            return 200;
        }
        try {
            String str = URLEncoder.encode(tweetMessage, "UTF-8");
            URL url = new URL("http://api.twitter.com/1/statuses/update.xml?status=" + str);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully post your tweet.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int postTweet(String tweetMessage, long statusID) {
        if (tweetMessage.isEmpty()) {
            return 200;
        }
        try {
            String str = URLEncoder.encode(tweetMessage, "UTF-8");
            URL url = new URL("http://api.twitter.com/1/statuses/update.xml?status=" + str + "&" + "in_reply_to_status_id=" + statusID);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully post your reply.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int deleteTweet(long id) {
        for (Tweet t : this.timelineManager.getTweets()) {
            if (t.getId() != id || t.getUser().getId() == this.userInfo.getId()) continue;
            return 200;
        }
        try {
            URL url = new URL("http://api.twitter.com/1/statuses/destroy.xml?id=" + id);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully delete your tweet.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int sendDirectMessage(String text, long id) {
        if (text.isEmpty()) {
            return 200;
        }
        try {
            String str = URLEncoder.encode(text, "UTF-8");
            URL url = new URL("http://api.twitter.com/1/direct_messages/new.xml?text=" + str + "&" + "user_id=" + id);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            return this.sendDirectMessage(connection);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int sendDirectMessage(String text, String screenName) {
        if (text.isEmpty()) {
            return 200;
        }
        try {
            String str = URLEncoder.encode(text, "UTF-8");
            URL url = new URL("http://api.twitter.com/1/direct_messages/new.xml?text=" + str + "&" + "screen_name=" + screenName);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            return this.sendDirectMessage(connection);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int sendDirectMessage(HttpURLConnection connection) throws IOException {
        try {
            this.consumer.sign((Object)connection);
        }
        catch (OAuthMessageSignerException e) {
            e.printStackTrace();
        }
        catch (OAuthExpectationFailedException e) {
            e.printStackTrace();
        }
        catch (OAuthCommunicationException e) {
            e.printStackTrace();
        }
        int status = connection.getResponseCode();
        this.rateLimitReader.load(connection.getHeaderFields());
        if (status == 200) {
            System.out.println("Status: " + status);
            System.out.println("Successfully send direct message.");
            InputStream in = connection.getInputStream();
            this.directMessageSentManager.add(in);
        } else {
            switch (status) {
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 500: 
                case 502: 
                case 503: {
                    System.err.println("Twitter service is unavailable.");
                }
            }
            System.err.println("Unknown error code is returned: " + status);
        }
        return status;
    }

    public int deleteDirectMessage(long id) {
        boolean notYourDM = true;
        for (DirectMessage dm : this.directMessageSentManager.getDirectMessages()) {
            if (dm.getID() != id) continue;
            notYourDM = false;
            break;
        }
        if (notYourDM) {
            return 200;
        }
        try {
            URL url = new URL("http://api.twitter.com/1/direct_messages/destroy.xml?id=" + id);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully delete your direct message.");
                this.directMessageSentManager.remove(id);
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int retweet(long statusID) {
        try {
            String urlStr = "http://api.twitter.com/1/statuses/retweet/:id.xml";
            urlStr = urlStr.replace(":id", Long.toString(statusID));
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully retweet.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int createFavorite(long statusID) {
        try {
            URL url = new URL("http://api.twitter.com/1/favorites/create/" + statusID + ".xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully create favorite flag.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int destroyFavorite(long statusID) {
        try {
            URL url = new URL("http://api.twitter.com/1/favorites/destroy/" + statusID + ".xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully destroy favorite flag.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateListOfOnwerLists() {
        if (!this.userInfo.getScreenName().isEmpty()) {
            String userName = this.userInfo.getScreenName();
            String baseURLStr = "http://api.twitter.com/1/:user/lists.xml".replace(":user", userName);
            return this.updateListOfLists(baseURLStr, true, false, false);
        }
        return 200;
    }

    public int updateListOfMemberedLists() {
        if (!this.userInfo.getScreenName().isEmpty()) {
            String userName = this.userInfo.getScreenName();
            String baseURLStr = "http://api.twitter.com/1/:user/lists/memberships.xml".replace(":user", userName);
            return this.updateListOfLists(baseURLStr, false, false, true);
        }
        return 200;
    }

    public int updateListOfSubscribedLists() {
        if (!this.userInfo.getScreenName().isEmpty()) {
            String userName = this.userInfo.getScreenName();
            String baseURLStr = "http://api.twitter.com/1/:user/lists/subscriptions.xml".replace(":user", userName);
            return this.updateListOfLists(baseURLStr, false, true, false);
        }
        return 200;
    }

    public int updateListOfLists(String baseURLStr, boolean ownership, boolean subscribed, boolean membered) {
        long cursor = -1L;
        while (cursor != 0L) {
            try {
                String urlStr = String.valueOf(baseURLStr) + "?" + "cursor=" + cursor;
                URL url = new URL(urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                try {
                    this.consumer.sign((Object)connection);
                }
                catch (OAuthMessageSignerException e) {
                    e.printStackTrace();
                }
                catch (OAuthExpectationFailedException e) {
                    e.printStackTrace();
                }
                catch (OAuthCommunicationException e) {
                    e.printStackTrace();
                }
                int status = connection.getResponseCode();
                if (status == 200) {
                    System.out.println("Status: " + status);
                    connection.connect();
                    InputStream in = connection.getInputStream();
                    cursor = this.listManager.load(in, ownership, subscribed, membered);
                    continue;
                }
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
                return status;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 200;
    }

    public int createList(String slug, boolean isPrivate, String description) {
        if (this.userInfo.getScreenName().isEmpty()) {
            return 200;
        }
        try {
            String urlStr = "http://api.twitter.com/1/:user/lists.xml";
            urlStr = urlStr.replace(":user", this.userInfo.getScreenName());
            urlStr = String.valueOf(urlStr) + "?" + "name=" + URLEncoder.encode(slug, "UTF-8");
            if (isPrivate) {
                urlStr = String.valueOf(urlStr) + "&" + "mode=private";
            }
            urlStr = String.valueOf(urlStr) + "&" + "description=" + URLEncoder.encode(description, "UTF-8");
            URL url = new URL(urlStr);
            System.out.println("access: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                InputStream in = connection.getInputStream();
                TwitterList list = new TwitterList();
                list.load(in);
                list.setOwnership(true);
                System.out.println(list.getFullName());
                this.listManager.add(list);
                System.out.println("Status: " + status);
                System.out.println("Successfully create your list.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateOwnedList(String originalSlug, String slug, boolean isPrivate, String description) {
        try {
            String urlStr = "http://api.twitter.com/1/:user/lists/:id.xml";
            urlStr = urlStr.replace(":user", this.userInfo.getScreenName());
            urlStr = urlStr.replace(":id", originalSlug);
            if (originalSlug.equals(slug)) {
                urlStr = String.valueOf(urlStr) + "?" + "description=" + URLEncoder.encode(description, "UTF-8");
                if (isPrivate) {
                    urlStr = String.valueOf(urlStr) + "&" + "mode=private";
                }
            } else {
                urlStr = String.valueOf(urlStr) + "?" + "name=" + URLEncoder.encode(slug, "UTF-8");
                if (isPrivate) {
                    urlStr = String.valueOf(urlStr) + "&" + "mode=private";
                }
                urlStr = String.valueOf(urlStr) + "&" + "description=" + URLEncoder.encode(description, "UTF-8");
            }
            URL url = new URL(urlStr);
            System.out.println("access: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                for (TwitterList list : this.listManager.getOwnedLists()) {
                    if (!list.getSlug().equals(originalSlug)) continue;
                    list.update(slug, isPrivate, description);
                }
                System.out.println("Status: " + status);
                System.out.println("Successfully update your list information.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int addMemberToList(String slug, long userID) {
        if (this.userInfo.getScreenName().isEmpty()) {
            return 200;
        }
        try {
            String urlStr = "http://api.twitter.com/1/:user/:list_id/members.xml";
            urlStr = urlStr.replace(":user", this.userInfo.getScreenName());
            urlStr = urlStr.replace(":list_id", slug);
            urlStr = String.valueOf(urlStr) + "?" + "id=" + userID;
            URL url = new URL(urlStr);
            System.out.println("access: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully update your list.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int addMemberToList(String slug, String name) {
        if (this.userInfo.getScreenName().isEmpty()) {
            return 200;
        }
        try {
            String urlStr = "http://api.twitter.com/1/:user/:list_id/members.xml";
            urlStr = urlStr.replace(":user", this.userInfo.getScreenName());
            urlStr = urlStr.replace(":list_id", slug);
            urlStr = String.valueOf(urlStr) + "?" + "id=" + name;
            URL url = new URL(urlStr);
            System.out.println("access: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                System.out.println("Successfully update your list.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int deleteMemberToList(String slug, long userID) {
        if (this.userInfo.getScreenName().isEmpty()) {
            return 200;
        }
        try {
            String urlStr = "http://api.twitter.com/1/:user/:list_id/members.xml";
            urlStr = urlStr.replace(":user", this.userInfo.getScreenName());
            urlStr = urlStr.replace(":list_id", slug);
            urlStr = String.valueOf(urlStr) + "?" + "id=" + userID;
            URL url = new URL(urlStr);
            System.out.println("access: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                this.listManager.remove(userID);
                System.out.println("Status: " + status);
                System.out.println("Successfully update your list.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateMembersInOwnedList(String slug) {
        for (TwitterList list : this.listManager.getOwnedLists()) {
            if (!list.getSlug().equals(slug)) continue;
            return list.getMembersInOwnedList(this.rateLimitReader, this.consumer);
        }
        return 0;
    }

    public Iterable<TwitterUserInfo> getMembersInOwnedList(String slug) {
        for (TwitterList list : this.listManager.getOwnedLists()) {
            if (!list.getSlug().equals(slug) || 200 != list.getMembersInOwnedList(this.rateLimitReader, this.consumer)) continue;
            return list.getMembers();
        }
        return new ArrayList<TwitterUserInfo>();
    }

    public int deleteOwnedList(String slug) {
        if (this.userInfo.getScreenName().isEmpty() && this.listManager.getIDFor(slug) == 0L) {
            return 200;
        }
        try {
            String urlStr = "http://api.twitter.com/1/:user/lists/:id.xml";
            urlStr = urlStr.replace(":user", this.userInfo.getScreenName());
            urlStr = urlStr.replace(":id", Long.toString(this.listManager.getIDFor(slug)));
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                this.listManager.remove(slug);
                System.out.println("Status: " + status);
                System.out.println("Successfully delete your list.");
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public Iterable<Tweet> getReplyChainFrom(Tweet tweet) {
        long id;
        ArrayList<Tweet> replyChain = new ArrayList<Tweet>();
        replyChain.add(tweet);
        while ((id = ((Tweet)replyChain.get(replyChain.size() - 1)).getInReplyToStatusId()) != 0L) {
            boolean found = false;
            for (Tweet t : this.timelineManager.getTweets()) {
                if (t.getId() != id) continue;
                replyChain.add(t);
                id = t.getInReplyToStatusId();
                found = true;
            }
            if (found) continue;
            try {
                String urlStr = "http://api.twitter.com/1/statuses/show.xml?id=" + id;
                URL url = new URL(urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                try {
                    this.consumer.sign((Object)connection);
                }
                catch (OAuthMessageSignerException e) {
                    e.printStackTrace();
                }
                catch (OAuthExpectationFailedException e) {
                    e.printStackTrace();
                }
                catch (OAuthCommunicationException e) {
                    e.printStackTrace();
                }
                int status = connection.getResponseCode();
                if (status == 200) {
                    System.out.println("Status: " + status);
                    connection.connect();
                    InputStream in = connection.getInputStream();
                    Tweet t = new Tweet();
                    if (t.load(in)) {
                        replyChain.add(t);
                    } else {
                        System.err.println("During reading tweet, some errors are occurred.");
                    }
                    this.rateLimitReader.load(connection.getHeaderFields());
                    continue;
                }
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
                break;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return replyChain;
    }

    public int updateUserInfo() {
        try {
            URL url = new URL("http://api.twitter.com/1/account/verify_credentials.xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.userInfo.load(in)) {
                    System.out.println("Successfully load your twitter account.");
                } else {
                    System.err.println("Failed to load your twitter account.");
                }
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateHomeTimeline() {
        try {
            String urlStr = "http://api.twitter.com/1/statuses/home_timeline.xml";
            ArrayList<String> args = new ArrayList<String>();
            if (this.timelineManager.getNumberOfTweets() != 0) {
                args.add("since_id=" + this.timelineManager.getLatestID());
            }
            args.add("count=" + this.conf.getCount());
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.timelineManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.timelineManager.getNumberOfTweets()) {
                        Tweet tweet = this.timelineManager.getTweet(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During timeline update, some errors are occurred.");
                }
                this.rateLimitReader.load(connection.getHeaderFields());
            } else {
                String str;
                for (String key : connection.getHeaderFields().keySet()) {
                    System.out.println(String.valueOf(key) + ": " + connection.getHeaderField(key));
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((str = reader.readLine()) != null) {
                    System.out.println(str);
                }
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateUserTimeline() {
        try {
            URL url = new URL("http://api.twitter.com/1/statuses/user_timeline.xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String str = "";
                while ((str = reader.readLine()) != null) {
                    System.out.println(str);
                }
                this.rateLimitReader.load(connection.getHeaderFields());
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateMentions() {
        try {
            String urlStr = "http://api.twitter.com/1/statuses/mentions.xml";
            ArrayList<String> args = new ArrayList<String>();
            if (this.mentionsManager.getNumberOfTweets() != 0) {
                args.add("since_id=" + this.mentionsManager.getLatestID());
            }
            args.add("count=" + this.conf.getCount());
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.mentionsManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.mentionsManager.getNumberOfTweets()) {
                        Tweet tweet = this.mentionsManager.getTweet(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During mentions update, some errors are occurred.");
                }
                this.rateLimitReader.load(connection.getHeaderFields());
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateDirectMessageInBox() {
        try {
            String urlStr = "http://api.twitter.com/1/direct_messages.xml";
            ArrayList<String> args = new ArrayList<String>();
            if (this.directMessageInBoxManager.getNumberOfDirectMessages() != 0) {
                args.add("since_id=" + this.directMessageInBoxManager.getLatestID());
            }
            args.add("count=" + this.conf.getCount());
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.directMessageInBoxManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.directMessageInBoxManager.getNumberOfDirectMessages()) {
                        DirectMessage directMessage = this.directMessageInBoxManager.getDirectMessage(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During received direct message update, some errors are occurred.");
                }
                this.rateLimitReader.load(connection.getHeaderFields());
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateDirectMessageSent() {
        try {
            String urlStr = "http://api.twitter.com/1/direct_messages/sent.xml";
            ArrayList<String> args = new ArrayList<String>();
            if (this.directMessageSentManager.getNumberOfDirectMessages() != 0) {
                args.add("since_id=" + this.directMessageSentManager.getLatestID());
            }
            args.add("count=" + this.conf.getCount());
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.directMessageSentManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.directMessageSentManager.getNumberOfDirectMessages()) {
                        DirectMessage directMessage = this.directMessageSentManager.getDirectMessage(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During sent direct message update, some errors are occurred.");
                }
                this.rateLimitReader.load(connection.getHeaderFields());
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateFavorite() {
        try {
            String urlStr = "http://api.twitter.com/1/favorites.xml";
            ArrayList<String> args = new ArrayList<String>();
            if (this.favoriteManager.getNumberOfTweets() != 0) {
                args.add("since_id=" + this.favoriteManager.getLatestID());
            }
            args.add("count=" + this.conf.getCount());
            urlStr = String.valueOf(urlStr) + "?" + (String)args.get(0);
            int i = 1;
            while (i < args.size()) {
                urlStr = String.valueOf(urlStr) + "&" + (String)args.get(i);
                ++i;
            }
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                if (this.favoriteManager.load(in)) {
                    int i2 = 0;
                    while (i2 < this.favoriteManager.getNumberOfTweets()) {
                        Tweet tweet = this.favoriteManager.getTweet(i2);
                        ++i2;
                    }
                } else {
                    System.err.println("During timeline update, some errors are occurred.");
                }
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateAllLists() {
        return this.listManager.updateAllLists(this.rateLimitReader, this.conf.getListCount(), this.consumer);
    }

    public int updateOwnedLists() {
        return this.listManager.updateOwnedLists(this.rateLimitReader, this.conf.getListCount(), this.consumer);
    }

    public int updateOwnedLists(String slug) {
        for (TwitterList list : this.listManager.getOwnedLists()) {
            if (!list.getSlug().equals(slug)) continue;
            return list.updateOwnedLists(this.rateLimitReader, this.conf.getListCount(), this.consumer);
        }
        return 200;
    }

    public int updateSubscribedLists() {
        return this.listManager.updateSubscribedLists(this.rateLimitReader, this.conf.getListCount());
    }

    public int updateMemberedLists() {
        return this.listManager.updateMemberedLists(this.rateLimitReader, this.conf.getListCount());
    }

    public int updateFrendships() {
        int status = this.updateFriendIDs();
        if (status == 200) {
            status = this.updateFollowerIDs();
            if (status != 200) {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        switch (status) {
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 500: 
            case 502: 
            case 503: {
                System.err.println("Twitter service is unavailable.");
            }
        }
        System.err.println("Unknown error code is returned: " + status);
        return status;
    }

    public int updateFriendIDs() {
        try {
            URL url = new URL("http://api.twitter.com/1/friends/ids.xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                this.friendshipManager.readFriendIDs(in);
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getFriendUserInformation() {
        if (!this.userInfo.getScreenName().isEmpty()) {
            String baseURLStr = "http://api.twitter.com/1/statuses/friends.xml?screen_name=" + this.userInfo.getScreenName();
            this.getUserInformationList(baseURLStr, true, false);
        }
        return 200;
    }

    public int getFollowerUserInformation() {
        if (!this.userInfo.getScreenName().isEmpty()) {
            String baseURLStr = "http://api.twitter.com/1/statuses/followers.xml?screen_name=" + this.userInfo.getScreenName();
            this.getUserInformationList(baseURLStr, false, true);
        }
        return 200;
    }

    public int getUserInformationList(String baseURLStr, boolean isFriend, boolean isFollower) {
        long cursor = -1L;
        while (cursor != 0L) {
            try {
                String urlStr = String.valueOf(baseURLStr) + "&" + "cursor=" + cursor;
                URL url = new URL(urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                try {
                    this.consumer.sign((Object)connection);
                }
                catch (OAuthMessageSignerException e) {
                    e.printStackTrace();
                }
                catch (OAuthExpectationFailedException e) {
                    e.printStackTrace();
                }
                catch (OAuthCommunicationException e) {
                    e.printStackTrace();
                }
                int status = connection.getResponseCode();
                if (status == 200) {
                    System.out.println("Status: " + status);
                    connection.connect();
                    InputStream in = connection.getInputStream();
                    cursor = this.friendshipManager.load(in, isFriend, isFollower);
                    continue;
                }
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                        this.rateLimitReader.load(connection.getHeaderFields());
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
                this.rateLimitReader.load(connection.getHeaderFields());
                return status;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 200;
    }

    public int updateFollowerIDs() {
        try {
            URL url = new URL("http://api.twitter.com/1/followers/ids.xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            this.rateLimitReader.load(connection.getHeaderFields());
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                this.friendshipManager.readFollowerIDs(in);
            } else {
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateRateLimit() {
        try {
            URL url = new URL("http://api.twitter.com/1/account/rate_limit_status.xml");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try {
                this.consumer.sign((Object)connection);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            int status = connection.getResponseCode();
            if (status == 200) {
                System.out.println("Status: " + status);
                connection.connect();
                InputStream in = connection.getInputStream();
                this.rateLimitReader.read(in);
                System.out.println(this.rateLimitReader);
            } else {
                this.rateLimitReader.load(connection.getHeaderFields());
                switch (status) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 500: 
                    case 502: 
                    case 503: {
                        System.err.println("Twitter service is unavailable.");
                    }
                }
                System.err.println("Unknown error code is returned: " + status);
            }
            return status;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean hasAPIRemain() {
        return this.rateLimitReader.getRemain() != 0;
    }

    public TwitterClientConfiguration configuration() {
        return this.conf;
    }

    public int getUserTimelineUpdateInterval() {
        return this.conf.getUserTimelineUpdateInterval();
    }

    public void setUserTimelineUpdateInterval(int userTimelineUpdateInterval) {
        this.conf.setUserTimelineUpdateInterval(userTimelineUpdateInterval);
    }

    public int getMentionsUpdateInterval() {
        return this.conf.getMentionsUpdateInterval();
    }

    public void setMentionsUpdateInterval(int mentionsUpdateInterval) {
        this.conf.setMentionsUpdateInterval(mentionsUpdateInterval);
    }

    public int getDirectMessageUpdateInterval() {
        return this.conf.getDirectMessageUpdateInterval();
    }

    public void setDirectMessageUpdateInterval(int directMessageUpdateInterval) {
        this.conf.setDirectMessageUpdateInterval(directMessageUpdateInterval);
    }

    public int getFavoriteUpdateInterval() {
        return this.conf.getFavoriteUpdateInterval();
    }

    public void setFavoriteUpdateInterval(int favoriteUpdateInterval) {
        this.conf.setFavoriteUpdateInterval(favoriteUpdateInterval);
    }

    public int getListUpdateInterval() {
        return this.conf.getListUpdateInterval();
    }

    public void setListUpdateInterval(int listUpdateInterval) {
        this.conf.setListUpdateInterval(listUpdateInterval);
    }

    public Iterable<Tweet> getTimeline() {
        return this.filterManager.getFilteredTweets(this.timelineManager.getTweets());
    }

    public Iterable<Tweet> getRawTimeline() {
        return this.timelineManager.getTweets();
    }

    public Iterable<Tweet> getTimelineInFilterFor(String name) {
        return this.filterManager.getTweetsInFilterFor(name);
    }

    public Iterable<String> getFilterNames() {
        return this.filterManager.getFilterNames();
    }

    public Iterable<Tweet> getMentions() {
        return this.mentionsManager.getTweets();
    }

    public Iterable<DirectMessage> getReceivedDirectMessages() {
        return this.directMessageInBoxManager.getDirectMessages();
    }

    public Iterable<DirectMessage> getSentDirectMessages() {
        return this.directMessageSentManager.getDirectMessages();
    }

    public Iterable<Tweet> getFavorite() {
        ArrayList<Tweet> tweets = new ArrayList<Tweet>();
        for (Tweet t : this.favoriteManager.getTweets()) {
            if (!t.isFavorited()) continue;
            tweets.add(t);
        }
        return tweets;
    }

    public boolean isUpdateTimelineAfterPost() {
        return this.conf.isUpdateTimelineAfterPost();
    }

    public void setUpdateTimelineAfterPost(boolean updateTimelineAfterPost) {
        this.conf.setUpdateTimelineAfterPost(updateTimelineAfterPost);
    }

    public int getCount() {
        return this.conf.getCount();
    }

    public void setCount(int count) {
        this.conf.setCount(count);
    }

    public int getRemain() {
        return this.rateLimitReader.getRemain();
    }

    public int getRateLimit() {
        return this.rateLimitReader.getRateLimit();
    }

    public Calendar getResetTime() {
        Calendar cal = this.rateLimitReader.getResetTime();
        cal.add(13, this.userInfo.getUtcOffset());
        return cal;
    }

    public Date getResetTimeInDate() {
        Calendar cal = this.rateLimitReader.getResetTime();
        cal.add(13, this.userInfo.getUtcOffset());
        return cal.getTime();
    }

    public Calendar getAPIResetTime() {
        Calendar cal = this.rateLimitReader.getAPIResetTime();
        return cal;
    }

    public Date getAPIResetTimeInDate() {
        Calendar cal = this.rateLimitReader.getAPIResetTime();
        return cal.getTime();
    }

    public int getCurrentSpeedPerHour() {
        return this.timelineManager.getCurrentTweetsPerHousr();
    }

    public ArrayList<String> getOwnedListNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (TwitterList list : this.listManager.getOwnedLists()) {
            result.add(list.getFullName());
        }
        return result;
    }

    public ArrayList<String> getSubscribedListNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (TwitterList list : this.listManager.getSubscribedLists()) {
            result.add(list.getFullName());
        }
        return result;
    }

    public ArrayList<String> getMemberedListNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (TwitterList list : this.listManager.getMemberedLists()) {
            result.add(list.getFullName());
        }
        return result;
    }

    public Iterable<TwitterList> getAllLists() {
        return this.listManager.getAllLists();
    }

    public Iterable<TwitterList> getOwnedLists() {
        return this.listManager.getOwnedLists();
    }

    public Iterable<TwitterList> getSubscribedLists() {
        return this.listManager.getSubscribedLists();
    }

    public Iterable<TwitterList> getMemberedLists() {
        return this.listManager.getMemberedLists();
    }

    public void addFilter(TimelineFilter filter) {
        this.filterManager.add(filter);
    }

    public TimelineFilter getFilter(String filterName) {
        return this.filterManager.get(filterName);
    }

    public void removeFilter(String filterName) {
        this.filterManager.remove(filterName);
    }

    public void updateFilter(String originalName, String name, ArrayList<String> includeUsers, ArrayList<String> includeWords, ArrayList<String> excludeUsers, ArrayList<String> excludeWords, boolean removeFromTimeline) {
        this.filterManager.update(originalName, name, includeUsers, includeWords, excludeUsers, excludeWords, removeFromTimeline);
    }

    public boolean isFollowingEachOther(long id) {
        if (this.userInfo.getId() == id) {
            return true;
        }
        return this.friendshipManager.isFollowingEachOther(id);
    }

    public ArrayList<TwitterUserInfo> getAllKnownUsers() {
        this.getFriendUserInformation();
        this.getFollowerUserInformation();
        ArrayList<TwitterUserInfo> result = new ArrayList<TwitterUserInfo>();
        result.addAll(this.friendshipManager.getFriends());
        for (TwitterUserInfo user : this.friendshipManager.getFollowers()) {
            boolean found = false;
            long id = user.getId();
            for (TwitterUserInfo u : result) {
                if (u.getId() != id) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList<TwitterUserInfo> getUsersInTimeline() {
        ArrayList<TwitterUserInfo> result = new ArrayList<TwitterUserInfo>();
        ArrayList<Long> skipIDs = new ArrayList<Long>();
        for (Tweet t : this.timelineManager.getTweets()) {
            long id = t.getUser().getId();
            if (skipIDs.contains(id)) continue;
            result.add(t.getUser());
            skipIDs.add(id);
        }
        return result;
    }
}

