/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TwitterClientConfiguration {
    private int userTimelineUpdateInterval = 60;
    private int mentionsUpdateInterval = 120;
    private int directMessageUpdateInterval = 300;
    private int favoriteUpdateInterval = 300;
    private int listUpdateInterval = 300;
    private boolean updateTimelineAfterPost = false;
    private final int maxCount = 200;
    private int count = 100;
    private int listCount = 20;
    private final String configFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "update_config.xml";

    public TwitterClientConfiguration() {
        System.out.println("Read configuration from: " + this.configFileName);
        File configFile = new File(this.configFileName);
        if (configFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(configFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node node;
                    int j;
                    NodeList nodelist;
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("timeline-update-interval")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.userTimelineUpdateInterval = Integer.parseInt(node.getNodeValue());
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("mentions-update-interval")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.mentionsUpdateInterval = Integer.parseInt(node.getNodeValue());
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("direct-message-update-interval")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.directMessageUpdateInterval = Integer.parseInt(node.getNodeValue());
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("favorite-update-interval")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.favoriteUpdateInterval = Integer.parseInt(node.getNodeValue());
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("list-update-interval")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.listUpdateInterval = Integer.parseInt(node.getNodeValue());
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("update-timeline-after-post")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.updateTimelineAfterPost = Boolean.parseBoolean(node.getNodeValue());
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("get-tweet-number")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.count = Integer.parseInt(node.getNodeValue());
                                if (this.count > 200) {
                                    this.count = 200;
                                }
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("get-tweet-number-in-list")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.listCount = Integer.parseInt(node.getNodeValue());
                                if (this.listCount > 200) {
                                    this.listCount = 200;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.writeConfigurationFile();
        }
    }

    public void writeConfigurationFile() {
        FileOutputStream out = null;
        try {
            File configFile = new File(this.configFileName);
            File dir = configFile.getParentFile();
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Cannot create client directory");
                System.exit(1);
            }
            out = new FileOutputStream(this.configFileName);
            Document doc = null;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            DOMImplementation impl = bld.getDOMImplementation();
            doc = impl.createDocument("", "config", null);
            doc.setXmlStandalone(true);
            Element root = doc.getDocumentElement();
            Element tlUp = doc.createElement("timeline-update-interval");
            tlUp.appendChild(doc.createTextNode(Integer.toString(this.userTimelineUpdateInterval)));
            Element mUp = doc.createElement("mentions-update-interval");
            mUp.appendChild(doc.createTextNode(Integer.toString(this.mentionsUpdateInterval)));
            Element dmUp = doc.createElement("direct-message-update-interval");
            dmUp.appendChild(doc.createTextNode(Integer.toString(this.directMessageUpdateInterval)));
            Element fUp = doc.createElement("favorite-update-interval");
            fUp.appendChild(doc.createTextNode(Integer.toString(this.favoriteUpdateInterval)));
            Element lUp = doc.createElement("list-update-interval");
            lUp.appendChild(doc.createTextNode(Integer.toString(this.listUpdateInterval)));
            Element upAfter = doc.createElement("update-timeline-after-post");
            upAfter.appendChild(doc.createTextNode(Boolean.toString(this.updateTimelineAfterPost)));
            Element tweetNum = doc.createElement("get-tweet-number");
            tweetNum.appendChild(doc.createTextNode(Integer.toString(this.count)));
            Element tweetListNum = doc.createElement("get-tweet-number-in-list");
            tweetListNum.appendChild(doc.createTextNode(Integer.toString(this.count)));
            root.appendChild(tlUp);
            root.appendChild(mUp);
            root.appendChild(dmUp);
            root.appendChild(fUp);
            root.appendChild(lUp);
            root.appendChild(upAfter);
            root.appendChild(tweetNum);
            root.appendChild(tweetListNum);
            DOMSource dsrc = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult sr = new StreamResult(out);
            transformer.transform(dsrc, sr);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public int getUserTimelineUpdateInterval() {
        return this.userTimelineUpdateInterval;
    }

    public void setUserTimelineUpdateInterval(int userTimelineUpdateInterval) {
        this.userTimelineUpdateInterval = userTimelineUpdateInterval;
    }

    public int getMentionsUpdateInterval() {
        return this.mentionsUpdateInterval;
    }

    public void setMentionsUpdateInterval(int mentionsUpdateInterval) {
        this.mentionsUpdateInterval = mentionsUpdateInterval;
    }

    public int getDirectMessageUpdateInterval() {
        return this.directMessageUpdateInterval;
    }

    public void setDirectMessageUpdateInterval(int directMessageUpdateInterval) {
        this.directMessageUpdateInterval = directMessageUpdateInterval;
    }

    public int getFavoriteUpdateInterval() {
        return this.favoriteUpdateInterval;
    }

    public void setFavoriteUpdateInterval(int favoriteUpdateInterval) {
        this.favoriteUpdateInterval = favoriteUpdateInterval;
    }

    public int getListUpdateInterval() {
        return this.listUpdateInterval;
    }

    public void setListUpdateInterval(int listUpdateInterval) {
        this.listUpdateInterval = listUpdateInterval;
    }

    public boolean isUpdateTimelineAfterPost() {
        return this.updateTimelineAfterPost;
    }

    public void setUpdateTimelineAfterPost(boolean updateTimelineAfterPost) {
        this.updateTimelineAfterPost = updateTimelineAfterPost;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (count > 200) {
            this.count = 200;
        }
        this.count = count;
    }

    public int getListCount() {
        return this.listCount;
    }

    public void setListCount(int listCount) {
        if (listCount > 200) {
            this.listCount = 200;
        }
        this.listCount = listCount;
    }
}

