/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.Tweet;

public class TimelineManager {
    private ArrayList<Tweet> tweets = new ArrayList();
    private long latestID = 0L;
    private int currentSpeedPerHour;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(InputStream in) {
        boolean isNotEmpty = !this.tweets.isEmpty();
        int loadCount = 0;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (true) {
                if (i >= childNodes.getLength()) {
                    if (this.tweets.size() < 100) break;
                    long t0time = this.tweets.get(0).getCreatedDate().getTime();
                    long t99time = this.tweets.get(99).getCreatedDate().getTime();
                    double speed = 100.0 / (double)(t0time - t99time) * 1000.0;
                    this.currentSpeedPerHour = (int)(speed * 3600.0);
                    return true;
                }
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals("status")) {
                    Tweet tweet = new Tweet();
                    if (!tweet.load(nodes.getChildNodes())) {
                        System.out.println("Faild to load tweet");
                        return false;
                    }
                    if (isNotEmpty) {
                        this.tweets.add(loadCount, tweet);
                    } else {
                        this.tweets.add(tweet);
                    }
                    ++loadCount;
                    this.latestID = Math.max(this.latestID, tweet.getId());
                }
                ++i;
            }
            long t0time = this.tweets.get(0).getCreatedDate().getTime();
            long tltime = this.tweets.get(this.tweets.size() - 1).getCreatedDate().getTime();
            double speed = (double)this.tweets.size() / (double)(t0time - tltime) * 1000.0;
            this.currentSpeedPerHour = (int)(speed * 3600.0);
            return true;
        }
        catch (Exception e) {
            System.err.println("During reading timeline, we meets error.");
            System.exit(1);
        }
        return true;
    }

    public long getLatestID() {
        return this.latestID;
    }

    public Tweet getTweet(int index) {
        return this.tweets.get(index);
    }

    public ArrayList<Tweet> getTweets() {
        return this.tweets;
    }

    public int getNumberOfTweets() {
        return this.tweets.size();
    }

    public int getCurrentTweetsPerHousr() {
        return this.currentSpeedPerHour;
    }
}

