/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.Tweet;

public class TimelineFilter {
    private ArrayList<String> includeUsers;
    private ArrayList<String> includeWords;
    private ArrayList<String> excludeUsers;
    private ArrayList<String> excludeWords;
    private boolean removeFromTimeline;
    private String name;
    private ArrayList<Tweet> tweets = new ArrayList();
    private long latestID = 0L;

    public TimelineFilter() {
        this("", new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), true);
    }

    public TimelineFilter(String name) {
        this(name, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), true);
    }

    public TimelineFilter(String name, ArrayList<String> includeUsers, ArrayList<String> includeWords, ArrayList<String> excludeUsers, ArrayList<String> excludeWords, boolean removeFromTimeline) {
        this.name = name;
        this.includeUsers = includeUsers;
        this.includeWords = includeWords;
        this.excludeUsers = excludeUsers;
        this.excludeWords = excludeWords;
        this.removeFromTimeline = removeFromTimeline;
        this.tweets = new ArrayList();
    }

    public boolean readFromFile(String filename) {
        System.out.println("Read timeline filter from: " + filename);
        File configFile = new File(filename);
        if (configFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(configFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node node;
                    int j;
                    NodeList nodelist;
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("filter-name")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.name = node.getNodeValue();
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("include-users")) {
                        this.readAndAddElements(nodes.getChildNodes(), this.includeUsers);
                    } else if (nodeName.equals("include-words")) {
                        this.readAndAddElements(nodes.getChildNodes(), this.includeWords);
                    } else if (nodeName.equals("exclude-users")) {
                        this.readAndAddElements(nodes.getChildNodes(), this.excludeUsers);
                    } else if (nodeName.equals("exclude-words")) {
                        this.readAndAddElements(nodes.getChildNodes(), this.excludeWords);
                    } else if (nodeName.equals("remove-from-timeline")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.removeFromTimeline = Boolean.parseBoolean(node.getNodeValue());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return false;
        }
        return true;
    }

    private void readAndAddElements(NodeList nodelist, ArrayList<String> lists) {
        int i = 0;
        while (i < nodelist.getLength()) {
            Node n = nodelist.item(i);
            NodeList childNodes = n.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node node = childNodes.item(j);
                if (node.getNodeType() == 3) {
                    lists.add(node.getNodeValue());
                }
                ++j;
            }
            ++i;
        }
    }

    public void writeFilter() {
        String filename = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "filter" + File.separator + this.name + ".xml";
        FileOutputStream out = null;
        try {
            File configFile = new File(filename);
            File dir = configFile.getParentFile();
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Cannot create client directory");
                System.exit(1);
            }
            System.out.println("Write timeline filter to: " + filename);
            out = new FileOutputStream(filename);
            Document doc = null;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            DOMImplementation impl = bld.getDOMImplementation();
            doc = impl.createDocument("", "filter", null);
            doc.setXmlStandalone(true);
            Element root = doc.getDocumentElement();
            Element nm = doc.createElement("filter-name");
            nm.appendChild(doc.createTextNode(this.name));
            root.appendChild(nm);
            Element rft = doc.createElement("remove-from-timeline");
            rft.appendChild(doc.createTextNode(Boolean.toString(this.removeFromTimeline)));
            root.appendChild(rft);
            root.appendChild(this.generateElements(doc, "include-users", "user", this.includeUsers));
            root.appendChild(this.generateElements(doc, "include-words", "word", this.includeWords));
            root.appendChild(this.generateElements(doc, "exclude-users", "user", this.excludeUsers));
            root.appendChild(this.generateElements(doc, "exclude-words", "word", this.excludeWords));
            DOMSource dsrc = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult sr = new StreamResult(out);
            transformer.transform(dsrc, sr);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private Element generateElements(Document doc, String tagName, String subTagName, ArrayList<String> lists) {
        Element element = doc.createElement(tagName);
        for (String str : lists) {
            Element child = doc.createElement(subTagName);
            child.appendChild(doc.createTextNode(str));
            element.appendChild(child);
        }
        return element;
    }

    public boolean delete() {
        String filename = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "filter" + File.separator + this.name + ".xml";
        File file = new File(filename);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public void update(String name, ArrayList<String> includeUsers, ArrayList<String> includeWords, ArrayList<String> excludeUsers, ArrayList<String> excludeWords, boolean removeFromTimeline) {
        if (!name.equals(this.getName())) {
            this.delete();
        }
        this.tweets = new ArrayList();
        this.latestID = 0L;
        this.name = name;
        this.removeFromTimeline = removeFromTimeline;
        this.includeUsers.clear();
        this.includeUsers.addAll(includeUsers);
        this.includeWords.clear();
        this.includeWords.addAll(includeWords);
        this.excludeUsers.clear();
        this.excludeUsers.addAll(excludeUsers);
        this.excludeWords.clear();
        this.excludeWords.addAll(excludeWords);
    }

    public void filter(Iterable<Tweet> tweets) {
        boolean isEmpty = this.tweets.isEmpty();
        int count = 0;
        for (Tweet t : tweets) {
            if (t.getId() <= this.latestID) break;
            String userName = t.getUser().getScreenName();
            String text = t.getText();
            boolean add = false;
            if (this.includeUsers.contains(userName)) {
                add = true;
                for (String word : this.excludeWords) {
                    if (!text.contains(word)) continue;
                    add = false;
                    break;
                }
            } else if (!this.excludeUsers.contains(userName)) {
                for (String word : this.includeWords) {
                    if (!text.contains(word)) continue;
                    add = true;
                    break;
                }
            }
            if (!add) continue;
            if (!isEmpty) {
                this.tweets.add(count, t);
            } else {
                this.tweets.add(t);
            }
            ++count;
        }
        if (!this.tweets.isEmpty()) {
            this.latestID = Math.max(this.latestID, this.tweets.get(0).getId());
        }
    }

    public ArrayList<Tweet> getFilteredTweet() {
        return this.tweets;
    }

    public ArrayList<String> getIncludeUsers() {
        return this.includeUsers;
    }

    public ArrayList<String> getIncludeWords() {
        return this.includeWords;
    }

    public ArrayList<String> getExcludeUsers() {
        return this.excludeUsers;
    }

    public ArrayList<String> getExcludeWords() {
        return this.excludeWords;
    }

    public boolean isRemoveFromTimeline() {
        return this.removeFromTimeline;
    }

    public String getName() {
        return this.name;
    }
}

