/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateLimitReader {
    private int remain;
    private int rateLimit;
    private Calendar resetTime;
    private Calendar apiResetTime;

    public boolean read(InputStream in) {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node;
                int j;
                NodeList nodelist;
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals("remaining-hits")) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            int r = Integer.parseInt(node.getNodeValue());
                            if (r > this.remain || this.apiResetTime == null) {
                                this.apiResetTime = Calendar.getInstance();
                                this.apiResetTime.add(10, 1);
                            }
                            this.remain = r;
                        }
                        ++j;
                    }
                } else if (nodeName.equals("hourly-limit")) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.rateLimit = Integer.parseInt(node.getNodeValue());
                        }
                        ++j;
                    }
                } else if (nodeName.equals("reset-time-in-seconds")) {
                    nodelist = nodes.getChildNodes();
                    j = 0;
                    while (j < nodelist.getLength()) {
                        node = nodelist.item(j);
                        if (node.getNodeType() == 3) {
                            this.resetTime = Calendar.getInstance();
                            int reset = Integer.parseInt(node.getNodeValue());
                            this.resetTime.add(14, reset);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void load(Map<String, List<String>> headers) {
        if (headers.containsKey("X-RateLimit-Limit")) {
            this.rateLimit = Integer.parseInt(headers.get("X-RateLimit-Limit").get(0));
        }
        if (headers.containsKey("X-RateLimit-Remaining")) {
            int r = Integer.parseInt(headers.get("X-RateLimit-Remaining").get(0));
            if (r > this.remain || this.apiResetTime == null) {
                this.apiResetTime = Calendar.getInstance();
                this.apiResetTime.add(10, 1);
            }
            this.remain = r;
        }
        if (headers.containsKey("X-RateLimit-Reset")) {
            this.resetTime = Calendar.getInstance();
            int reset = Integer.parseInt(headers.get("X-RateLimit-Reset").get(0));
            this.resetTime.add(14, reset);
        }
    }

    public int getRemain() {
        return this.remain;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public Calendar getResetTime() {
        return this.resetTime;
    }

    public Date getResetTimeInDate() {
        return this.resetTime.getTime();
    }

    public Calendar getAPIResetTime() {
        return this.apiResetTime;
    }

    public Date getAPIResetTimeInDate() {
        return this.apiResetTime.getTime();
    }

    public String toString() {
        return String.valueOf(this.remain) + "/" + this.rateLimit + ", " + this.resetTime.getTime();
    }
}

