/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.awt.Cursor;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import twitclient.DirectMessage;
import twitclient.OSChecker;
import twitclient.TimelineFilter;
import twitclient.Tweet;
import twitclient.TwitterClientController;
import twitclient.gui.ClientComponentConfiguration;
import twitclient.gui.ClientMainFrame;
import twitclient.gui.ClientShortcutKeyManager;

public class NTRClient {
    private static NTRClient client = new NTRClient();
    Cursor waitCursor = new Cursor(3);
    Cursor defaultCursor = new Cursor(0);
    ClientMainFrame mainFrame;
    TwitterClientController twitterController = new TwitterClientController();

    private NTRClient() {
    }

    public static NTRClient getInstance() {
        return client;
    }

    public static void main(String[] args) {
        NTRClient client = NTRClient.getInstance();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NTRClient.this.createAndShowGUI();
            }
        });
    }

    public void writeConfigurationFiles() {
        ClientComponentConfiguration.getInstance().writeConfigurationFile();
        ClientShortcutKeyManager.getInstance().writeConfigurationFile();
        this.twitterController.writeConfigurationFile();
    }

    public ClientMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public TwitterClientController getTwitterController() {
        return this.twitterController;
    }

    protected void createAndShowGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(10);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(10);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(10);
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
            System.exit(10);
        }
        if (OSChecker.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.getClass().getSimpleName());
        }
        this.mainFrame = new ClientMainFrame(this.getClass().getSimpleName());
        this.mainFrame.addWindowListener(this.mainFrame);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.twitterController.connectToTwitter(this.mainFrame);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateFilterList(this.twitterController.getFilterNames());
        this.twitterController.start(this.mainFrame);
    }

    public int postTweet(String tweetMessage) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.postTweet(tweetMessage);
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        if (this.twitterController.isUpdateTimelineAfterPost()) {
            this.updateHomeTimeline();
        }
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int postTweet(String tweetMessage, Tweet target) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.postTweet(tweetMessage, target.getId());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        if (this.twitterController.isUpdateTimelineAfterPost()) {
            this.updateHomeTimeline();
        }
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int deleteTweet(Tweet target) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.deleteTweet(target.getId());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int retweet(Tweet target) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.retweet(target.getId());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int sendDirectMessage(String text, long id) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.sendDirectMessage(text, id);
        this.mainFrame.updateDirectMessageView(this.twitterController.getSentDirectMessages(), "sent");
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int sendDirectMessage(String text, String screenName) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.sendDirectMessage(text, screenName);
        this.mainFrame.updateDirectMessageView(this.twitterController.getSentDirectMessages(), "sent");
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int destroyDirectMessage(DirectMessage dm) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.deleteDirectMessage(dm.getID());
        this.mainFrame.updateDirectMessageView(this.twitterController.getSentDirectMessages(), "sent");
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int createFavorite(Tweet target) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.createFavorite(target.getId());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int destroyFavorite(Tweet target) {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.destroyFavorite(target.getId());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateUserInfo() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        return 200;
    }

    public int updateRateLimit() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateRateLimit();
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateHomeTimeline() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateHomeTimeline();
        this.mainFrame.updateTimelineView(this.twitterController.getTimeline());
        for (String filterName : this.twitterController.getFilterNames()) {
            this.mainFrame.updateFilterView(this.twitterController.getTimelineInFilterFor(filterName), filterName);
        }
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateUserTimeline() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateUserTimeline();
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateMentions() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateMentions();
        this.mainFrame.updateMentionsView(this.twitterController.getMentions());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateDirectMessageInBox() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateDirectMessageInBox();
        this.mainFrame.updateDirectMessageView(this.twitterController.getReceivedDirectMessages(), "inbox");
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateDirectMessageSent() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateDirectMessageInBox();
        this.mainFrame.updateDirectMessageView(this.twitterController.getSentDirectMessages(), "sent");
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateFavorite() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateFavorite();
        this.mainFrame.updateFavoriteView(this.twitterController.getFavorite());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateFriendship() {
        if (!this.twitterController.hasAPIRemain()) {
            this.mainFrame.alertBecauseOfNoAPI(this.twitterController.getAPIResetTimeInDate().toString());
            return 200;
        }
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateFrendships();
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateOwnedList() {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateOwnedLists();
        this.mainFrame.updateListView(this.twitterController.getOwnedLists());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateOwnedList(String slug) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateOwnedLists(slug);
        this.mainFrame.updateListView(this.twitterController.getOwnedLists());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateSubscribedList() {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateSubscribedLists();
        this.mainFrame.updateListView(this.twitterController.getSubscribedLists());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public void addFilter(String name, ArrayList<String> includeUsers, ArrayList<String> includeWords, ArrayList<String> excludeUsers, ArrayList<String> excludeWords, boolean removeFromTimeline) {
        TimelineFilter filter = new TimelineFilter(name, includeUsers, includeWords, excludeUsers, excludeWords, removeFromTimeline);
        this.twitterController.addFilter(filter);
        this.mainFrame.updateTimelineView(this.twitterController.getTimeline());
        this.mainFrame.updateFilterList(this.twitterController.getFilterNames());
        for (String filterName : this.twitterController.getFilterNames()) {
            this.mainFrame.updateFilterView(this.twitterController.getTimelineInFilterFor(filterName), filterName);
        }
    }

    public void updateFilter(String originalName, String name, ArrayList<String> includeUsers, ArrayList<String> includeWords, ArrayList<String> excludeUsers, ArrayList<String> excludeWords, boolean removeFromTimeline) {
        this.twitterController.updateFilter(originalName, name, includeUsers, includeWords, excludeUsers, excludeWords, removeFromTimeline);
        this.mainFrame.updateTimelineView(this.twitterController.getTimeline());
        this.mainFrame.updateFilterList(this.twitterController.getFilterNames());
        for (String filterName : this.twitterController.getFilterNames()) {
            this.mainFrame.updateFilterView(this.twitterController.getTimelineInFilterFor(filterName), filterName);
        }
    }

    public void updateFilters() {
        this.mainFrame.updateTimelineView(this.twitterController.getTimeline());
        this.mainFrame.updateFilterList(this.twitterController.getFilterNames());
        for (String filterName : this.twitterController.getFilterNames()) {
            this.mainFrame.updateFilterView(this.twitterController.getTimelineInFilterFor(filterName), filterName);
        }
    }

    public void removeFilter(String filterName) {
        this.twitterController.removeFilter(filterName);
    }

    public int createList(String slug, boolean isPrivate, String description) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.createList(slug, isPrivate, description);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int updateList(String originalSlug, String slug, boolean isPrivate, String description) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.updateOwnedList(originalSlug, slug, isPrivate, description);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int addMemberToList(String slug, long id) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.addMemberToList(slug, id);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int addMemberToList(String slug, String name) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.addMemberToList(slug, name);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int removeMemberToList(String slug, long id) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.deleteMemberToList(slug, id);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }

    public int removeList(String slug) {
        this.mainFrame.setCursor(this.waitCursor);
        int status = this.twitterController.deleteOwnedList(slug);
        this.mainFrame.updateListOfLists(this.twitterController.getOwnedListNames(), this.twitterController.getSubscribedListNames());
        this.mainFrame.updateStatus(this.twitterController.getRemain(), this.twitterController.getRateLimit(), this.twitterController.getResetTimeInDate().toString(), this.twitterController.getCurrentSpeedPerHour());
        this.mainFrame.setCursor(this.defaultCursor);
        return status;
    }
}

